/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.flows.StateMachineRunId;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.ThreadBox;
import net.corda.core.messaging.MessageRecipients;
import net.corda.core.node.services.PartyInfo;
import net.corda.core.serialization.SingletonSerializeAsToken;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.node.services.messaging.DeduplicationHandler;
import net.corda.node.services.messaging.Message;
import net.corda.node.services.messaging.MessageHandlerRegistration;
import net.corda.node.services.messaging.MessagingService;
import net.corda.node.services.messaging.ReceivedMessage;
import net.corda.node.services.statemachine.DeduplicationId;
import net.corda.node.services.statemachine.ExternalEvent;
import net.corda.node.services.statemachine.SenderDeduplicationId;
import net.corda.node.utilities.AffinityExecutor;
import net.corda.nodeapi.internal.lifecycle.ServiceStateHelper;
import net.corda.nodeapi.internal.lifecycle.ServiceStateSupport;
import net.corda.testing.node.InMemoryMessagingNetwork;
import net.corda.testing.node.internal.InMemoryMessage;
import net.corda.testing.node.internal.MessagingServiceSpy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import rx.Observable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0007\u0018\u0000 e2\u00020\u00012\u00020\u00022\u00020\u0003:\u0005efghiB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ4\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001d2\"\u00100\u001a\u001e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020401j\u0002`5H\u0016J\b\u00106\u001a\u000204H\u0016J4\u00107\u001a\u0002082\u0006\u0010/\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0>H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J6\u0010C\u001a\u001a\u0012\u0004\u0012\u00020E\u0012\u000e\u0012\f\u0012\b\u0012\u00060GR\u00020\u00000F\u0018\u00010D2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020E0I2\u0006\u0010J\u001a\u00020\u000eH\u0002J\u0006\u0010K\u001a\u00020\u000eJ\u0010\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020\u0000H\u0002J\u0010\u0010N\u001a\u0004\u0018\u00010E2\u0006\u0010J\u001a\u00020\u000eJ\u0012\u0010O\u001a\u0004\u0018\u00010E2\u0006\u0010J\u001a\u00020\u000eH\u0002J\u0010\u0010P\u001a\u0002042\u0006\u0010Q\u001a\u00020.H\u0016J \u0010R\u001a\u0002042\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020VH\u0016J\u0016\u0010W\u001a\u0002042\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0FH\u0016J\b\u0010Z\u001a\u000204H\u0016J(\u0010Z\u001a\u0002042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010[\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020]2\b\u0010^\u001a\u0004\u0018\u00010_J\b\u0010`\u001a\u000204H\u0016J\u0016\u0010a\u001a\u0002042\f\u0010b\u001a\b\u0012\u0004\u0012\u00020E0cH\u0002J\f\u0010d\u001a\u000202*\u00020EH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0018\u0010*\u001a\f\u0012\b\u0012\u00060,R\u00020\u00000+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService;", "Lnet/corda/core/serialization/SingletonSerializeAsToken;", "Lnet/corda/node/services/messaging/MessagingService;", "Lnet/corda/nodeapi/internal/lifecycle/ServiceStateSupport;", "configuration", "Lnet/corda/node/services/config/NodeConfiguration;", "executor", "Lnet/corda/node/utilities/AffinityExecutor;", "stateHelper", "Lnet/corda/nodeapi/internal/lifecycle/ServiceStateHelper;", "(Lnet/corda/node/services/config/NodeConfiguration;Lnet/corda/node/utilities/AffinityExecutor;Lnet/corda/nodeapi/internal/lifecycle/ServiceStateHelper;)V", "_myAddress", "Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "active", "", "getActive", "()Z", "activeChange", "Lrx/Observable;", "getActiveChange", "()Lrx/Observable;", "backgroundThread", "Ljava/lang/Thread;", "myAddress", "getMyAddress", "()Lnet/corda/testing/node/InMemoryMessagingNetwork$PeerHandle;", "network", "Lnet/corda/testing/node/InMemoryMessagingNetwork;", "ourSenderUUID", "", "getOurSenderUUID", "()Ljava/lang/String;", "processedMessages", "", "Lnet/corda/node/services/statemachine/DeduplicationId;", "running", "spy", "Lnet/corda/testing/node/internal/MessagingServiceSpy;", "getSpy", "()Lnet/corda/testing/node/internal/MessagingServiceSpy;", "setSpy", "(Lnet/corda/testing/node/internal/MessagingServiceSpy;)V", "state", "Lnet/corda/core/internal/ThreadBox;", "Lnet/corda/testing/node/internal/MockNodeMessagingService$InnerState;", "addMessageHandler", "Lnet/corda/node/services/messaging/MessageHandlerRegistration;", "topic", "callback", "Lkotlin/Function3;", "Lnet/corda/node/services/messaging/ReceivedMessage;", "Lnet/corda/node/services/messaging/DeduplicationHandler;", "", "Lnet/corda/node/services/messaging/MessageHandler;", "close", "createMessage", "Lnet/corda/node/services/messaging/Message;", "data", "", "deduplicationId", "Lnet/corda/node/services/statemachine/SenderDeduplicationId;", "additionalHeaders", "", "getAddressOfParty", "Lnet/corda/core/messaging/MessageRecipients;", "partyInfo", "Lnet/corda/core/node/services/PartyInfo;", "getNextQueue", "Lkotlin/Pair;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "", "Lnet/corda/testing/node/internal/MockNodeMessagingService$Handler;", "q", "Ljava/util/concurrent/LinkedBlockingQueue;", "block", "hasPendingDeliveries", "inheritPendingRedelivery", "other", "pumpReceive", "pumpReceiveInternal", "removeMessageHandler", "registration", "send", "message", "target", "sequenceKey", "", "sendAll", "addressedMessages", "Lnet/corda/node/services/messaging/MessagingService$AddressedMessage;", "start", "manuallyPumped", "id", "", "notaryService", "Lnet/corda/core/identity/PartyAndCertificate;", "stop", "unPopMessages", "transfers", "", "toReceivedMessage", "Companion", "Handler", "InMemoryDeduplicationHandler", "InMemoryReceivedMessage", "InnerState", "node-driver"})
@ThreadSafe
public final class MockNodeMessagingService
extends SingletonSerializeAsToken
implements MessagingService,
ServiceStateSupport {
    private volatile boolean running;
    private final ThreadBox<InnerState> state;
    private final Set<DeduplicationId> processedMessages;
    @NotNull
    private final String ourSenderUUID;
    private InMemoryMessagingNetwork.PeerHandle _myAddress;
    private InMemoryMessagingNetwork network;
    private Thread backgroundThread;
    @Nullable
    private MessagingServiceSpy spy;
    private final NodeConfiguration configuration;
    private final AffinityExecutor executor;
    private final ServiceStateHelper stateHelper;
    private static final Logger log;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public String getOurSenderUUID() {
        return this.ourSenderUUID;
    }

    @NotNull
    public InMemoryMessagingNetwork.PeerHandle getMyAddress() {
        InMemoryMessagingNetwork.PeerHandle peerHandle = this._myAddress;
        if (peerHandle == null) {
            String string = "Not started";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return peerHandle;
    }

    @Nullable
    public final MessagingServiceSpy getSpy() {
        return this.spy;
    }

    public final void setSpy(@Nullable MessagingServiceSpy messagingServiceSpy) {
        this.spy = messagingServiceSpy;
    }

    public void start() {
        throw (Throwable)new IllegalAccessException();
    }

    public void stop() {
        throw (Throwable)new IllegalAccessException();
    }

    public final void start(@NotNull InMemoryMessagingNetwork network, boolean manuallyPumped, int id, @Nullable PartyAndCertificate notaryService) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)network), (String)"network");
        InMemoryMessagingNetwork.PeerHandle peerHandle = new InMemoryMessagingNetwork.PeerHandle(id, this.configuration.getMyLegalName());
        this.network = network;
        this._myAddress = peerHandle;
        MockNodeMessagingService oldNode = network.initPeer$node_driver(this);
        if (oldNode != null) {
            this.inheritPendingRedelivery(oldNode);
        }
        if (!manuallyPumped) {
            this.backgroundThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"In-memory message dispatcher", (int)0, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MockNodeMessagingService this$0;

                public final void invoke() {
                    while (true) {
                        Thread thread = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                        if (thread.isInterrupted()) break;
                        try {
                            MockNodeMessagingService.access$pumpReceiveInternal(this.this$0, true);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                {
                    this.this$0 = mockNodeMessagingService;
                    super(0);
                }
            }), (int)21, null);
        }
        network.addNotaryIdentity$node_driver(this, notaryService);
        this.stateHelper.setActive(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public MessageRecipients getAddressOfParty(@NotNull PartyInfo partyInfo) {
        MessageRecipients messageRecipients;
        Intrinsics.checkParameterIsNotNull((Object)partyInfo, (String)"partyInfo");
        PartyInfo partyInfo2 = partyInfo;
        if (partyInfo2 instanceof PartyInfo.SingleNode) {
            InMemoryMessagingNetwork inMemoryMessagingNetwork = this.network;
            if (inMemoryMessagingNetwork == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"network");
            }
            InMemoryMessagingNetwork.PeerHandle peerHandle = inMemoryMessagingNetwork.getPeer$node_driver(partyInfo.getParty().getName());
            if (peerHandle == null) throw (Throwable)new IllegalArgumentException("No StartedMockNode for party " + partyInfo.getParty().getName());
            messageRecipients = (MessageRecipients)peerHandle;
            return messageRecipients;
        } else {
            if (!(partyInfo2 instanceof PartyInfo.DistributedNode)) throw new NoWhenBranchMatchedException();
            messageRecipients = (MessageRecipients)new InMemoryMessagingNetwork.DistributedServiceHandle(partyInfo.getParty());
        }
        return messageRecipients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public MessageHandlerRegistration addMessageHandler(@NotNull String topic, @NotNull Function3<? super ReceivedMessage, ? super MessageHandlerRegistration, ? super DeduplicationHandler, Unit> callback) {
        void handler;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        boolean bl = this.running;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ThreadBox<InnerState> this_$iv = this.state;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            Handler handler2;
            InnerState $receiver = (InnerState)this_$iv.getContent();
            Handler $receiver2 = handler2 = new Handler(topic, callback);
            $receiver.getHandlers().add($receiver2);
            Handler handler3 = handler2;
            ArrayList pending = new ArrayList();
            pending.addAll($receiver.getPendingRedelivery());
            $receiver.getPendingRedelivery().clear();
            pair = new Pair((Object)handler3, pending);
        }
        finally {
            lock.unlock();
        }
        Pair pair2 = pair;
        Handler handler4 = (Handler)pair2.component1();
        ArrayList transfers = (ArrayList)pair2.component2();
        this.unPopMessages(transfers);
        return (MessageHandlerRegistration)handler;
    }

    private final void unPopMessages(Collection<InMemoryMessagingNetwork.MessageTransfer> transfers) {
        ArrayList arrayList;
        InMemoryMessagingNetwork inMemoryMessagingNetwork = this.network;
        if (inMemoryMessagingNetwork == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"network");
        }
        LinkedBlockingQueue<InMemoryMessagingNetwork.MessageTransfer> messageQueue = inMemoryMessagingNetwork.getQueueForPeerHandle$node_driver(this.getMyAddress());
        ArrayList $receiver = arrayList = new ArrayList();
        messageQueue.drainTo($receiver);
        ArrayList drained = arrayList;
        messageQueue.addAll(transfers);
        messageQueue.addAll(drained);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void inheritPendingRedelivery(MockNodeMessagingService other) {
        ThreadBox<InnerState> this_$iv = this.state;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            LinkedHashSet<InMemoryMessagingNetwork.MessageTransfer> linkedHashSet;
            void this_$iv2;
            InnerState $receiver = (InnerState)this_$iv.getContent();
            ThreadBox<InnerState> threadBox = other.state;
            LinkedHashSet<InMemoryMessagingNetwork.MessageTransfer> linkedHashSet2 = $receiver.getPendingRedelivery();
            Lock lock2 = this_$iv2.getLock();
            lock2.lock();
            try {
                InnerState $receiver2 = (InnerState)this_$iv2.getContent();
                linkedHashSet = $receiver2.getPendingRedelivery();
            }
            finally {
                lock2.unlock();
            }
            LinkedHashSet<InMemoryMessagingNetwork.MessageTransfer> linkedHashSet3 = linkedHashSet;
            boolean bl = linkedHashSet2.addAll((Collection<InMemoryMessagingNetwork.MessageTransfer>)linkedHashSet3);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(@NotNull MessageHandlerRegistration registration) {
        Intrinsics.checkParameterIsNotNull((Object)registration, (String)"registration");
        boolean bl = this.running;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ThreadBox<InnerState> this_$iv = this.state;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            InnerState $receiver = (InnerState)this_$iv.getContent();
            boolean bl2 = $receiver.getHandlers().remove((Handler)registration);
            if (!bl2) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NotNull Message message, @NotNull MessageRecipients target, @NotNull Object sequenceKey) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)sequenceKey, (String)"sequenceKey");
        boolean bl = this.running;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        MessagingServiceSpy spy = this.spy;
        if (spy != null) {
            this.spy = null;
            try {
                spy.send(message, target, sequenceKey);
            }
            finally {
                this.spy = spy;
            }
        } else {
            InMemoryMessagingNetwork inMemoryMessagingNetwork = this.network;
            if (inMemoryMessagingNetwork == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"network");
            }
            inMemoryMessagingNetwork.msgSend$node_driver(this, message, target);
        }
    }

    public void sendAll(@NotNull List<MessagingService.AddressedMessage> addressedMessages) {
        Intrinsics.checkParameterIsNotNull(addressedMessages, (String)"addressedMessages");
        for (MessagingService.AddressedMessage addressedMessage : addressedMessages) {
            Message message = addressedMessage.component1();
            MessageRecipients target = addressedMessage.component2();
            Object sequenceKey = addressedMessage.component3();
            this.send(message, target, sequenceKey);
        }
    }

    public void close() {
        Thread thread = this.backgroundThread;
        if (thread != null) {
            Thread thread2;
            Thread it = thread2 = thread;
            it.interrupt();
            it.join();
        }
        this.running = false;
        this.stateHelper.setActive(false);
        InMemoryMessagingNetwork inMemoryMessagingNetwork = this.network;
        if (inMemoryMessagingNetwork == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"network");
        }
        inMemoryMessagingNetwork.netNodeHasShutdown$node_driver(this.getMyAddress());
    }

    @NotNull
    public Message createMessage(@NotNull String topic, @NotNull byte[] data, @NotNull SenderDeduplicationId deduplicationId, @NotNull Map<String, String> additionalHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)deduplicationId, (String)"deduplicationId");
        Intrinsics.checkParameterIsNotNull(additionalHeaders, (String)"additionalHeaders");
        return new InMemoryMessage(topic, (ByteSequence)new OpaqueBytes(data), deduplicationId.getDeduplicationId(), null, deduplicationId.getSenderUUID(), 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final InMemoryMessagingNetwork.MessageTransfer pumpReceive(boolean block) {
        boolean bl;
        boolean bl2 = bl = this.backgroundThread == null;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.running;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.executor.flush();
        try {
            InMemoryMessagingNetwork.MessageTransfer messageTransfer = this.pumpReceiveInternal(block);
            return messageTransfer;
        }
        finally {
            this.executor.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<InMemoryMessagingNetwork.MessageTransfer, List<Handler>> getNextQueue(LinkedBlockingQueue<InMemoryMessagingNetwork.MessageTransfer> q, boolean block) {
        InMemoryMessagingNetwork.MessageTransfer transfer;
        List list;
        List deliverTo = null;
        do {
            if ((block ? q.take() : q.poll()) == null) {
                return null;
            }
            transfer = transfer;
            ThreadBox<InnerState> this_$iv = this.state;
            Lock lock = this_$iv.getLock();
            lock.lock();
            try {
                List list2;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                InnerState $receiver = (InnerState)this_$iv.getContent();
                Iterable iterable = $receiver$iv = (Iterable)$receiver.getHandlers();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Handler it = (Handler)element$iv$iv;
                    if (!(StringsKt.isBlank((CharSequence)it.getTopicSession()) || Intrinsics.areEqual((Object)transfer.getMessage$node_driver().getTopic(), (Object)it.getTopicSession()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matchingHandlers = (List)destination$iv$iv;
                if (matchingHandlers.isEmpty()) {
                    log.warn("Message to " + transfer.getMessage$node_driver().getTopic() + " could not be delivered");
                    $receiver.getPendingRedelivery().add(transfer);
                    list2 = null;
                } else {
                    list2 = matchingHandlers;
                }
                list = list2;
            }
            finally {
                lock.unlock();
            }
        } while ((deliverTo = list) == null);
        return new Pair((Object)transfer, (Object)deliverTo);
    }

    /*
     * WARNING - void declaration
     */
    private final InMemoryMessagingNetwork.MessageTransfer pumpReceiveInternal(boolean block) {
        void transfer;
        InMemoryMessagingNetwork inMemoryMessagingNetwork = this.network;
        if (inMemoryMessagingNetwork == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"network");
        }
        LinkedBlockingQueue<InMemoryMessagingNetwork.MessageTransfer> q = inMemoryMessagingNetwork.getQueueForPeerHandle$node_driver(this.getMyAddress());
        Pair<InMemoryMessagingNetwork.MessageTransfer, List<Handler>> pair = this.getNextQueue(q, block);
        if (pair == null) {
            return null;
        }
        Pair<InMemoryMessagingNetwork.MessageTransfer, List<Handler>> pair2 = pair;
        InMemoryMessagingNetwork.MessageTransfer messageTransfer = (InMemoryMessagingNetwork.MessageTransfer)pair2.component1();
        List deliverTo = (List)pair2.component2();
        if (!this.processedMessages.contains(transfer.getMessage$node_driver().getUniqueMessageId())) {
            this.executor.execute(new Runnable(this, deliverTo, (InMemoryMessagingNetwork.MessageTransfer)transfer){
                final /* synthetic */ MockNodeMessagingService this$0;
                final /* synthetic */ List $deliverTo;
                final /* synthetic */ InMemoryMessagingNetwork.MessageTransfer $transfer;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    for (Handler handler : this.$deliverTo) {
                        try {
                            ReceivedMessage receivedMessage = MockNodeMessagingService.access$toReceivedMessage(this.this$0, this.$transfer);
                            ThreadBox this_$iv = MockNodeMessagingService.access$getState$p(this.this$0);
                            Lock lock = this_$iv.getLock();
                            lock.lock();
                            try {
                                InnerState $receiver = (InnerState)this_$iv.getContent();
                                boolean bl = $receiver.getPendingRedelivery().add(this.$transfer);
                            }
                            finally {
                                lock.unlock();
                            }
                            handler.getCallback().invoke((Object)receivedMessage, (Object)handler, (Object)this.this$0.new InMemoryDeduplicationHandler(receivedMessage, this.$transfer));
                        }
                        catch (Exception e) {
                            MockNodeMessagingService.access$Companion();
                            MockNodeMessagingService.access$getLog$cp().error("Caught exception in handler for " + (Object)((Object)this.this$0) + '/' + handler.getTopicSession(), (Throwable)e);
                        }
                    }
                    MockNodeMessagingService.access$getNetwork$p(this.this$0).onMessageTransfer$node_driver(this.$transfer);
                }
                {
                    this.this$0 = mockNodeMessagingService;
                    this.$deliverTo = list;
                    this.$transfer = messageTransfer;
                }
            });
        } else {
            log.info("Drop duplicate message " + transfer.getMessage$node_driver().getUniqueMessageId());
        }
        return transfer;
    }

    private final ReceivedMessage toReceivedMessage(@NotNull InMemoryMessagingNetwork.MessageTransfer $receiver) {
        InMemoryReceivedMessage inMemoryReceivedMessage;
        OpaqueBytes opaqueBytes;
        byte[] byArray = $receiver.getMessage$node_driver().getData().getBytes();
        OpaqueBytes opaqueBytes2 = opaqueBytes;
        OpaqueBytes opaqueBytes3 = opaqueBytes;
        String string = $receiver.getMessage$node_driver().getTopic();
        InMemoryReceivedMessage inMemoryReceivedMessage2 = inMemoryReceivedMessage;
        InMemoryReceivedMessage inMemoryReceivedMessage3 = inMemoryReceivedMessage;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        opaqueBytes2(byArray3);
        inMemoryReceivedMessage2(string, (ByteSequence)opaqueBytes3, 11, $receiver.getMessage$node_driver().getUniqueMessageId(), $receiver.getMessage$node_driver().getDebugTimestamp(), $receiver.getSender().getName(), null, null, false, 448, null);
        return inMemoryReceivedMessage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPendingDeliveries() {
        boolean bl;
        ThreadBox<InnerState> this_$iv = this.state;
        Lock lock = this_$iv.getLock();
        lock.lock();
        try {
            InnerState $receiver = (InnerState)this_$iv.getContent();
            Collection collection = $receiver.getPendingRedelivery();
            bl = !collection.isEmpty();
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    public MockNodeMessagingService(@NotNull NodeConfiguration configuration, @NotNull AffinityExecutor executor, @NotNull ServiceStateHelper stateHelper) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)stateHelper, (String)"stateHelper");
        this.configuration = configuration;
        this.executor = executor;
        this.stateHelper = stateHelper;
        this.running = true;
        this.state = new ThreadBox((Object)new InnerState(), null, 2, null);
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.synchronized\u2026shSet<DeduplicationId>())");
        this.processedMessages = set;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.ourSenderUUID = string;
    }

    public /* synthetic */ MockNodeMessagingService(NodeConfiguration nodeConfiguration, AffinityExecutor affinityExecutor, ServiceStateHelper serviceStateHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            serviceStateHelper = new ServiceStateHelper(log, null, 2, null);
        }
        this(nodeConfiguration, affinityExecutor, serviceStateHelper);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public boolean getActive() {
        return this.stateHelper.getActive();
    }

    @NotNull
    public Observable<Boolean> getActiveChange() {
        return this.stateHelper.getActiveChange();
    }

    @Nullable
    public static final /* synthetic */ InMemoryMessagingNetwork.MessageTransfer access$pumpReceiveInternal(MockNodeMessagingService $this, boolean block) {
        return $this.pumpReceiveInternal(block);
    }

    @NotNull
    public static final /* synthetic */ ReceivedMessage access$toReceivedMessage(MockNodeMessagingService $this, @NotNull InMemoryMessagingNetwork.MessageTransfer $receiver) {
        return $this.toReceivedMessage($receiver);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @NotNull
    public static final /* synthetic */ InMemoryMessagingNetwork access$getNetwork$p(MockNodeMessagingService $this) {
        InMemoryMessagingNetwork inMemoryMessagingNetwork = $this.network;
        if (inMemoryMessagingNetwork == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"network");
        }
        return inMemoryMessagingNetwork;
    }

    public static final /* synthetic */ void access$setNetwork$p(MockNodeMessagingService $this, @NotNull InMemoryMessagingNetwork inMemoryMessagingNetwork) {
        $this.network = inMemoryMessagingNetwork;
    }

    @NotNull
    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t\u00a2\u0006\u0002\u0010\nR-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService$Handler;", "Lnet/corda/node/services/messaging/MessageHandlerRegistration;", "topicSession", "", "callback", "Lkotlin/Function3;", "Lnet/corda/node/services/messaging/ReceivedMessage;", "Lnet/corda/node/services/messaging/DeduplicationHandler;", "", "Lnet/corda/node/services/messaging/MessageHandler;", "(Lnet/corda/testing/node/internal/MockNodeMessagingService;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "getCallback", "()Lkotlin/jvm/functions/Function3;", "getTopicSession", "()Ljava/lang/String;", "node-driver"})
    private final class Handler
    implements MessageHandlerRegistration {
        @NotNull
        private final String topicSession;
        @NotNull
        private final Function3<ReceivedMessage, MessageHandlerRegistration, DeduplicationHandler, Unit> callback;

        @NotNull
        public final String getTopicSession() {
            return this.topicSession;
        }

        @NotNull
        public final Function3<ReceivedMessage, MessageHandlerRegistration, DeduplicationHandler, Unit> getCallback() {
            return this.callback;
        }

        public Handler(@NotNull String topicSession, Function3<? super ReceivedMessage, ? super MessageHandlerRegistration, ? super DeduplicationHandler, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)topicSession, (String)"topicSession");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.topicSession = topicSession;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService$InnerState;", "", "(Lnet/corda/testing/node/internal/MockNodeMessagingService;)V", "handlers", "", "Lnet/corda/testing/node/internal/MockNodeMessagingService$Handler;", "Lnet/corda/testing/node/internal/MockNodeMessagingService;", "getHandlers", "()Ljava/util/List;", "pendingRedelivery", "Ljava/util/LinkedHashSet;", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "getPendingRedelivery", "()Ljava/util/LinkedHashSet;", "node-driver"})
    private final class InnerState {
        @NotNull
        private final List<Handler> handlers = new ArrayList();
        @NotNull
        private final LinkedHashSet<InMemoryMessagingNetwork.MessageTransfer> pendingRedelivery = new LinkedHashSet();

        @NotNull
        public final List<Handler> getHandlers() {
            return this.handlers;
        }

        @NotNull
        public final LinkedHashSet<InMemoryMessagingNetwork.MessageTransfer> getPendingRedelivery() {
            return this.pendingRedelivery;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b \n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\t\u0010-\u001a\u00020\u000bH\u00c6\u0003J\t\u0010.\u001a\u00020\rH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u00100\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003\u00a2\u0006\u0002\u0010\"J\t\u00101\u001a\u00020\u0012H\u00c6\u0003Jl\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u00020\u00122\b\u00105\u001a\u0004\u0018\u000106H\u00d6\u0003J\t\u00107\u001a\u00020\u0007H\u00d6\u0001J\t\u00108\u001a\u00020\u0003H\u00d6\u0001R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u001cR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00069"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService$InMemoryReceivedMessage;", "Lnet/corda/node/services/messaging/ReceivedMessage;", "topic", "", "data", "Lnet/corda/core/utilities/ByteSequence;", "platformVersion", "", "uniqueMessageId", "Lnet/corda/node/services/statemachine/DeduplicationId;", "debugTimestamp", "Ljava/time/Instant;", "peer", "Lnet/corda/core/identity/CordaX500Name;", "senderUUID", "senderSeqNo", "", "isSessionInit", "", "(Ljava/lang/String;Lnet/corda/core/utilities/ByteSequence;ILnet/corda/node/services/statemachine/DeduplicationId;Ljava/time/Instant;Lnet/corda/core/identity/CordaX500Name;Ljava/lang/String;Ljava/lang/Long;Z)V", "additionalHeaders", "", "getAdditionalHeaders", "()Ljava/util/Map;", "getData", "()Lnet/corda/core/utilities/ByteSequence;", "getDebugTimestamp", "()Ljava/time/Instant;", "()Z", "getPeer", "()Lnet/corda/core/identity/CordaX500Name;", "getPlatformVersion", "()I", "getSenderSeqNo", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getSenderUUID", "()Ljava/lang/String;", "getTopic", "getUniqueMessageId", "()Lnet/corda/node/services/statemachine/DeduplicationId;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Lnet/corda/core/utilities/ByteSequence;ILnet/corda/node/services/statemachine/DeduplicationId;Ljava/time/Instant;Lnet/corda/core/identity/CordaX500Name;Ljava/lang/String;Ljava/lang/Long;Z)Lnet/corda/testing/node/internal/MockNodeMessagingService$InMemoryReceivedMessage;", "equals", "other", "", "hashCode", "toString", "node-driver"})
    private static final class InMemoryReceivedMessage
    implements ReceivedMessage {
        @NotNull
        private final Map<String, String> additionalHeaders;
        @NotNull
        private final String topic;
        @NotNull
        private final ByteSequence data;
        private final int platformVersion;
        @NotNull
        private final DeduplicationId uniqueMessageId;
        @NotNull
        private final Instant debugTimestamp;
        @NotNull
        private final CordaX500Name peer;
        @Nullable
        private final String senderUUID;
        @Nullable
        private final Long senderSeqNo;
        private final boolean isSessionInit;

        @NotNull
        public Map<String, String> getAdditionalHeaders() {
            return this.additionalHeaders;
        }

        @NotNull
        public String getTopic() {
            return this.topic;
        }

        @NotNull
        public ByteSequence getData() {
            return this.data;
        }

        public int getPlatformVersion() {
            return this.platformVersion;
        }

        @NotNull
        public DeduplicationId getUniqueMessageId() {
            return this.uniqueMessageId;
        }

        @NotNull
        public Instant getDebugTimestamp() {
            return this.debugTimestamp;
        }

        @NotNull
        public CordaX500Name getPeer() {
            return this.peer;
        }

        @Nullable
        public String getSenderUUID() {
            return this.senderUUID;
        }

        @Nullable
        public Long getSenderSeqNo() {
            return this.senderSeqNo;
        }

        public boolean isSessionInit() {
            return this.isSessionInit;
        }

        public InMemoryReceivedMessage(@NotNull String topic, @NotNull ByteSequence data, int platformVersion, @NotNull DeduplicationId uniqueMessageId, @NotNull Instant debugTimestamp, @NotNull CordaX500Name peer, @Nullable String senderUUID, @Nullable Long senderSeqNo, boolean isSessionInit) {
            Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)uniqueMessageId, (String)"uniqueMessageId");
            Intrinsics.checkParameterIsNotNull((Object)debugTimestamp, (String)"debugTimestamp");
            Intrinsics.checkParameterIsNotNull((Object)peer, (String)"peer");
            this.topic = topic;
            this.data = data;
            this.platformVersion = platformVersion;
            this.uniqueMessageId = uniqueMessageId;
            this.debugTimestamp = debugTimestamp;
            this.peer = peer;
            this.senderUUID = senderUUID;
            this.senderSeqNo = senderSeqNo;
            this.isSessionInit = isSessionInit;
            this.additionalHeaders = MapsKt.emptyMap();
        }

        public /* synthetic */ InMemoryReceivedMessage(String string, ByteSequence byteSequence, int n, DeduplicationId deduplicationId, Instant instant, CordaX500Name cordaX500Name, String string2, Long l, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x40) != 0) {
                string2 = null;
            }
            if ((n2 & 0x80) != 0) {
                l = null;
            }
            if ((n2 & 0x100) != 0) {
                bl = false;
            }
            this(string, byteSequence, n, deduplicationId, instant, cordaX500Name, string2, l, bl);
        }

        @NotNull
        public final String component1() {
            return this.getTopic();
        }

        @NotNull
        public final ByteSequence component2() {
            return this.getData();
        }

        public final int component3() {
            return this.getPlatformVersion();
        }

        @NotNull
        public final DeduplicationId component4() {
            return this.getUniqueMessageId();
        }

        @NotNull
        public final Instant component5() {
            return this.getDebugTimestamp();
        }

        @NotNull
        public final CordaX500Name component6() {
            return this.getPeer();
        }

        @Nullable
        public final String component7() {
            return this.getSenderUUID();
        }

        @Nullable
        public final Long component8() {
            return this.getSenderSeqNo();
        }

        public final boolean component9() {
            return this.isSessionInit();
        }

        @NotNull
        public final InMemoryReceivedMessage copy(@NotNull String topic, @NotNull ByteSequence data, int platformVersion, @NotNull DeduplicationId uniqueMessageId, @NotNull Instant debugTimestamp, @NotNull CordaX500Name peer, @Nullable String senderUUID, @Nullable Long senderSeqNo, boolean isSessionInit) {
            Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)uniqueMessageId, (String)"uniqueMessageId");
            Intrinsics.checkParameterIsNotNull((Object)debugTimestamp, (String)"debugTimestamp");
            Intrinsics.checkParameterIsNotNull((Object)peer, (String)"peer");
            return new InMemoryReceivedMessage(topic, data, platformVersion, uniqueMessageId, debugTimestamp, peer, senderUUID, senderSeqNo, isSessionInit);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ InMemoryReceivedMessage copy$default(InMemoryReceivedMessage inMemoryReceivedMessage, String string, ByteSequence byteSequence, int n, DeduplicationId deduplicationId, Instant instant, CordaX500Name cordaX500Name, String string2, Long l, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = inMemoryReceivedMessage.getTopic();
            }
            if ((n2 & 2) != 0) {
                byteSequence = inMemoryReceivedMessage.getData();
            }
            if ((n2 & 4) != 0) {
                n = inMemoryReceivedMessage.getPlatformVersion();
            }
            if ((n2 & 8) != 0) {
                deduplicationId = inMemoryReceivedMessage.getUniqueMessageId();
            }
            if ((n2 & 0x10) != 0) {
                instant = inMemoryReceivedMessage.getDebugTimestamp();
            }
            if ((n2 & 0x20) != 0) {
                cordaX500Name = inMemoryReceivedMessage.getPeer();
            }
            if ((n2 & 0x40) != 0) {
                string2 = inMemoryReceivedMessage.getSenderUUID();
            }
            if ((n2 & 0x80) != 0) {
                l = inMemoryReceivedMessage.getSenderSeqNo();
            }
            if ((n2 & 0x100) != 0) {
                bl = inMemoryReceivedMessage.isSessionInit();
            }
            return inMemoryReceivedMessage.copy(string, byteSequence, n, deduplicationId, instant, cordaX500Name, string2, l, bl);
        }

        @NotNull
        public String toString() {
            return "InMemoryReceivedMessage(topic=" + this.getTopic() + ", data=" + this.getData() + ", platformVersion=" + this.getPlatformVersion() + ", uniqueMessageId=" + this.getUniqueMessageId() + ", debugTimestamp=" + this.getDebugTimestamp() + ", peer=" + this.getPeer() + ", senderUUID=" + this.getSenderUUID() + ", senderSeqNo=" + this.getSenderSeqNo() + ", isSessionInit=" + this.isSessionInit() + ")";
        }

        public int hashCode() {
            String string = this.getTopic();
            ByteSequence byteSequence = this.getData();
            DeduplicationId deduplicationId = this.getUniqueMessageId();
            Instant instant = this.getDebugTimestamp();
            CordaX500Name cordaX500Name = this.getPeer();
            String string2 = this.getSenderUUID();
            Long l = this.getSenderSeqNo();
            int n = ((((((((string != null ? string.hashCode() : 0) * 31 + (byteSequence != null ? byteSequence.hashCode() : 0)) * 31 + Integer.hashCode(this.getPlatformVersion())) * 31 + (deduplicationId != null ? deduplicationId.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (cordaX500Name != null ? cordaX500Name.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31;
            int n2 = this.isSessionInit() ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InMemoryReceivedMessage)) break block3;
                    InMemoryReceivedMessage inMemoryReceivedMessage = (InMemoryReceivedMessage)object;
                    if (!Intrinsics.areEqual((Object)this.getTopic(), (Object)inMemoryReceivedMessage.getTopic()) || !Intrinsics.areEqual((Object)this.getData(), (Object)inMemoryReceivedMessage.getData()) || !(this.getPlatformVersion() == inMemoryReceivedMessage.getPlatformVersion()) || !Intrinsics.areEqual((Object)this.getUniqueMessageId(), (Object)inMemoryReceivedMessage.getUniqueMessageId()) || !Intrinsics.areEqual((Object)this.getDebugTimestamp(), (Object)inMemoryReceivedMessage.getDebugTimestamp()) || !Intrinsics.areEqual((Object)this.getPeer(), (Object)inMemoryReceivedMessage.getPeer()) || !Intrinsics.areEqual((Object)this.getSenderUUID(), (Object)inMemoryReceivedMessage.getSenderUUID()) || !Intrinsics.areEqual((Object)this.getSenderSeqNo(), (Object)inMemoryReceivedMessage.getSenderSeqNo()) || !(this.isSessionInit() == inMemoryReceivedMessage.isSessionInit())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u0014\u0010\b\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService$InMemoryDeduplicationHandler;", "Lnet/corda/node/services/messaging/DeduplicationHandler;", "Lnet/corda/node/services/statemachine/ExternalEvent$ExternalMessageEvent;", "receivedMessage", "Lnet/corda/node/services/messaging/ReceivedMessage;", "transfer", "Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "(Lnet/corda/testing/node/internal/MockNodeMessagingService;Lnet/corda/node/services/messaging/ReceivedMessage;Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;)V", "deduplicationHandler", "getDeduplicationHandler", "()Lnet/corda/node/services/messaging/DeduplicationHandler;", "externalCause", "Lnet/corda/node/services/statemachine/ExternalEvent;", "getExternalCause", "()Lnet/corda/node/services/statemachine/ExternalEvent;", "flowId", "Lnet/corda/core/flows/StateMachineRunId;", "getFlowId", "()Lnet/corda/core/flows/StateMachineRunId;", "getReceivedMessage", "()Lnet/corda/node/services/messaging/ReceivedMessage;", "getTransfer", "()Lnet/corda/testing/node/InMemoryMessagingNetwork$MessageTransfer;", "afterDatabaseTransaction", "", "insideDatabaseTransaction", "node-driver"})
    private final class InMemoryDeduplicationHandler
    implements DeduplicationHandler,
    ExternalEvent.ExternalMessageEvent {
        @NotNull
        private final StateMachineRunId flowId;
        @NotNull
        private final ReceivedMessage receivedMessage;
        @NotNull
        private final InMemoryMessagingNetwork.MessageTransfer transfer;

        @NotNull
        public ExternalEvent getExternalCause() {
            return (ExternalEvent)this;
        }

        @NotNull
        public StateMachineRunId getFlowId() {
            return this.flowId;
        }

        @NotNull
        public DeduplicationHandler getDeduplicationHandler() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDatabaseTransaction() {
            ThreadBox this_$iv = MockNodeMessagingService.this.state;
            Lock lock = this_$iv.getLock();
            lock.lock();
            try {
                InnerState $receiver = (InnerState)this_$iv.getContent();
                boolean bl = $receiver.getPendingRedelivery().remove(this.transfer);
            }
            finally {
                lock.unlock();
            }
        }

        public void insideDatabaseTransaction() {
            Collection collection = MockNodeMessagingService.this.processedMessages;
            DeduplicationId deduplicationId = this.transfer.getMessage$node_driver().getUniqueMessageId();
            collection.add(deduplicationId);
        }

        @NotNull
        public ReceivedMessage getReceivedMessage() {
            return this.receivedMessage;
        }

        @NotNull
        public final InMemoryMessagingNetwork.MessageTransfer getTransfer() {
            return this.transfer;
        }

        public InMemoryDeduplicationHandler(@NotNull ReceivedMessage receivedMessage, InMemoryMessagingNetwork.MessageTransfer transfer) {
            Intrinsics.checkParameterIsNotNull((Object)receivedMessage, (String)"receivedMessage");
            Intrinsics.checkParameterIsNotNull((Object)transfer, (String)"transfer");
            this.receivedMessage = receivedMessage;
            this.transfer = transfer;
            this.flowId = StateMachineRunId.Companion.createRandom();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/testing/node/internal/MockNodeMessagingService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "node-driver"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

