/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.security.PublicKey;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtils;
import net.corda.node.services.persistence.WritablePublicKeyToOwningIdentityCache;
import net.corda.nodeapi.internal.KeyOwningIdentity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0096\u0002J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006H\u0096\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/corda/testing/node/internal/MockPublicKeyToOwningIdentityCache;", "Lnet/corda/node/services/persistence/WritablePublicKeyToOwningIdentityCache;", "()V", "cache", "", "Ljava/security/PublicKey;", "Lnet/corda/nodeapi/internal/KeyOwningIdentity;", "get", "key", "set", "", "value", "node-driver"})
public final class MockPublicKeyToOwningIdentityCache
implements WritablePublicKeyToOwningIdentityCache {
    private final Map<PublicKey, KeyOwningIdentity> cache;

    @NotNull
    public KeyOwningIdentity get(@NotNull PublicKey key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        KeyOwningIdentity keyOwningIdentity = this.cache.get(key);
        if (keyOwningIdentity == null) {
            keyOwningIdentity = (KeyOwningIdentity)KeyOwningIdentity.UnmappedIdentity.INSTANCE;
        }
        return keyOwningIdentity;
    }

    public void set(@NotNull PublicKey key, @NotNull KeyOwningIdentity value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map<PublicKey, KeyOwningIdentity> map2 = this.cache;
        KeyOwningIdentity keyOwningIdentity = value;
        map2.put(key, keyOwningIdentity);
    }

    public MockPublicKeyToOwningIdentityCache() {
        MockPublicKeyToOwningIdentityCache mockPublicKeyToOwningIdentityCache = this;
        Map map2 = new LinkedHashMap();
        mockPublicKeyToOwningIdentityCache.cache = InternalUtils.toSynchronised((Map)map2);
    }
}

