/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import com.typesafe.config.Config;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import net.corda.common.validation.internal.Validated;
import net.corda.core.concurrent.CordaFuture;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.internal.concurrent.CordaFutureImplKt;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.NotaryInfo;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.node.VersionInfo;
import net.corda.node.internal.FlowManager;
import net.corda.node.internal.Node;
import net.corda.node.internal.NodeFlowManager;
import net.corda.node.internal.NodeWithInfo;
import net.corda.node.services.config.ConfigHelper;
import net.corda.node.services.config.ConfigUtilitiesKt;
import net.corda.node.services.config.FlowOverrideConfig;
import net.corda.node.services.config.NodeConfiguration;
import net.corda.node.services.config.NodeConfigurationKt;
import net.corda.nodeapi.internal.DevIdentityGenerator;
import net.corda.nodeapi.internal.config.ConfigUtilities;
import net.corda.nodeapi.internal.network.NetworkParametersCopier;
import net.corda.testing.common.internal.ParametersUtilitiesKt;
import net.corda.testing.core.SerializationEnvironmentRule;
import net.corda.testing.driver.PortAllocation;
import net.corda.testing.driver.internal.GlobalTestPortAllocationKt;
import net.corda.testing.node.User;
import net.corda.testing.node.internal.InProcessNode;
import net.corda.testing.node.internal.InternalMockNetworkKt;
import net.corda.testing.node.internal.InternalTestUtilsKt;
import net.corda.testing.node.internal.TestCordappInternal;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 *2\u00020\u0001:\u0001*B'\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0017JJ\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00010%2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\b\u0010)\u001a\u00020\u001bH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/testing/node/internal/NodeBasedTest;", "", "cordappPackages", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "notaries", "", "Lnet/corda/core/identity/CordaX500Name;", "(Ljava/util/Set;Ljava/util/List;)V", "defaultNetworkParameters", "Lnet/corda/nodeapi/internal/network/NetworkParametersCopier;", "nodes", "", "Lnet/corda/node/internal/NodeWithInfo;", "notaryNodes", "getNotaryNodes", "()Ljava/util/List;", "portAllocation", "Lnet/corda/testing/driver/PortAllocation;", "tempFolder", "Lorg/junit/rules/TemporaryFolder;", "testSerialization", "Lnet/corda/testing/core/SerializationEnvironmentRule;", "baseDirectory", "Ljava/nio/file/Path;", "legalName", "ensureAllNetworkMapCachesHaveAllNodeInfos", "", "installNotary", "Lnet/corda/core/identity/Party;", "setUp", "startNode", "platformVersion", "", "rpcUsers", "Lnet/corda/testing/node/User;", "configOverrides", "", "", "flowManager", "Lnet/corda/node/internal/FlowManager;", "stopAllNodes", "Companion", "node-driver"})
public abstract class NodeBasedTest {
    @Rule
    @JvmField
    @NotNull
    public final SerializationEnvironmentRule testSerialization;
    @Rule
    @JvmField
    @NotNull
    public final TemporaryFolder tempFolder;
    private NetworkParametersCopier defaultNetworkParameters;
    @NotNull
    private final List<NodeWithInfo> notaryNodes;
    private final List<NodeWithInfo> nodes;
    private final PortAllocation portAllocation;
    private final Set<TestCordappInternal> cordappPackages;
    private final List<CordaX500Name> notaries;
    private static final Regex WHITESPACE;
    public static final Companion Companion;

    @NotNull
    protected final List<NodeWithInfo> getNotaryNodes() {
        return this.notaryNodes;
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() {
        NotaryInfo notaryInfo;
        Collection collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.notaries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CordaX500Name cordaX500Name = (CordaX500Name)item$iv$iv;
            collection = destination$iv$iv;
            notaryInfo = new NotaryInfo(this.installNotary((CordaX500Name)it), true);
            collection.add(notaryInfo);
        }
        List notaryInfos = (List)destination$iv$iv;
        this.defaultNetworkParameters = new NetworkParametersCopier(ParametersUtilitiesKt.testNetworkParameters$default((List)notaryInfos, (int)0, null, (int)0, (int)0, null, (int)0, null, null, (int)510, null), null, false, false, 14, null);
        $receiver$iv = this.notaries;
        Collection destination$iv = this.notaryNodes;
        for (Object item$iv : $receiver$iv) {
            void it;
            Object item$iv$iv;
            item$iv$iv = (CordaX500Name)item$iv;
            collection = destination$iv;
            notaryInfo = NodeBasedTest.startNode$default(this, (CordaX500Name)it, 0, null, null, null, 30, null);
            collection.add(notaryInfo);
        }
    }

    private final Party installNotary(CordaX500Name legalName) {
        Path baseDirectory = PathUtilsKt.createDirectories((Path)this.baseDirectory(legalName), (FileAttribute[])new FileAttribute[0]);
        return DevIdentityGenerator.INSTANCE.installKeyStoreWithNodeIdentity(baseDirectory, legalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @After
    public final void stopAllNodes() {
        List nodesToShut = CollectionsKt.plus((Collection)this.nodes, (Iterable)this.notaryNodes);
        ScheduledExecutorService shutdownExecutor = Executors.newScheduledThreadPool(nodesToShut.size());
        try {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)nodesToShut;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                NodeWithInfo nodeWithInfo = (NodeWithInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                ScheduledExecutorService scheduledExecutorService = shutdownExecutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"shutdownExecutor");
                CordaFuture cordaFuture = CordaFutureImplKt.fork((Executor)scheduledExecutorService, (Function0)((Function0)new Function0<Unit>((NodeWithInfo)it){

                    public final void invoke() {
                        ((NodeWithInfo)this.receiver).dispose();
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(NodeWithInfo.class);
                    }

                    public final String getName() {
                        return "dispose";
                    }

                    public final String getSignature() {
                        return "dispose()V";
                    }
                }));
                collection.add(cordaFuture);
            }
            KotlinUtilsKt.getOrThrow$default((Future)((Future)CordaFutureImplKt.transpose((Collection)((List)destination$iv$iv))), null, (int)1, null);
            Iterable $receiver$iv2 = nodesToShut;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                NodeWithInfo it = (NodeWithInfo)element$iv$iv;
                Object[] objectArray = new CordaFuture[2];
                ScheduledExecutorService scheduledExecutorService = shutdownExecutor;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"shutdownExecutor");
                objectArray[0] = InternalTestUtilsKt.addressMustNotBeBoundFuture(scheduledExecutorService, it.getNode().getConfiguration().getP2pAddress());
                objectArray[1] = InternalTestUtilsKt.addressMustNotBeBoundFuture(shutdownExecutor, it.getNode().getConfiguration().getRpcOptions().getAddress());
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List portNotBoundChecks = (List)destination$iv$iv2;
            this.nodes.clear();
            this.notaryNodes.clear();
            KotlinUtilsKt.getOrThrow$default((Future)((Future)CordaFutureImplKt.transpose((Collection)portNotBoundChecks)), null, (int)1, null);
        }
        finally {
            shutdownExecutor.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final NodeWithInfo startNode(@NotNull CordaX500Name legalName, int platformVersion, @NotNull List<User> rpcUsers, @NotNull Map<String, ? extends Object> configOverrides, @NotNull FlowManager flowManager) {
        Object it;
        Object object;
        Collection<Map> collection;
        Object object2;
        Object $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Intrinsics.checkParameterIsNotNull(rpcUsers, (String)"rpcUsers");
        Intrinsics.checkParameterIsNotNull(configOverrides, (String)"configOverrides");
        Intrinsics.checkParameterIsNotNull((Object)flowManager, (String)"flowManager");
        Path baseDirectory = PathUtilsKt.createDirectories((Path)this.baseDirectory(legalName), (FileAttribute[])new FileAttribute[0]);
        Object object3 = configOverrides.get("p2pAddress");
        if (object3 == null) {
            object3 = this.portAllocation.nextHostAndPort().toString();
        }
        Object p2pAddress = object3;
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"myLegalName", (Object)legalName.toString());
        pairArray[1] = TuplesKt.to((Object)"p2pAddress", (Object)p2pAddress);
        pairArray[2] = TuplesKt.to((Object)"devMode", (Object)true);
        pairArray[3] = TuplesKt.to((Object)"rpcSettings.address", (Object)this.portAllocation.nextHostAndPort().toString());
        pairArray[4] = TuplesKt.to((Object)"rpcSettings.adminAddress", (Object)this.portAllocation.nextHostAndPort().toString());
        Iterable iterable = rpcUsers;
        String string = "rpcUsers";
        int n = 5;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        boolean bl = true;
        Path path = null;
        Path path2 = baseDirectory;
        ConfigHelper configHelper = ConfigHelper.INSTANCE;
        void var10_17 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it2;
            Object item$iv$iv = iterator.next();
            object2 = (User)item$iv$iv;
            collection = destination$iv$iv;
            Map map2 = ConfigUtilities.toConfig((Object)it2).root().unwrapped();
            collection.add(map2);
        }
        collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
        Config config2 = ConfigHelper.loadConfig$default((ConfigHelper)configHelper, (Path)path2, path, (boolean)bl, (Config)ConfigUtilitiesKt.plus((Config)ConfigUtilitiesKt.configOf((Pair[])pairArray3), configOverrides), (int)2, null);
        $receiver$iv$iv = this.cordappPackages;
        Set<TestCordappInternal> customCordapps = !$receiver$iv$iv.isEmpty() ? this.cordappPackages : InternalTestUtilsKt.cordappsForPackages((object = InternalTestUtilsKt.getCallerPackage(Reflection.getOrCreateKotlinClass(NodeBasedTest.class))) != null && (object = CollectionsKt.listOf((Object)(it = ($receiver$iv$iv = object)))) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList());
        TestCordappInternal.Companion.installCordapps(baseDirectory, SetsKt.emptySet(), customCordapps);
        NodeConfiguration parsedConfig = (NodeConfiguration)Validated.DefaultImpls.value$default((Validated)NodeConfigurationKt.parseAsNodeConfiguration$default((Config)config2, null, (int)1, null), null, (int)1, null);
        NetworkParametersCopier networkParametersCopier = this.defaultNetworkParameters;
        if (networkParametersCopier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultNetworkParameters");
        }
        networkParametersCopier.install(baseDirectory);
        InProcessNode node = new InProcessNode(parsedConfig, VersionInfo.copy$default((VersionInfo)InternalMockNetworkKt.getMOCK_VERSION_INFO(), (int)platformVersion, null, null, null, (int)14, null), flowManager, false, 8, null);
        NodeInfo nodeInfo = node.start();
        NodeWithInfo nodeWithInfo = new NodeWithInfo((Node)node, nodeInfo);
        object2 = this.nodes;
        object2.add(nodeWithInfo);
        this.ensureAllNetworkMapCachesHaveAllNodeInfos();
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)legalName.getOrganisation(), (int)0, (Function0)((Function0)new Function0<Unit>(node){
            final /* synthetic */ InProcessNode $node;

            public final void invoke() {
                this.$node.run();
            }
            {
                this.$node = inProcessNode;
                super(0);
            }
        }), (int)23, null);
        return nodeWithInfo;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ NodeWithInfo startNode$default(NodeBasedTest nodeBasedTest, CordaX500Name cordaX500Name, int n, List list, Map map2, FlowManager flowManager, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startNode");
        }
        if ((n2 & 2) != 0) {
            n = 11;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 0x10) != 0) {
            flowManager = (FlowManager)new NodeFlowManager(new FlowOverrideConfig(null, 1, null));
        }
        return nodeBasedTest.startNode(cordaX500Name, n, list, map2, flowManager);
    }

    @JvmOverloads
    @NotNull
    public final NodeWithInfo startNode(@NotNull CordaX500Name legalName, int platformVersion, @NotNull List<User> rpcUsers, @NotNull Map<String, ? extends Object> configOverrides) {
        return NodeBasedTest.startNode$default(this, legalName, platformVersion, rpcUsers, configOverrides, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final NodeWithInfo startNode(@NotNull CordaX500Name legalName, int platformVersion, @NotNull List<User> rpcUsers) {
        return NodeBasedTest.startNode$default(this, legalName, platformVersion, rpcUsers, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final NodeWithInfo startNode(@NotNull CordaX500Name legalName, int platformVersion) {
        return NodeBasedTest.startNode$default(this, legalName, platformVersion, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final NodeWithInfo startNode(@NotNull CordaX500Name legalName) {
        return NodeBasedTest.startNode$default(this, legalName, 0, null, null, null, 30, null);
    }

    @NotNull
    protected final Path baseDirectory(@NotNull CordaX500Name legalName) {
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Path path = this.tempFolder.getRoot().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tempFolder.root.toPath()");
        CharSequence charSequence = legalName.getOrganisation();
        Regex regex = WHITESPACE;
        String string = "";
        Path path2 = path;
        String string2 = regex.replace(charSequence, string);
        return PathUtilsKt.div((Path)path2, (String)string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureAllNetworkMapCachesHaveAllNodeInfos() {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.nodes;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            NodeWithInfo it = (NodeWithInfo)element$iv$iv;
            if (!(it.getNode().getStarted() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List runningNodes = (List)destination$iv$iv;
        Iterable $receiver$iv2 = runningNodes;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            NodeWithInfo $i$a$1$filter = (NodeWithInfo)item$iv$iv;
            Collection collection = destination$iv$iv2;
            NodeInfo nodeInfo = it.getInfo();
            collection.add(nodeInfo);
        }
        List runningNodesInfo = (List)destination$iv$iv2;
        for (NodeWithInfo node : runningNodes) {
            for (NodeInfo nodeInfo : runningNodesInfo) {
                node.getServices().getNetworkMapCache().addOrUpdateNode(nodeInfo);
            }
        }
    }

    @JvmOverloads
    public NodeBasedTest(@NotNull Set<? extends TestCordappInternal> cordappPackages, @NotNull List<CordaX500Name> notaries) {
        Intrinsics.checkParameterIsNotNull(cordappPackages, (String)"cordappPackages");
        Intrinsics.checkParameterIsNotNull(notaries, (String)"notaries");
        this.cordappPackages = cordappPackages;
        this.notaries = notaries;
        this.testSerialization = new SerializationEnvironmentRule(true);
        this.tempFolder = new TemporaryFolder();
        Object object = this;
        Object object2 = new ArrayList();
        ((NodeBasedTest)object).notaryNodes = object2;
        object = this;
        object2 = new ArrayList();
        ((NodeBasedTest)object).nodes = object2;
        this.portAllocation = GlobalTestPortAllocationKt.incrementalPortAllocation();
        String string = Level.DEBUG.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Level.DEBUG.name()");
        String string2 = string;
        object = "consoleLogLevel";
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        object2 = string4;
        System.setProperty((String)object, (String)object2);
    }

    @JvmOverloads
    public /* synthetic */ NodeBasedTest(Set set, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(set, list);
    }

    @JvmOverloads
    public NodeBasedTest(@NotNull Set<? extends TestCordappInternal> cordappPackages) {
        this(cordappPackages, null, 2, null);
    }

    @JvmOverloads
    public NodeBasedTest() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        String string = "\\s++";
        WHITESPACE = new Regex(string);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/testing/node/internal/NodeBasedTest$Companion;", "", "()V", "WHITESPACE", "Lkotlin/text/Regex;", "node-driver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

