/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.internal.PathUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u008f\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00052\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0082\u0001\u0010\t\u001a\u00020\n\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u001bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/corda/testing/node/internal/ProcessUtilities;", "", "()V", "defaultClassPath", "", "", "getDefaultClassPath", "()Ljava/util/List;", "javaPath", "startJavaProcess", "Ljava/lang/Process;", "className", "arguments", "classPath", "workingDirectory", "Ljava/nio/file/Path;", "jdwpPort", "", "extraJvmArguments", "maximumHeapSize", "identifier", "environmentVariables", "", "inheritIO", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/nio/file/Path;Ljava/lang/Integer;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Z)Ljava/lang/Process;", "C", "(Ljava/util/List;Ljava/util/List;Ljava/nio/file/Path;Ljava/lang/Integer;Ljava/util/List;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Process;", "node-driver"})
public final class ProcessUtilities {
    private static final String javaPath;
    @NotNull
    private static final List<String> defaultClassPath;
    public static final ProcessUtilities INSTANCE;

    private final <C> Process startJavaProcess(List<String> arguments, List<String> classPath, Path workingDirectory, Integer jdwpPort, List<String> extraJvmArguments, String maximumHeapSize, Map<String, String> environmentVariables) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"C");
        String string = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"C::class.java.name");
        return ProcessUtilities.startJavaProcess$default(this, string, arguments, classPath, workingDirectory, jdwpPort, extraJvmArguments, maximumHeapSize, null, environmentVariables, false, 640, null);
    }

    static /* bridge */ /* synthetic */ Process startJavaProcess$default(ProcessUtilities this_, List arguments, List classPath, Path workingDirectory, Integer jdwpPort, List extraJvmArguments, String maximumHeapSize, Map environmentVariables, int n, Object object) {
        if ((n & 2) != 0) {
            classPath = this_.getDefaultClassPath();
        }
        if ((n & 4) != 0) {
            workingDirectory = null;
        }
        if ((n & 8) != 0) {
            jdwpPort = null;
        }
        if ((n & 0x10) != 0) {
            extraJvmArguments = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            maximumHeapSize = null;
        }
        if ((n & 0x40) != 0) {
            environmentVariables = MapsKt.emptyMap();
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"C");
        String string = Object.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"C::class.java.name");
        return ProcessUtilities.startJavaProcess$default(this_, string, arguments, classPath, workingDirectory, jdwpPort, extraJvmArguments, maximumHeapSize, null, environmentVariables, false, 640, null);
    }

    @NotNull
    public final Process startJavaProcess(@NotNull String className, @NotNull List<String> arguments, @NotNull List<String> classPath, @Nullable Path workingDirectory, @Nullable Integer jdwpPort, @NotNull List<String> extraJvmArguments, @Nullable String maximumHeapSize, @NotNull String identifier, @NotNull Map<String, String> environmentVariables, boolean inheritIO) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(classPath, (String)"classPath");
        Intrinsics.checkParameterIsNotNull(extraJvmArguments, (String)"extraJvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull(environmentVariables, (String)"environmentVariables");
        Object $receiver = object = (List)new ArrayList();
        $receiver.add(javaPath);
        if (jdwpPort == null || $receiver.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + jdwpPort)) {
            // empty if block
        }
        if (maximumHeapSize != null) {
            $receiver.add("-Xmx" + maximumHeapSize);
        }
        $receiver.add("-XX:+UseG1GC");
        $receiver.addAll((Collection)extraJvmArguments);
        $receiver.add(className);
        $receiver.addAll((Collection)arguments);
        List command = object;
        $receiver = object = new ProcessBuilder(command);
        if (inheritIO) {
            ((ProcessBuilder)$receiver).inheritIO();
        }
        ((ProcessBuilder)$receiver).environment().putAll(environmentVariables);
        Map<String, String> map2 = ((ProcessBuilder)$receiver).environment();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"environment()");
        Map<String, String> map3 = map2;
        String string = "CLASSPATH";
        Iterable iterable = classPath;
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        String string3 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null);
        map3.put(string, string3);
        if (workingDirectory != null) {
            ((ProcessBuilder)$receiver).redirectError(PathUtilsKt.div((Path)workingDirectory, (String)(className + '.' + identifier + ".stderr.log")).toFile());
            ((ProcessBuilder)$receiver).redirectOutput(PathUtilsKt.div((Path)workingDirectory, (String)(className + '.' + identifier + ".stdout.log")).toFile());
            ((ProcessBuilder)$receiver).directory(workingDirectory.toFile());
        }
        Process process = ((ProcessBuilder)object).start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"ProcessBuilder(command).\u2026      }\n        }.start()");
        return process;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Process startJavaProcess$default(ProcessUtilities processUtilities, String string, List list, List list2, Path path, Integer n, List list3, String string2, String string3, Map map2, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list2 = defaultClassPath;
        }
        if ((n2 & 8) != 0) {
            path = null;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            string2 = null;
        }
        if ((n2 & 0x80) != 0) {
            string3 = "";
        }
        if ((n2 & 0x100) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 0x200) != 0) {
            bl = true;
        }
        return processUtilities.startJavaProcess(string, list, list2, path, n, list3, string2, string3, map2, bl);
    }

    @NotNull
    public final List<String> getDefaultClassPath() {
        return defaultClassPath;
    }

    private ProcessUtilities() {
    }

    static {
        ProcessUtilities processUtilities;
        INSTANCE = processUtilities = new ProcessUtilities();
        String string = System.getProperty("java.home");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.home\")");
        javaPath = ((Object)PathUtilsKt.div((Path)PathUtilsKt.div((String)string, (String)"bin"), (String)"java")).toString();
        String string2 = System.getProperty("java.class.path");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"java.class.path\")");
        CharSequence charSequence = string2;
        String[] stringArray = new String[1];
        String string3 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.pathSeparator");
        stringArray[0] = string3;
        defaultClassPath = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }
}

