/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import net.corda.core.internal.ClassGraphUtilsKt;
import net.corda.core.internal.PathUtilsKt;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.testing.node.internal.TestCordappImpl;
import net.corda.testing.node.internal.TestCordappInternal;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u001c\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0000H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lnet/corda/testing/node/internal/TestCordappImpl;", "Lnet/corda/testing/node/internal/TestCordappInternal;", "scanPackage", "", "config", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getConfig", "()Ljava/util/Map;", "jarFile", "Ljava/nio/file/Path;", "getJarFile", "()Ljava/nio/file/Path;", "getScanPackage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "withConfig", "withOnlyJarContents", "Companion", "node-driver"})
public final class TestCordappImpl
extends TestCordappInternal {
    @NotNull
    private final String scanPackage;
    @NotNull
    private final Map<String, Object> config;
    private static final ConcurrentHashMap<String, Set<Path>> packageToRootPaths;
    private static final ConcurrentHashMap<Path, Path> projectRootToBuiltJar;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public TestCordappImpl withConfig(@NotNull Map<String, ? extends Object> config2) {
        Intrinsics.checkParameterIsNotNull(config2, (String)"config");
        return TestCordappImpl.copy$default(this, null, config2, 1, null);
    }

    @Override
    @NotNull
    public TestCordappImpl withOnlyJarContents() {
        return TestCordappImpl.copy$default(this, null, MapsKt.emptyMap(), 1, null);
    }

    @Override
    @NotNull
    public Path getJarFile() {
        Set<Path> jars2 = Companion.findJars(this.scanPackage);
        switch (jars2.size()) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("There are no CorDapps containing the package " + this.scanPackage + " on the classpath. Make sure " + "the package name is correct and that the CorDapp is added as a gradle dependency.");
            }
            case 1: {
                return (Path)CollectionsKt.first((Iterable)jars2);
            }
        }
        throw (Throwable)new IllegalArgumentException("There is more than one CorDapp containing the package " + this.scanPackage + " on the classpath " + jars2 + ". Specify a package name which is unique to the CorDapp.");
    }

    @NotNull
    public final String getScanPackage() {
        return this.scanPackage;
    }

    @Override
    @NotNull
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public TestCordappImpl(@NotNull String scanPackage, @NotNull Map<String, ? extends Object> config2) {
        Intrinsics.checkParameterIsNotNull((Object)scanPackage, (String)"scanPackage");
        Intrinsics.checkParameterIsNotNull(config2, (String)"config");
        this.scanPackage = scanPackage;
        this.config = config2;
    }

    static {
        Companion = new Companion(null);
        packageToRootPaths = new ConcurrentHashMap();
        projectRootToBuiltJar = new ConcurrentHashMap();
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @NotNull
    public final String component1() {
        return this.scanPackage;
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.getConfig();
    }

    @NotNull
    public final TestCordappImpl copy(@NotNull String scanPackage, @NotNull Map<String, ? extends Object> config2) {
        Intrinsics.checkParameterIsNotNull((Object)scanPackage, (String)"scanPackage");
        Intrinsics.checkParameterIsNotNull(config2, (String)"config");
        return new TestCordappImpl(scanPackage, config2);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ TestCordappImpl copy$default(TestCordappImpl testCordappImpl, String string, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            string = testCordappImpl.scanPackage;
        }
        if ((n & 2) != 0) {
            map2 = testCordappImpl.getConfig();
        }
        return testCordappImpl.copy(string, map2);
    }

    @NotNull
    public String toString() {
        return "TestCordappImpl(scanPackage=" + this.scanPackage + ", config=" + this.getConfig() + ")";
    }

    public int hashCode() {
        String string = this.scanPackage;
        Map<String, Object> map2 = this.getConfig();
        return (string != null ? string.hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TestCordappImpl)) break block3;
                TestCordappImpl testCordappImpl = (TestCordappImpl)object;
                if (!Intrinsics.areEqual((Object)this.scanPackage, (Object)testCordappImpl.scanPackage) || !Intrinsics.areEqual(this.getConfig(), testCordappImpl.getConfig())) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/corda/testing/node/internal/TestCordappImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "packageToRootPaths", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Ljava/nio/file/Path;", "projectRootToBuiltJar", "buildCordappJar", "projectRoot", "findJars", "scanPackage", "findProjectRoot", "path", "findRootPaths", "runGradleBuild", "", "node-driver"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Path> findJars(@NotNull String scanPackage) {
            Set set;
            boolean bl;
            Iterable $receiver$iv;
            Set rootPaths;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)scanPackage, (String)"scanPackage");
                rootPaths = this.findRootPaths(scanPackage);
                $receiver$iv = rootPaths;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Path it = (Path)element$iv;
                        if (StringsKt.endsWith$default((String)((Object)it).toString(), (String)".jar", (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                set = rootPaths;
            } else {
                $receiver$iv = rootPaths;
                Collection destination$iv = new HashSet();
                for (Object item$iv : $receiver$iv) {
                    void it;
                    Path $i$a$1$all = (Path)item$iv;
                    Collection collection = destination$iv;
                    void var11_9 = StringsKt.endsWith$default((String)it.toString(), (String)".jar", (boolean)false, (int)2, null) ? it : Companion.buildCordappJar((Path)it);
                    collection.add(var11_9);
                }
                set = (Set)destination$iv;
            }
            return set;
        }

        private final Set<Path> findRootPaths(String scanPackage) {
            Object v = packageToRootPaths.computeIfAbsent(scanPackage, (Function)new Function<String, Set<? extends Path>>(scanPackage){
                final /* synthetic */ String $scanPackage;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                @NotNull
                public final LinkedHashSet<Path> apply(@NotNull String it) {
                    LinkedHashSet linkedHashSet;
                    ClassGraph classGraph;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ClassGraph classGraph2 = classGraph = new ClassGraph().acceptPaths(new String[]{StringsKt.replace$default((String)this.$scanPackage, (char)'.', (char)'/', (boolean)false, (int)4, null)});
                    Intrinsics.checkExpressionValueIsNotNull((Object)classGraph2, (String)"classGraph");
                    Closeable closeable = (Closeable)ClassGraphUtilsKt.pooledScan((ClassGraph)classGraph2);
                    Throwable throwable = null;
                    try {
                        void $receiver$iv;
                        ScanResult scanResult = (ScanResult)closeable;
                        ResourceList resourceList = scanResult.getAllResources();
                        Intrinsics.checkExpressionValueIsNotNull((Object)resourceList, (String)"scanResult.allResources");
                        Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)resourceList)), (Function1)findRootPaths.1.1.INSTANCE), (Function1)findRootPaths.1.2.INSTANCE);
                        Collection destination$iv = new LinkedHashSet<E>();
                        for (E item$iv : $receiver$iv) {
                            Path path;
                            void it2;
                            Path path2 = (Path)item$iv;
                            Collection collection = destination$iv;
                            if (StringsKt.endsWith$default((String)it2.toString(), (String)".jar", (boolean)false, (int)2, null)) {
                                path = it2;
                            } else {
                                void v3 = it2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                                path = net.corda.testing.node.internal.TestCordappImpl$Companion.access$findProjectRoot(TestCordappImpl.Companion, (Path)v3);
                            }
                            void var12_14 = path;
                            collection.add(var12_14);
                        }
                        linkedHashSet = (LinkedHashSet)destination$iv;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return linkedHashSet;
                }
                {
                    this.$scanPackage = string;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"packageToRootPaths.compu\u2026          }\n            }");
            return (Set)v;
        }

        private final Path findProjectRoot(Path path) {
            Path current = path;
            while (!PathUtilsKt.exists((Path)PathUtilsKt.div((Path)current, (String)"build.gradle"), (LinkOption[])new LinkOption[0]) && !PathUtilsKt.exists((Path)PathUtilsKt.div((Path)current, (String)"build.gradle.kts"), (LinkOption[])new LinkOption[0])) {
                Intrinsics.checkExpressionValueIsNotNull((Object)current.getParent(), (String)"current.parent");
            }
            return current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Path buildCordappJar(Path projectRoot) {
            Path path;
            RandomAccessFile gradleLockFile = new RandomAccessFile(new File(System.getProperty("user.home"), "corda-gradle.lock"), "rw");
            Closeable closeable = gradleLockFile;
            Throwable throwable = null;
            try {
                Path path2;
                RandomAccessFile it = (RandomAccessFile)closeable;
                FileLock lock = gradleLockFile.getChannel().lock();
                AutoCloseable autoCloseable = lock;
                Throwable throwable2 = null;
                try {
                    FileLock it2 = (FileLock)autoCloseable;
                    Object v = projectRootToBuiltJar.computeIfAbsent(projectRoot, (Function)new Function<Path, Path>(gradleLockFile, projectRoot){
                        final /* synthetic */ RandomAccessFile $gradleLockFile$inlined;
                        final /* synthetic */ Path $projectRoot$inlined;
                        {
                            this.$gradleLockFile$inlined = randomAccessFile;
                            this.$projectRoot$inlined = path;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final Path apply(@NotNull Path it) {
                            Path libs;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            TestCordappImpl.access$getLog$cp().info("Generating CorDapp jar from local project in " + this.$projectRoot$inlined + " ...");
                            net.corda.testing.node.internal.TestCordappImpl$Companion.access$runGradleBuild(TestCordappImpl.Companion, this.$projectRoot$inlined);
                            Iterable<Path> $receiver$iv = libs = PathUtilsKt.div((Path)PathUtilsKt.div((Path)this.$projectRoot$inlined, (String)"build"), (String)"libs");
                            Object object = Files.list($receiver$iv);
                            Object object2 = null;
                            try {
                                Object it2 = (Stream)object;
                                Stream<T> stream = it2.filter(buildCordappJar.1.1.1.jars.1.1.INSTANCE).filter(buildCordappJar.1.1.1.jars.1.2.INSTANCE).filter(buildCordappJar.1.1.1.jars.1.3.INSTANCE);
                                Intrinsics.checkExpressionValueIsNotNull(stream, (String)"it.filter { it.toString(\u2026endsWith(\"javadoc.jar\") }");
                                it2 = StreamsKt.toList(stream);
                            }
                            catch (Throwable it2) {
                                object2 = it2;
                                throw it2;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
                            }
                            $receiver$iv = (Iterable)it2;
                            object = $receiver$iv;
                            object2 = new Comparator<T>(){

                                public final int compare(T a, T b) {
                                    Path it;
                                    Path path = it = (Path)a;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                                    it = (Path)b;
                                    Comparable comparable = PathUtilsKt.attributes((Path)path, (LinkOption[])new LinkOption[0]).creationTime();
                                    Path path2 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it");
                                    FileTime fileTime = PathUtilsKt.attributes((Path)path2, (LinkOption[])new LinkOption[0]).creationTime();
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)fileTime);
                                }
                            };
                            List jars2 = CollectionsKt.sortedWith((Iterable)object, (Comparator)object2);
                            Object object3 = CollectionsKt.lastOrNull((List)jars2);
                            if (object3 == null) {
                                object2 = "No jars were built in " + libs;
                                throw (Throwable)new IllegalStateException(object2.toString());
                            }
                            return (Path)object3;
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"projectRootToBuiltJar.co\u2026\" }\n                    }");
                    Path path3 = (Path)v;
                    path2 = path3;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"lock.use {\n             \u2026      }\n                }");
                Path path4 = path2;
                path = path4;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"gradleLockFile.use {\n   \u2026          }\n            }");
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void runGradleBuild(Path projectRoot) {
            GradleConnector gradleConnector;
            GradleConnector $receiver = gradleConnector = GradleConnector.newConnector();
            $receiver.useBuildDistribution();
            $receiver.forProjectDirectory(projectRoot.toFile());
            GradleConnector gradleConnector2 = gradleConnector;
            ProjectConnection projectConnection = gradleConnector2.connect();
            Closeable closeable = (Closeable)projectConnection;
            Throwable throwable = null;
            try {
                BuildLauncher buildLauncher;
                ProjectConnection it = (ProjectConnection)closeable;
                BuildLauncher $receiver2 = buildLauncher = projectConnection.newBuild();
                $receiver2.forTasks(new String[]{"jar"});
                $receiver2.addProgressListener((ProgressListener)runGradleBuild.1.build.1.1.INSTANCE);
                BuildLauncher build2 = buildLauncher;
                build2.run();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Path access$findProjectRoot(Companion $this, @NotNull Path path) {
            return $this.findProjectRoot(path);
        }

        public static final /* synthetic */ void access$runGradleBuild(Companion $this, @NotNull Path projectRoot) {
            $this.runGradleBuild(projectRoot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

