/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal;

import com.typesafe.config.ConfigValueFactory;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.corda.core.internal.PathUtilsKt;
import net.corda.testing.node.TestCordapp;
import net.corda.testing.node.internal.CustomCordapp;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0000H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnet/corda/testing/node/internal/TestCordappInternal;", "Lnet/corda/testing/node/TestCordapp;", "()V", "jarFile", "Ljava/nio/file/Path;", "getJarFile", "()Ljava/nio/file/Path;", "withOnlyJarContents", "Companion", "node-driver"})
public abstract class TestCordappInternal
extends TestCordapp {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Path getJarFile();

    @NotNull
    public abstract TestCordappInternal withOnlyJarContents();

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\r"}, d2={"Lnet/corda/testing/node/internal/TestCordappInternal$Companion;", "", "()V", "checkNoConflicts", "", "Lnet/corda/testing/node/internal/TestCordappInternal;", "cordapps", "installCordapps", "", "baseDirectory", "Ljava/nio/file/Path;", "nodeSpecificCordapps", "generalCordapps", "node-driver"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        public final void installCordapps(@NotNull Path baseDirectory, @NotNull Set<? extends TestCordappInternal> nodeSpecificCordapps, @NotNull Set<? extends TestCordappInternal> generalCordapps) {
            void $receiver$iv$iv;
            Object $i$f$filterTo;
            void $receiver$iv$iv2;
            void $receiver$iv$iv3;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
            Intrinsics.checkParameterIsNotNull(nodeSpecificCordapps, (String)"nodeSpecificCordapps");
            Intrinsics.checkParameterIsNotNull(generalCordapps, (String)"generalCordapps");
            Set<TestCordappInternal> nodeSpecificCordappsWithoutMeta = this.checkNoConflicts(nodeSpecificCordapps);
            this.checkNoConflicts(generalCordapps);
            Iterable iterable = generalCordapps;
            Object object = nodeSpecificCordapps;
            void var7_7 = $receiver$iv;
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                TestCordappInternal it = (TestCordappInternal)element$iv$iv;
                if (!(!nodeSpecificCordappsWithoutMeta.contains(it.withOnlyJarContents()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            Set allCordapps = SetsKt.plus(object, (Iterable)iterable2);
            Iterable $receiver$iv2 = allCordapps;
            destination$iv$iv = $receiver$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                TestCordappInternal it = (TestCordappInternal)element$iv$iv;
                if (!(!(it instanceof CustomCordapp) || !($i$f$filterTo = (Collection)((CustomCordapp)it).getPackages()).isEmpty() || !($i$f$filterTo = (Collection)((CustomCordapp)it).getClasses()).isEmpty() || !($i$f$filterTo = (Collection)((CustomCordapp)it).getFixups()).isEmpty())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
            destination$iv$iv2 = $receiver$iv2;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                void it;
                $i$f$filterTo = (TestCordappInternal)element$iv$iv;
                object = destination$iv$iv3;
                iterable2 = it.getJarFile();
                object.put(iterable2, element$iv$iv);
            }
            Map jarToCordapp = destination$iv$iv3;
            Path cordappsDir = PathUtilsKt.div((Path)baseDirectory, (String)"cordapps");
            Path configDir = PathUtilsKt.createDirectories((Path)PathUtilsKt.div((Path)cordappsDir, (String)"config"), (FileAttribute[])new FileAttribute[0]);
            jarToCordapp.forEach((BiConsumer)new BiConsumer<Path, TestCordappInternal>(cordappsDir, configDir){
                final /* synthetic */ Path $cordappsDir;
                final /* synthetic */ Path $configDir;

                public final void accept(@NotNull Path jar, @NotNull TestCordappInternal cordapp) {
                    Intrinsics.checkParameterIsNotNull((Object)jar, (String)"jar");
                    Intrinsics.checkParameterIsNotNull((Object)cordapp, (String)"cordapp");
                    try {
                        if (jar.toFile().exists()) {
                            PathUtilsKt.copyToDirectory((Path)jar, (Path)this.$cordappsDir, (CopyOption[])new CopyOption[0]);
                        }
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        // empty catch block
                    }
                    String configString = ConfigValueFactory.fromMap(cordapp.getConfig()).toConfig().root().render();
                    Path path = PathUtilsKt.div((Path)this.$configDir, (String)(StringsKt.removeSuffix((String)((Object)jar.getFileName()).toString(), (CharSequence)".jar") + ".conf"));
                    String string = configString;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configString");
                    PathUtilsKt.writeText$default((Path)path, (String)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
                }
                {
                    this.$cordappsDir = path;
                    this.$configDir = path2;
                }
            });
        }

        public static /* bridge */ /* synthetic */ void installCordapps$default(Companion companion, Path path, Set set, Set set2, int n, Object object) {
            if ((n & 4) != 0) {
                set2 = SetsKt.emptySet();
            }
            companion.installCordapps(path, set, set2);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<TestCordappInternal> checkNoConflicts(Set<? extends TestCordappInternal> cordapps) {
            void $receiver$iv$iv;
            Object $receiver$iv;
            Object object = $receiver$iv = (Iterable)cordapps;
            Map destination$iv$iv = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Object element$iv$iv = iterator.next();
                TestCordappInternal it = (TestCordappInternal)element$iv$iv;
                TestCordappInternal key$iv$iv = it.withOnlyJarContents();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map cordappsWithoutMeta = destination$iv$iv;
            object = $receiver$iv = cordappsWithoutMeta;
            for (Map.Entry element$iv : object.entrySet()) {
                Map.Entry it = element$iv;
                boolean bl = ((List)it.getValue()).size() == 1;
                if (bl) continue;
                String string = "Conflicting CorDapps specified: " + (List)it.getValue();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return cordappsWithoutMeta.keySet();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

