/*
 * Decompiled with CFR 0.152.
 */
package net.corda.testing.node.internal.network;

import java.io.Closeable;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.servlet.Servlet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.SecureHash;
import net.corda.core.crypto.SignedData;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.internal.InternalUtils;
import net.corda.core.internal.SignedDataWithCert;
import net.corda.core.node.NetworkParameters;
import net.corda.core.node.NodeInfo;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.KeyStoreConfigHelpersKt;
import net.corda.nodeapi.internal.SignedNodeInfo;
import net.corda.nodeapi.internal.crypto.CertificateAndKeyPair;
import net.corda.nodeapi.internal.network.NetworkMap;
import net.corda.nodeapi.internal.network.ParametersUpdate;
import net.corda.testing.common.internal.ParametersUtilitiesKt;
import net.corda.testing.node.internal.network.NetworkMapServer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u000278B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0006\u0010'\u001a\u00020!J\b\u0010(\u001a\u00020!H\u0016J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0%J\u000e\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200J\u001e\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00069"}, d2={"Lnet/corda/testing/node/internal/network/NetworkMapServer;", "Ljava/io/Closeable;", "pollInterval", "Ljava/time/Duration;", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "networkMapCertAndKeyPair", "Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;", "myHostNameValue", "", "additionalServices", "", "", "(Ljava/time/Duration;Lnet/corda/core/utilities/NetworkHostAndPort;Lnet/corda/nodeapi/internal/crypto/CertificateAndKeyPair;Ljava/lang/String;[Ljava/lang/Object;)V", "networkParameters", "Lnet/corda/core/node/NetworkParameters;", "getNetworkParameters", "()Lnet/corda/core/node/NetworkParameters;", "setNetworkParameters", "(Lnet/corda/core/node/NetworkParameters;)V", "nextNetworkParameters", "parametersUpdate", "Lnet/corda/nodeapi/internal/network/ParametersUpdate;", "server", "Lorg/eclipse/jetty/server/Server;", "service", "Lnet/corda/testing/node/internal/network/NetworkMapServer$InMemoryNetworkMapService;", "version", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "addNodesToPrivateNetwork", "", "networkUUID", "Ljava/util/UUID;", "nodesNames", "", "Lnet/corda/core/identity/CordaX500Name;", "advertiseNewParameters", "close", "latestParametersAccepted", "Lnet/corda/core/crypto/SecureHash;", "publicKey", "Ljava/security/PublicKey;", "networkMapHashes", "removeNodeInfo", "nodeInfo", "Lnet/corda/core/node/NodeInfo;", "scheduleParametersUpdate", "nextParameters", "description", "updateDeadline", "Ljava/time/Instant;", "start", "Companion", "InMemoryNetworkMapService", "node-driver"})
public final class NetworkMapServer
implements Closeable {
    private final Server server;
    @NotNull
    private NetworkParameters networkParameters;
    private final InMemoryNetworkMapService service;
    private ParametersUpdate parametersUpdate;
    private NetworkParameters nextNetworkParameters;
    @NotNull
    private String version;
    private final Duration pollInterval;
    private final CertificateAndKeyPair networkMapCertAndKeyPair;
    private final String myHostNameValue;
    private static final NetworkParameters stubNetworkParameters;
    public static final Companion Companion;

    @NotNull
    public final NetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    public final void setNetworkParameters(@NotNull NetworkParameters networkParameters) {
        Intrinsics.checkParameterIsNotNull((Object)networkParameters, (String)"<set-?>");
        this.networkParameters = networkParameters;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.version = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkHostAndPort start() {
        void $receiver$iv$iv;
        this.server.start();
        while (!this.server.isStarted()) {
            Thread.sleep(500L);
        }
        Connector[] connectorArray = this.server.getConnectors();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectorArray, (String)"server.connectors");
        Connector[] $receiver$iv = connectorArray;
        Connector[] connectorArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv$iv : $receiver$iv$iv) {
            ServerConnector serverConnector;
            void element$iv$iv = element$iv$iv$iv;
            void it = element$iv$iv;
            Object v1 = it;
            if (!(v1 instanceof ServerConnector)) {
                v1 = null;
            }
            if ((ServerConnector)v1 == null) continue;
            ServerConnector it$iv$iv = serverConnector;
            destination$iv$iv.add(it$iv$iv);
        }
        Object object = CollectionsKt.first((List)((List)destination$iv$iv));
        ServerConnector it = (ServerConnector)object;
        String string = it.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.host");
        return new NetworkHostAndPort(string, it.getLocalPort());
    }

    @NotNull
    public final List<SecureHash> networkMapHashes() {
        return CollectionsKt.toList((Iterable)this.service.getNodeInfoMap().keySet());
    }

    public final void removeNodeInfo(@NotNull NodeInfo nodeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
        this.service.removeNodeInfo(nodeInfo);
    }

    public final void scheduleParametersUpdate(@NotNull NetworkParameters nextParameters, @NotNull String description, @NotNull Instant updateDeadline) {
        Intrinsics.checkParameterIsNotNull((Object)nextParameters, (String)"nextParameters");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)updateDeadline, (String)"updateDeadline");
        this.nextNetworkParameters = nextParameters;
        this.parametersUpdate = new ParametersUpdate(SerializationAPIKt.serialize$default((Object)nextParameters, null, null, (int)3, null).getHash(), description, updateDeadline);
    }

    public final void advertiseNewParameters() {
        NetworkParameters networkParameters;
        NetworkParameters networkParameters2 = this.nextNetworkParameters;
        NetworkMapServer networkMapServer = this;
        if (networkParameters2 == null) {
            String string = "Schedule parameters update first";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        networkMapServer.networkParameters = networkParameters = networkParameters2;
        this.nextNetworkParameters = null;
        this.parametersUpdate = null;
    }

    @Nullable
    public final SecureHash latestParametersAccepted(@NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        return this.service.getLatestAcceptedParametersMap().get(publicKey);
    }

    public final void addNodesToPrivateNetwork(@NotNull UUID networkUUID, @NotNull List<CordaX500Name> nodesNames) {
        Intrinsics.checkParameterIsNotNull((Object)networkUUID, (String)"networkUUID");
        Intrinsics.checkParameterIsNotNull(nodesNames, (String)"nodesNames");
        this.service.addNodesToPrivateNetwork(networkUUID, nodesNames);
    }

    @Override
    public void close() {
        this.server.stop();
    }

    public NetworkMapServer(@NotNull Duration pollInterval, @NotNull NetworkHostAndPort hostAndPort, @NotNull CertificateAndKeyPair networkMapCertAndKeyPair, @NotNull String myHostNameValue, Object ... additionalServices) {
        Server server;
        ServletHolder servletHolder;
        ResourceConfig resourceConfig;
        Intrinsics.checkParameterIsNotNull((Object)pollInterval, (String)"pollInterval");
        Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
        Intrinsics.checkParameterIsNotNull((Object)networkMapCertAndKeyPair, (String)"networkMapCertAndKeyPair");
        Intrinsics.checkParameterIsNotNull((Object)myHostNameValue, (String)"myHostNameValue");
        Intrinsics.checkParameterIsNotNull((Object)additionalServices, (String)"additionalServices");
        this.pollInterval = pollInterval;
        this.networkMapCertAndKeyPair = networkMapCertAndKeyPair;
        this.myHostNameValue = myHostNameValue;
        this.networkParameters = stubNetworkParameters;
        this.service = new InMemoryNetworkMapService();
        this.version = "1";
        Server server2 = new Server(new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort()));
        NetworkMapServer networkMapServer = this;
        Server $receiver = server2;
        HandlerCollection handlerCollection = new HandlerCollection();
        Server server3 = $receiver;
        HandlerCollection $receiver2 = handlerCollection;
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        HandlerCollection handlerCollection2 = $receiver2;
        ServletContextHandler $receiver3 = servletContextHandler;
        $receiver3.setContextPath("/");
        ResourceConfig $receiver4 = resourceConfig = new ResourceConfig();
        $receiver4.register((Object)this.service);
        Object[] $receiver$iv = additionalServices;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object it = element$iv = $receiver$iv[i];
            $receiver4.register(it);
        }
        ResourceConfig resourceConfig2 = resourceConfig;
        ServletHolder $receiver5 = servletHolder = new ServletHolder((Servlet)new ServletContainer(resourceConfig2));
        $receiver5.setInitOrder(0);
        ServletHolder jerseyServlet = servletHolder;
        $receiver3.addServlet(jerseyServlet, "/*");
        ServletContextHandler servletContextHandler2 = servletContextHandler;
        handlerCollection2.addHandler((Handler)servletContextHandler2);
        HandlerCollection handlerCollection3 = handlerCollection;
        server3.setHandler((Handler)handlerCollection3);
        networkMapServer.server = server = server2;
    }

    public /* synthetic */ NetworkMapServer(Duration duration, NetworkHostAndPort networkHostAndPort, CertificateAndKeyPair certificateAndKeyPair, String string, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            networkHostAndPort = new NetworkHostAndPort("localhost", 0);
        }
        if ((n & 4) != 0) {
            certificateAndKeyPair = KeyStoreConfigHelpersKt.createDevNetworkMapCa$default(null, (int)1, null);
        }
        if ((n & 8) != 0) {
            string = "test.host.name";
        }
        this(duration, networkHostAndPort, certificateAndKeyPair, string, objectArray);
    }

    static {
        Companion = new Companion(null);
        stubNetworkParameters = ParametersUtilitiesKt.testNetworkParameters$default(null, (int)0, null, (int)0, (int)0, null, (int)10, null, null, (int)447, null);
    }

    public static final /* synthetic */ void access$setParametersUpdate$p(NetworkMapServer $this, @Nullable ParametersUpdate parametersUpdate) {
        $this.parametersUpdate = parametersUpdate;
    }

    public static final /* synthetic */ void access$setNextNetworkParameters$p(NetworkMapServer $this, @Nullable NetworkParameters networkParameters) {
        $this.nextNetworkParameters = networkParameters;
    }

    @Path(value="network-map")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eJ\b\u0010\u001f\u001a\u00020\u0017H\u0007J\b\u0010 \u001a\u00020\u0017H\u0007J\u0012\u0010!\u001a\u00020\u00172\b\b\u0001\u0010\"\u001a\u00020#H\u0007J\u0012\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020#H\u0007J\b\u0010&\u001a\u00020\u0017H\u0007J\u0012\u0010'\u001a\u00020\u00172\b\b\u0001\u0010(\u001a\u00020#H\u0007J\u0016\u0010)\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lnet/corda/testing/node/internal/network/NetworkMapServer$InMemoryNetworkMapService;", "", "(Lnet/corda/testing/node/internal/network/NetworkMapServer;)V", "latestAcceptedParametersMap", "", "Ljava/security/PublicKey;", "Lnet/corda/core/crypto/SecureHash;", "getLatestAcceptedParametersMap", "()Ljava/util/Map;", "networkMaps", "Ljava/util/UUID;", "", "nodeInfoMap", "Lnet/corda/nodeapi/internal/SignedNodeInfo;", "getNodeInfoMap", "nodeNamesUUID", "Lnet/corda/core/identity/CordaX500Name;", "signedNetParams", "Lnet/corda/core/internal/SignedDataWithCert;", "Lnet/corda/core/node/NetworkParameters;", "getSignedNetParams", "()Lnet/corda/core/internal/SignedDataWithCert;", "ackNetworkParameters", "Ljavax/ws/rs/core/Response;", "input", "Ljava/io/InputStream;", "addNodesToPrivateNetwork", "", "networkUUID", "nodeNames", "", "getGlobalNetworkMap", "getHostName", "getNetworkParameter", "hash", "", "getNodeInfo", "nodeInfoHash", "getNodeInfos", "getPrivateNetworkMap", "extraUUID", "networkMapResponse", "nodeInfoHashes", "publishNodeInfo", "removeNodeInfo", "nodeInfo", "Lnet/corda/core/node/NodeInfo;", "node-driver"})
    public final class InMemoryNetworkMapService {
        private final Map<CordaX500Name, UUID> nodeNamesUUID;
        @NotNull
        private final Map<SecureHash, SignedNodeInfo> nodeInfoMap;
        private final Map<UUID, Set<SecureHash>> networkMaps;
        @NotNull
        private final Map<PublicKey, SecureHash> latestAcceptedParametersMap;

        @NotNull
        public final Map<SecureHash, SignedNodeInfo> getNodeInfoMap() {
            return this.nodeInfoMap;
        }

        @NotNull
        public final Map<PublicKey, SecureHash> getLatestAcceptedParametersMap() {
            return this.latestAcceptedParametersMap;
        }

        private final SignedDataWithCert<NetworkParameters> getSignedNetParams() {
            return NetworkMapServer.this.networkMapCertAndKeyPair.sign((Object)NetworkMapServer.this.getNetworkParameters());
        }

        /*
         * WARNING - void declaration
         */
        @POST
        @Path(value="publish")
        @Consumes(value={"application/octet-stream"})
        @NotNull
        public final Response publishNodeInfo(@NotNull InputStream input) {
            Response.ResponseBuilder responseBuilder;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            try {
                void $receiver$iv$iv;
                Map<SecureHash, SignedNodeInfo> $receiver$iv;
                boolean bl;
                byte[] byArray;
                InputStream $receiver$iv2 = input;
                byte[] $receiver$iv$iv2 = InternalUtils.readFully((InputStream)$receiver$iv2);
                SerializationFactory serializationFactory$iv$iv = SerializationFactory.Companion.getDefaultFactory();
                SerializationContext context$iv$iv = serializationFactory$iv$iv.getDefaultContext();
                Object object = byArray = $receiver$iv$iv2;
                boolean bl2 = bl = !(((byte[])object).length == 0);
                if (!bl) {
                    String string = "Empty bytes";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ByteSequence $receiver$iv$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv$iv2, (int)0, (int)0, (int)3, null);
                SignedNodeInfo signedNodeInfo = (SignedNodeInfo)serializationFactory$iv$iv.deserialize($receiver$iv$iv$iv, SignedNodeInfo.class, context$iv$iv);
                SecureHash hash = signedNodeInfo.getRaw().getHash();
                NodeInfo nodeInfo = signedNodeInfo.verified();
                UUID privateNetwork = this.nodeNamesUUID.get(((Party)nodeInfo.getLegalIdentities().get(0)).getName());
                Set<SecureHash> map2 = this.networkMaps.computeIfAbsent(privateNetwork, publishNodeInfo.map.1.INSTANCE);
                map2.add(hash);
                Map<SecureHash, SignedNodeInfo> $i$f$deserialize = $receiver$iv = this.nodeInfoMap;
                Map destination$iv$iv = new LinkedHashMap();
                void var10_15 = $receiver$iv$iv;
                for (Map.Entry element$iv$iv : var10_15.entrySet()) {
                    Map.Entry it = element$iv$iv;
                    if (!Intrinsics.areEqual((Object)((Party)CollectionsKt.first((List)((SignedNodeInfo)it.getValue()).verified().getLegalIdentities())).getName(), (Object)((Party)CollectionsKt.first((List)signedNodeInfo.verified().getLegalIdentities())).getName())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                destination$iv$iv.forEach((BiConsumer)new BiConsumer<SecureHash, SignedNodeInfo>(this, map2){
                    final /* synthetic */ InMemoryNetworkMapService this$0;
                    final /* synthetic */ Set $map;

                    public final void accept(@NotNull SecureHash t, @NotNull SignedNodeInfo $noName_1) {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                        this.this$0.getNodeInfoMap().remove(t);
                        this.$map.remove(t);
                    }
                    {
                        this.this$0 = inMemoryNetworkMapService;
                        this.$map = set;
                    }
                });
                Map<SecureHash, SignedNodeInfo> map3 = this.nodeInfoMap;
                object = signedNodeInfo;
                map3.put(hash, (SignedNodeInfo)object);
                responseBuilder = Response.ok();
            }
            catch (Exception e) {
                Exception exception = e;
                responseBuilder = exception instanceof SignatureException ? Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()) : Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage());
            }
            Response response = responseBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"try {\n                va\u2026  }\n            }.build()");
            return response;
        }

        @POST
        @Path(value="ack-parameters")
        @Consumes(value={"application/octet-stream"})
        @NotNull
        public final Response ackNetworkParameters(@NotNull InputStream input) {
            boolean bl;
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            InputStream $receiver$iv = input;
            byte[] $receiver$iv$iv = InternalUtils.readFully((InputStream)$receiver$iv);
            SerializationFactory serializationFactory$iv$iv = SerializationFactory.Companion.getDefaultFactory();
            SerializationContext context$iv$iv = serializationFactory$iv$iv.getDefaultContext();
            byte[] byArray2 = byArray = $receiver$iv$iv;
            boolean bl2 = bl = !(byArray2.length == 0);
            if (!bl) {
                String string = "Empty bytes";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ByteSequence $receiver$iv$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv$iv, (int)0, (int)0, (int)3, null);
            SignedData signedParametersHash = (SignedData)serializationFactory$iv$iv.deserialize($receiver$iv$iv$iv, SignedData.class, context$iv$iv);
            SecureHash hash = (SecureHash)signedParametersHash.verified();
            Map<PublicKey, SecureHash> map2 = this.latestAcceptedParametersMap;
            PublicKey publicKey = signedParametersHash.getSig().getBy();
            SecureHash secureHash = hash;
            map2.put(publicKey, secureHash);
            Response response = Response.ok().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ok().build()");
            return response;
        }

        @GET
        @Produces(value={"application/octet-stream"})
        @NotNull
        public final Response getGlobalNetworkMap() {
            Collection<Object> collection = this.networkMaps.get(null);
            if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection<Object> nodeInfoHashes = collection;
            return this.networkMapResponse((List<? extends SecureHash>)nodeInfoHashes);
        }

        @GET
        @Path(value="{var}")
        @Produces(value={"application/octet-stream"})
        @NotNull
        public final Response getPrivateNetworkMap(@PathParam(value="var") @NotNull String extraUUID) {
            Intrinsics.checkParameterIsNotNull((Object)extraUUID, (String)"extraUUID");
            UUID uuid = UUID.fromString(extraUUID);
            Set<SecureHash> set = this.networkMaps.get(uuid);
            if (set == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(Response.Status.NOT_FOUND).build()");
                return response;
            }
            Set<SecureHash> nodeInfoHashes = set;
            return this.networkMapResponse(CollectionsKt.toList((Iterable)nodeInfoHashes));
        }

        private final Response networkMapResponse(List<? extends SecureHash> nodeInfoHashes) {
            Response.ResponseBuilder responseBuilder;
            NetworkMap networkMap = new NetworkMap(nodeInfoHashes, this.getSignedNetParams().getRaw().getHash(), NetworkMapServer.this.parametersUpdate);
            SignedDataWithCert signedNetworkMap = NetworkMapServer.this.networkMapCertAndKeyPair.sign((Object)networkMap);
            Response.ResponseBuilder $receiver = responseBuilder = Response.ok((Object)SerializationAPIKt.serialize$default((Object)signedNetworkMap, null, null, (int)3, null).getBytes()).header("Cache-Control", (Object)("max-age=" + NetworkMapServer.this.pollInterval.getSeconds()));
            if (Intrinsics.areEqual((Object)NetworkMapServer.this.getVersion(), (Object)"1") ^ true) {
                $receiver.header("X-Corda-Server-Version", (Object)NetworkMapServer.this.getVersion());
            }
            Response response = responseBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(signedNetwor\u2026                 .build()");
            return response;
        }

        public final void removeNodeInfo(@NotNull NodeInfo nodeInfo) {
            Map<UUID, Set<SecureHash>> $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
            SecureHash hash = SerializationAPIKt.serialize$default((Object)nodeInfo, null, null, (int)3, null).getHash();
            Map<UUID, Set<SecureHash>> map2 = $receiver$iv = this.networkMaps;
            Iterator<Map.Entry<UUID, Set<SecureHash>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Set<SecureHash>> element$iv;
                Map.Entry<UUID, Set<SecureHash>> it = element$iv = iterator.next();
                it.getValue().remove(hash);
            }
            this.nodeInfoMap.remove(hash);
        }

        /*
         * WARNING - void declaration
         */
        public final void addNodesToPrivateNetwork(@NotNull UUID networkUUID, @NotNull List<CordaX500Name> nodeNames) {
            Intrinsics.checkParameterIsNotNull((Object)networkUUID, (String)"networkUUID");
            Intrinsics.checkParameterIsNotNull(nodeNames, (String)"nodeNames");
            for (CordaX500Name name : nodeNames) {
                void $receiver$iv$iv;
                Iterable $receiver$iv22;
                Iterable iterable = $receiver$iv22 = (Iterable)this.nodeInfoMap.values();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv;
                    SignedNodeInfo it = (SignedNodeInfo)element$iv$iv;
                    Iterable iterable2 = $receiver$iv = (Iterable)it.verified().getLegalIdentities();
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void it2;
                        Party party = (Party)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        CordaX500Name cordaX500Name = it2.getName();
                        collection.add(cordaX500Name);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                boolean $receiver$iv22 = !((List)destination$iv$iv).contains(name);
                if ($receiver$iv22) continue;
                throw (Throwable)new IllegalArgumentException("Node with name: " + name + " was already published to global network map");
            }
            Iterable $receiver$iv = nodeNames;
            for (Object element$iv : $receiver$iv) {
                CordaX500Name it = (CordaX500Name)element$iv;
                Map<CordaX500Name, UUID> map2 = this.nodeNamesUUID;
                UUID uUID = networkUUID;
                map2.put(it, uUID);
            }
        }

        @GET
        @Path(value="node-info/{var}")
        @Produces(value={"application/octet-stream"})
        @NotNull
        public final Response getNodeInfo(@PathParam(value="var") @NotNull String nodeInfoHash) {
            Intrinsics.checkParameterIsNotNull((Object)nodeInfoHash, (String)"nodeInfoHash");
            SecureHash hash = SecureHash.Companion.create(nodeInfoHash);
            SignedNodeInfo signedNodeInfo = this.nodeInfoMap.get(hash);
            Response response = (signedNodeInfo != null ? Response.ok((Object)SerializationAPIKt.serialize$default((Object)signedNodeInfo, null, null, (int)3, null).getBytes()) : Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"if (signedNodeInfo != nu\u2026ND)\n            }.build()");
            return response;
        }

        @GET
        @Path(value="node-infos")
        @Produces(value={"application/octet-stream"})
        @NotNull
        public final Response getNodeInfos() {
            NetworkMap networkMap = new NetworkMap(CollectionsKt.toList((Iterable)this.nodeInfoMap.keySet()), this.getSignedNetParams().getRaw().getHash(), NetworkMapServer.this.parametersUpdate);
            SignedDataWithCert signedNetworkMap = NetworkMapServer.this.networkMapCertAndKeyPair.sign((Object)networkMap);
            Response response = Response.ok((Object)SerializationAPIKt.serialize$default((Object)new Pair((Object)signedNetworkMap, (Object)CollectionsKt.toList((Iterable)this.nodeInfoMap.values())), null, null, (int)3, null).getBytes()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(Pair(signedN\u2026erialize().bytes).build()");
            return response;
        }

        @GET
        @Path(value="network-parameters/{var}")
        @Produces(value={"application/octet-stream"})
        @NotNull
        public final Response getNetworkParameter(@PathParam(value="var") @NotNull String hash) {
            SignedDataWithCert requestedParameters;
            String string;
            SignedDataWithCert signedDataWithCert;
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            SecureHash requestedHash = SecureHash.Companion.create(hash);
            if (Intrinsics.areEqual((Object)requestedHash, (Object)this.getSignedNetParams().getRaw().getHash())) {
                signedDataWithCert = this.getSignedNetParams();
            } else {
                NetworkParameters networkParameters = NetworkMapServer.this.nextNetworkParameters;
                if (Intrinsics.areEqual((Object)requestedHash, networkParameters != null && (networkParameters = SerializationAPIKt.serialize$default((Object)networkParameters, null, null, (int)3, null)) != null ? networkParameters.getHash() : null)) {
                    NetworkParameters networkParameters2 = NetworkMapServer.this.nextNetworkParameters;
                    if (networkParameters2 != null) {
                        String it = string = networkParameters2;
                        signedDataWithCert = NetworkMapServer.this.networkMapCertAndKeyPair.sign((Object)it);
                    } else {
                        signedDataWithCert = null;
                    }
                } else {
                    signedDataWithCert = requestedParameters = null;
                }
            }
            if (requestedParameters == null) {
                string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Response response = Response.ok((Object)SerializationAPIKt.serialize$default(requestedParameters, null, null, (int)3, null).getBytes()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(requestedPar\u2026erialize().bytes).build()");
            return response;
        }

        @GET
        @Path(value="my-hostname")
        @NotNull
        public final Response getHostName() {
            Response response = Response.ok((Object)NetworkMapServer.this.myHostNameValue).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(myHostNameValue).build()");
            return response;
        }

        public InMemoryNetworkMapService() {
            Map map2;
            InMemoryNetworkMapService inMemoryNetworkMapService = this;
            inMemoryNetworkMapService.nodeNamesUUID = map2 = (Map)new LinkedHashMap();
            inMemoryNetworkMapService = this;
            inMemoryNetworkMapService.nodeInfoMap = map2 = (Map)new LinkedHashMap();
            inMemoryNetworkMapService = this;
            inMemoryNetworkMapService.networkMaps = map2 = (Map)new LinkedHashMap();
            inMemoryNetworkMapService = this;
            inMemoryNetworkMapService.latestAcceptedParametersMap = map2 = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/testing/node/internal/network/NetworkMapServer$Companion;", "", "()V", "stubNetworkParameters", "Lnet/corda/core/node/NetworkParameters;", "node-driver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

