/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00060\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lnet/corda/serialization/internal/ByteBufferOutputStream;", "Ljava/io/ByteArrayOutputStream;", "size", "", "(I)V", "alsoAsByteBuffer", "T", "remaining", "task", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "copyTo", "", "stream", "Ljava/io/OutputStream;", "Companion", "serialization"})
@KeepForDJVM
public final class ByteBufferOutputStream
extends ByteArrayOutputStream {
    private static final Method ensureCapacity;
    public static final Companion Companion;

    public final <T> T alsoAsByteBuffer(int remaining, @NotNull Function1<? super ByteBuffer, ? extends T> task) {
        ByteBuffer buffer;
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        ensureCapacity.invoke((Object)this, this.count + remaining);
        ByteBuffer byteBuffer = buffer = ByteBuffer.wrap(this.buf, this.count, remaining);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        Object result = task.invoke((Object)byteBuffer);
        this.count = buffer.position();
        return (T)result;
    }

    public final void copyTo(@NotNull OutputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        stream.write(this.buf, 0, this.count);
    }

    public ByteBufferOutputStream(int size) {
        super(size);
    }

    static {
        Method method;
        Companion = new Companion(null);
        Method $receiver = method = ByteArrayOutputStream.class.getDeclaredMethod("ensureCapacity", Integer.TYPE);
        $receiver.setAccessible(true);
        ensureCapacity = method;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/ByteBufferOutputStream$Companion;", "", "()V", "ensureCapacity", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

