/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u0006"}, d2={"Lnet/corda/serialization/internal/OrdinalBits;", "", "ordinal", "", "(I)V", "OrdinalWriter", "serialization"})
@KeepForDJVM
public final class OrdinalBits {
    private final int ordinal;

    public OrdinalBits(int ordinal) {
        boolean bl;
        this.ordinal = ordinal;
        boolean bl2 = bl = this.ordinal >= 0;
        if (!bl) {
            String string = "The ordinal must be non-negative.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = this.ordinal < 128;
        if (!bl) {
            String string = "Consider implementing a varint encoding.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u00078VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/OrdinalBits$OrdinalWriter;", "", "bits", "Lnet/corda/serialization/internal/OrdinalBits;", "getBits", "()Lnet/corda/serialization/internal/OrdinalBits;", "encodedSize", "", "encodedSize$annotations", "()V", "getEncodedSize", "()I", "putTo", "Ljava/nio/ByteBuffer;", "buffer", "writeTo", "", "stream", "Ljava/io/OutputStream;", "serialization"})
    @KeepForDJVM
    public static interface OrdinalWriter {
        @NotNull
        public OrdinalBits getBits();

        default public int getEncodedSize() {
            return 1;
        }

        @JvmDefault
        default public void writeTo(@NotNull OutputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            stream.write(this.getBits().ordinal);
        }

        @JvmDefault
        @NotNull
        default public ByteBuffer putTo(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            ByteBuffer byteBuffer = buffer.put((byte)this.getBits().ordinal);
            if (byteBuffer == null) {
                Intrinsics.throwNpe();
            }
            return byteBuffer;
        }

        public static /* synthetic */ int access$getEncodedSize$jd(OrdinalWriter $this) {
            return $this.getEncodedSize();
        }

        public static /* synthetic */ void access$writeTo$jd(OrdinalWriter $this, @NotNull OutputStream stream) {
            $this.writeTo(stream);
        }

        @NotNull
        public static /* synthetic */ ByteBuffer access$putTo$jd(OrdinalWriter $this, @NotNull ByteBuffer buffer) {
            return $this.putTo(buffer);
        }
    }
}

