/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.serialization.internal.MutableClassWhitelist;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.custom.BigDecimalSerializer;
import net.corda.serialization.internal.amqp.custom.BigIntegerSerializer;
import net.corda.serialization.internal.amqp.custom.BitSetSerializer;
import net.corda.serialization.internal.amqp.custom.CertPathSerializer;
import net.corda.serialization.internal.amqp.custom.ClassSerializer;
import net.corda.serialization.internal.amqp.custom.ContractAttachmentSerializer;
import net.corda.serialization.internal.amqp.custom.CurrencySerializer;
import net.corda.serialization.internal.amqp.custom.DurationSerializer;
import net.corda.serialization.internal.amqp.custom.EnumSetSerializer;
import net.corda.serialization.internal.amqp.custom.InputStreamSerializer;
import net.corda.serialization.internal.amqp.custom.InstantSerializer;
import net.corda.serialization.internal.amqp.custom.LocalDateSerializer;
import net.corda.serialization.internal.amqp.custom.LocalDateTimeSerializer;
import net.corda.serialization.internal.amqp.custom.LocalTimeSerializer;
import net.corda.serialization.internal.amqp.custom.MonthDaySerializer;
import net.corda.serialization.internal.amqp.custom.OffsetDateTimeSerializer;
import net.corda.serialization.internal.amqp.custom.OffsetTimeSerializer;
import net.corda.serialization.internal.amqp.custom.OpaqueBytesSubSequenceSerializer;
import net.corda.serialization.internal.amqp.custom.OptionalSerializer;
import net.corda.serialization.internal.amqp.custom.PeriodSerializer;
import net.corda.serialization.internal.amqp.custom.StringBufferSerializer;
import net.corda.serialization.internal.amqp.custom.ThrowableSerializer;
import net.corda.serialization.internal.amqp.custom.X509CRLSerializer;
import net.corda.serialization.internal.amqp.custom.X509CertificateSerializer;
import net.corda.serialization.internal.amqp.custom.YearMonthSerializer;
import net.corda.serialization.internal.amqp.custom.YearSerializer;
import net.corda.serialization.internal.amqp.custom.ZoneIdSerializer;
import net.corda.serialization.internal.amqp.custom.ZonedDateTimeSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a#\u0010\b\u001a\u00020\u0002*\u00020\u00002\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/corda/serialization/internal/amqp/SerializerFactory;", "factory", "", "registerCustomSerializers", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "", "Ljava/lang/Class;", "types", "addToWhitelist", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;Ljava/util/Collection;)V", "serialization"})
@JvmName(name="AMQPSerializationScheme")
public final class AMQPSerializationScheme {
    public static final void addToWhitelist(@NotNull SerializerFactory $receiver, @NotNull Collection<? extends Class<?>> types) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        boolean bl2 = bl = CollectionsKt.toSet((Iterable)types).size() == types.size();
        if (!bl) {
            List duplicates = CollectionsKt.toMutableList(types);
            Iterable $receiver$iv = CollectionsKt.toSet((Iterable)types);
            for (Object element$iv : $receiver$iv) {
                Class it = (Class)element$iv;
                Collection collection = duplicates;
                collection.remove(it);
            }
            String string = "Cannot add duplicate classes to the whitelist (" + duplicates + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (Class<?> type : types) {
            ClassWhitelist classWhitelist = $receiver.getWhitelist();
            if (!(classWhitelist instanceof MutableClassWhitelist)) {
                classWhitelist = null;
            }
            MutableClassWhitelist mutableClassWhitelist = (MutableClassWhitelist)classWhitelist;
            if (mutableClassWhitelist == null) continue;
            mutableClassWhitelist.add(type);
        }
    }

    public static final void registerCustomSerializers(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        SerializerFactory $receiver = factory;
        $receiver.register(new ThrowableSerializer($receiver));
        $receiver.register(BigDecimalSerializer.INSTANCE);
        $receiver.register(BigIntegerSerializer.INSTANCE);
        $receiver.register(CurrencySerializer.INSTANCE);
        $receiver.register(new OpaqueBytesSubSequenceSerializer($receiver));
        $receiver.register(new InstantSerializer($receiver));
        $receiver.register(new DurationSerializer($receiver));
        $receiver.register(new LocalDateSerializer($receiver));
        $receiver.register(new LocalDateTimeSerializer($receiver));
        $receiver.register(new LocalTimeSerializer($receiver));
        $receiver.register(new ZonedDateTimeSerializer($receiver));
        $receiver.register(new ZoneIdSerializer($receiver));
        $receiver.register(new OffsetTimeSerializer($receiver));
        $receiver.register(new OffsetDateTimeSerializer($receiver));
        $receiver.register(new OptionalSerializer($receiver));
        $receiver.register(new YearSerializer($receiver));
        $receiver.register(new YearMonthSerializer($receiver));
        $receiver.register(new MonthDaySerializer($receiver));
        $receiver.register(new PeriodSerializer($receiver));
        $receiver.register(new ClassSerializer($receiver));
        $receiver.register(X509CertificateSerializer.INSTANCE);
        $receiver.register(X509CRLSerializer.INSTANCE);
        $receiver.register(new CertPathSerializer($receiver));
        $receiver.register(StringBufferSerializer.INSTANCE);
        $receiver.register(InputStreamSerializer.INSTANCE);
        $receiver.register(new BitSetSerializer($receiver));
        $receiver.register(new EnumSetSerializer($receiver));
        $receiver.register(new ContractAttachmentSerializer($receiver));
    }
}

