/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.corda.serialization.internal.amqp.IllegalTypeNameParserStateException;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\n8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser;", "", "", "typeString", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "parse", "(Ljava/lang/String;)Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "validate", "(Ljava/lang/String;)V", "", "simplified", "Ljava/util/Map;", "<init>", "()V", "ParseState", "serialization"})
public final class AMQPTypeIdentifierParser {
    private static final Map<String, TypeIdentifier> simplified;
    public static final AMQPTypeIdentifierParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeIdentifier parse(@NotNull String typeString) {
        void $receiver$iv;
        ParseState.ParsingRawType initial$iv;
        Intrinsics.checkParameterIsNotNull((Object)typeString, (String)"typeString");
        this.validate(typeString);
        CharSequence charSequence = typeString;
        ParseState accumulator$iv = initial$iv = new ParseState.ParsingRawType(null, null, 2, null);
        void var5_5 = $receiver$iv;
        for (int i = 0; i < var5_5.length(); ++i) {
            void c;
            char element$iv;
            char c2 = element$iv = var5_5.charAt(i);
            ParseState state = accumulator$iv;
            accumulator$iv = state.accept((char)c);
        }
        return ((ParseState)accumulator$iv).getTypeIdentifier();
    }

    private final void validate(String typeString) {
        int maxTypeParamDepth = 0;
        int typeParamdepth = 0;
        int maxArrayDepth = 0;
        boolean wasArray = false;
        int arrayDepth = 0;
        String string = typeString;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (CharsKt.isWhitespace((char)c2) || Character.isJavaIdentifierPart(c = c2) || Character.isJavaIdentifierStart(c = c2) || c2 == '.' || c2 == ',' || c2 == '?' || c2 == '*') continue;
            switch (c2) {
                case '<': {
                    maxTypeParamDepth = Math.max(++typeParamdepth, typeParamdepth);
                    break;
                }
                case '>': {
                    --typeParamdepth;
                    break;
                }
                case '[': {
                    arrayDepth = wasArray ? arrayDepth + 2 : 1;
                    maxArrayDepth = Math.max(maxArrayDepth, arrayDepth);
                    break;
                }
                case ']': {
                    --arrayDepth;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalTypeNameParserStateException("Type name '" + typeString + "' contains illegal character '" + c2 + '\'');
                }
            }
            wasArray = c2 == ']';
        }
        if (maxTypeParamDepth >= 32) {
            throw (Throwable)new IllegalTypeNameParserStateException("Nested depth of type parameters exceeds maximum of 32");
        }
        if (maxArrayDepth >= 32) {
            throw (Throwable)new IllegalTypeNameParserStateException("Nested depth of arrays exceeds maximum of 32");
        }
    }

    private AMQPTypeIdentifierParser() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        Map $receiver$iv;
        AMQPTypeIdentifierParser aMQPTypeIdentifierParser;
        INSTANCE = aMQPTypeIdentifierParser = new AMQPTypeIdentifierParser();
        Map map = $receiver$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"string", (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)"boolean", (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)), TuplesKt.to((Object)"byte", (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)), TuplesKt.to((Object)"char", (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)), TuplesKt.to((Object)"int", (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)"short", (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)), TuplesKt.to((Object)"long", (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)), TuplesKt.to((Object)"double", (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)), TuplesKt.to((Object)"float", (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)), TuplesKt.to((Object)"ubyte", (Object)Reflection.getOrCreateKotlinClass(UnsignedByte.class)), TuplesKt.to((Object)"uint", (Object)Reflection.getOrCreateKotlinClass(UnsignedInteger.class)), TuplesKt.to((Object)"ushort", (Object)Reflection.getOrCreateKotlinClass(UnsignedShort.class)), TuplesKt.to((Object)"ulong", (Object)Reflection.getOrCreateKotlinClass(UnsignedLong.class)), TuplesKt.to((Object)"decimal32", (Object)Reflection.getOrCreateKotlinClass(Decimal32.class)), TuplesKt.to((Object)"decimal64", (Object)Reflection.getOrCreateKotlinClass(Decimal64.class)), TuplesKt.to((Object)"decimal128", (Object)Reflection.getOrCreateKotlinClass(Decimal128.class)), TuplesKt.to((Object)"binary", (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)"timestamp", (Object)Reflection.getOrCreateKotlinClass(Date.class)), TuplesKt.to((Object)"uuid", (Object)Reflection.getOrCreateKotlinClass(UUID.class)), TuplesKt.to((Object)"symbol", (Object)Reflection.getOrCreateKotlinClass(Symbol.class))});
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $$_$_v;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            void var11_11 = $$_$_v;
            KClass v = (KClass)var11_11.getValue();
            TypeIdentifier typeIdentifier = TypeIdentifier.Companion.forClass(JvmClassMappingKt.getJavaObjectType((KClass)v));
            map3.put(k2, typeIdentifier);
        }
        simplified = var3_3;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\u0005J\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u0005\u0082\u0001\u0004\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "", "", "c", "accept", "(C)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "notInParameterList", "unexpected", "<init>", "()V", "Complete", "ParsingArray", "ParsingParameterList", "ParsingRawType", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingRawType;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingArray;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$Complete;", "serialization"})
    private static abstract class ParseState {
        @NotNull
        public abstract ParseState accept(char var1);

        @NotNull
        public abstract TypeIdentifier getTypeIdentifier();

        @NotNull
        public final ParseState unexpected(char c) {
            throw (Throwable)new IllegalTypeNameParserStateException("Unexpected character: '" + c + '\'');
        }

        @NotNull
        public final ParseState notInParameterList(char c) {
            throw (Throwable)new IllegalTypeNameParserStateException("" + '\'' + c + "' encountered, but not parsing type parameter list");
        }

        private ParseState() {
        }

        public /* synthetic */ ParseState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0016R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingRawType;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "", "c", "accept", "(C)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "parent", "Ljava/lang/StringBuilder;", "buffer", "copy", "(Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;Ljava/lang/StringBuilder;)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingRawType;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "getTypeName", "()Ljava/lang/String;", "", "hashCode", "()I", "toString", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "getParent", "()Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "<init>", "(Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;Ljava/lang/StringBuilder;)V", "serialization"})
        public static final class ParsingRawType
        extends ParseState {
            @Nullable
            private final ParsingParameterList parent;
            @NotNull
            private final StringBuilder buffer;

            @Override
            @NotNull
            public ParseState accept(char c) {
                ParseState parseState;
                switch (c) {
                    case ',': {
                        if (this.getParent() == null) {
                            parseState = this.notInParameterList(c);
                            break;
                        }
                        parseState = new ParsingRawType(this.getParent().addParameter(this.getTypeIdentifier()), null, 2, null);
                        break;
                    }
                    case '[': {
                        parseState = new ParsingArray(this.getTypeIdentifier(), this.getParent());
                        break;
                    }
                    case ']': {
                        parseState = this.unexpected(c);
                        break;
                    }
                    case '<': {
                        parseState = new ParsingRawType(new ParsingParameterList(this.getTypeName(), this.getParent(), null, 4, null), null, 2, null);
                        break;
                    }
                    case '>': {
                        parseState = this.getParent();
                        if (parseState != null && (parseState = ((ParsingParameterList)parseState).addParameter(this.getTypeIdentifier())) != null && (parseState = ((ParsingParameterList)parseState).accept(c)) != null) break;
                        parseState = this.notInParameterList(c);
                        break;
                    }
                    default: {
                        ParsingRawType parsingRawType;
                        ParsingRawType $receiver = parsingRawType = this;
                        $receiver.buffer.append(c);
                        parseState = parsingRawType;
                    }
                }
                return parseState;
            }

            private final String getTypeName() {
                String string;
                String string2 = this.buffer.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buffer.toString()");
                String string3 = string = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String typeName2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                if (StringsKt.contains$default((CharSequence)typeName2, (char)' ', (boolean)false, (int)2, null)) {
                    throw (Throwable)new IllegalTypeNameParserStateException("Illegal whitespace in type name " + typeName2);
                }
                return typeName2;
            }

            @Override
            @NotNull
            public TypeIdentifier getTypeIdentifier() {
                TypeIdentifier typeIdentifier;
                String typeName2 = this.getTypeName();
                String string = typeName2;
                if (Intrinsics.areEqual((Object)string, (Object)"*")) {
                    typeIdentifier = TypeIdentifier.TopType.INSTANCE;
                } else if (Intrinsics.areEqual((Object)string, (Object)"?")) {
                    typeIdentifier = TypeIdentifier.UnknownType.INSTANCE;
                } else {
                    Map map = simplified;
                    Map map2 = map;
                    if (map2.containsKey(string)) {
                        Object v = simplified.get(typeName2);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        typeIdentifier = (TypeIdentifier)v;
                    } else {
                        typeIdentifier = new TypeIdentifier.Unparameterised(typeName2);
                    }
                }
                return typeIdentifier;
            }

            @Nullable
            public ParsingParameterList getParent() {
                return this.parent;
            }

            public ParsingRawType(@Nullable ParsingParameterList parent, @NotNull StringBuilder buffer) {
                Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                super(null);
                this.parent = parent;
                this.buffer = buffer;
            }

            public /* synthetic */ ParsingRawType(ParsingParameterList parsingParameterList, StringBuilder stringBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    stringBuilder = new StringBuilder();
                }
                this(parsingParameterList, stringBuilder);
            }

            @NotNull
            public final ParsingRawType copy(@Nullable ParsingParameterList parent, @NotNull StringBuilder buffer) {
                Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                return new ParsingRawType(parent, buffer);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ParsingRawType copy$default(ParsingRawType parsingRawType, ParsingParameterList parsingParameterList, StringBuilder stringBuilder, int n, Object object) {
                if ((n & 1) != 0) {
                    parsingParameterList = parsingRawType.getParent();
                }
                if ((n & 2) != 0) {
                    stringBuilder = parsingRawType.buffer;
                }
                return parsingRawType.copy(parsingParameterList, stringBuilder);
            }

            @NotNull
            public String toString() {
                return "ParsingRawType(parent=" + this.getParent() + ", buffer=" + this.buffer + ")";
            }

            public int hashCode() {
                ParsingParameterList parsingParameterList = this.getParent();
                StringBuilder stringBuilder = this.buffer;
                return (parsingParameterList != null ? ((Object)parsingParameterList).hashCode() : 0) * 31 + (stringBuilder != null ? stringBuilder.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ParsingRawType)) break block3;
                        ParsingRawType parsingRawType = (ParsingRawType)object;
                        if (!Intrinsics.areEqual((Object)this.getParent(), (Object)parsingRawType.getParent()) || !Intrinsics.areEqual((Object)this.buffer, (Object)parsingRawType.buffer)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00002\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001e\u0010\f\u001a\u0004\u0018\u00010\u00008\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "", "c", "accept", "(C)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "parameter", "addParameter", "(Lnet/corda/serialization/internal/model/TypeIdentifier;)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "", "typeName", "parent", "", "parameters", "copy", "(Ljava/lang/String;Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;Ljava/util/List;)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lnet/corda/serialization/internal/model/TypeIdentifier$Parameterised;", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier$Parameterised;", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "getParent", "()Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "<init>", "(Ljava/lang/String;Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;Ljava/util/List;)V", "serialization"})
        public static final class ParsingParameterList
        extends ParseState {
            @NotNull
            private final String typeName;
            @Nullable
            private final ParsingParameterList parent;
            @NotNull
            private final List<TypeIdentifier> parameters;

            @Override
            @NotNull
            public ParseState accept(char c) {
                ParseState parseState;
                switch (c) {
                    case ' ': {
                        parseState = this;
                        break;
                    }
                    case ',': {
                        parseState = new ParsingRawType(this, null, 2, null);
                        break;
                    }
                    case '[': {
                        if (this.parameters.isEmpty()) {
                            parseState = this.unexpected(c);
                            break;
                        }
                        parseState = new ParsingArray(this.parameters.get(CollectionsKt.getLastIndex(this.parameters)), ParsingParameterList.copy$default(this, null, null, this.parameters.subList(0, CollectionsKt.getLastIndex(this.parameters)), 3, null));
                        break;
                    }
                    case '>': {
                        ParsingParameterList parsingParameterList = this.getParent();
                        if (parsingParameterList != null && (parsingParameterList = parsingParameterList.addParameter(this.getTypeIdentifier())) != null) {
                            parseState = parsingParameterList;
                            break;
                        }
                        parseState = new Complete(this.getTypeIdentifier());
                        break;
                    }
                    default: {
                        parseState = this.unexpected(c);
                    }
                }
                return parseState;
            }

            @NotNull
            public final ParsingParameterList addParameter(@NotNull TypeIdentifier parameter) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                return ParsingParameterList.copy$default(this, null, null, CollectionsKt.plus((Collection)this.parameters, (Object)parameter), 3, null);
            }

            @Override
            @NotNull
            public TypeIdentifier.Parameterised getTypeIdentifier() {
                return new TypeIdentifier.Parameterised(this.typeName, null, this.parameters);
            }

            @Nullable
            public ParsingParameterList getParent() {
                return this.parent;
            }

            public ParsingParameterList(@NotNull String typeName2, @Nullable ParsingParameterList parent, @NotNull List<? extends TypeIdentifier> parameters) {
                Intrinsics.checkParameterIsNotNull((Object)typeName2, (String)"typeName");
                Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
                super(null);
                this.typeName = typeName2;
                this.parent = parent;
                this.parameters = parameters;
            }

            public /* synthetic */ ParsingParameterList(String string, ParsingParameterList parsingParameterList, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(string, parsingParameterList, list);
            }

            @NotNull
            public final ParsingParameterList copy(@NotNull String typeName2, @Nullable ParsingParameterList parent, @NotNull List<? extends TypeIdentifier> parameters) {
                Intrinsics.checkParameterIsNotNull((Object)typeName2, (String)"typeName");
                Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
                return new ParsingParameterList(typeName2, parent, parameters);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ParsingParameterList copy$default(ParsingParameterList parsingParameterList, String string, ParsingParameterList parsingParameterList2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = parsingParameterList.typeName;
                }
                if ((n & 2) != 0) {
                    parsingParameterList2 = parsingParameterList.getParent();
                }
                if ((n & 4) != 0) {
                    list = parsingParameterList.parameters;
                }
                return parsingParameterList.copy(string, parsingParameterList2, list);
            }

            @NotNull
            public String toString() {
                return "ParsingParameterList(typeName=" + this.typeName + ", parent=" + this.getParent() + ", parameters=" + this.parameters + ")";
            }

            public int hashCode() {
                String string = this.typeName;
                ParsingParameterList parsingParameterList = this.getParent();
                List<TypeIdentifier> list = this.parameters;
                return ((string != null ? string.hashCode() : 0) * 31 + (parsingParameterList != null ? ((Object)parsingParameterList).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ParsingParameterList)) break block3;
                        ParsingParameterList parsingParameterList = (ParsingParameterList)object;
                        if (!Intrinsics.areEqual((Object)this.typeName, (Object)parsingParameterList.typeName) || !Intrinsics.areEqual((Object)this.getParent(), (Object)parsingParameterList.getParent()) || !Intrinsics.areEqual(this.parameters, parsingParameterList.parameters)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001e\u0010\t\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingArray;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "", "c", "accept", "(C)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "componentType", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "parent", "copy", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingArray;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "forcePrimitive", "(Lnet/corda/serialization/internal/model/TypeIdentifier;)Lnet/corda/serialization/internal/model/TypeIdentifier;", "Lnet/corda/serialization/internal/model/TypeIdentifier$ArrayOf;", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier$ArrayOf;", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "getParent", "()Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;", "<init>", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$ParsingParameterList;)V", "serialization"})
        public static final class ParsingArray
        extends ParseState {
            @NotNull
            private final TypeIdentifier componentType;
            @Nullable
            private final ParsingParameterList parent;

            @Override
            @NotNull
            public ParseState accept(char c) {
                ParseState parseState;
                switch (c) {
                    case ' ': {
                        parseState = this;
                        break;
                    }
                    case 'p': {
                        parseState = new ParsingArray(this.forcePrimitive(this.componentType), this.getParent());
                        break;
                    }
                    case ']': {
                        ParsingParameterList parsingParameterList = this.getParent();
                        if (parsingParameterList != null && (parsingParameterList = parsingParameterList.addParameter(this.getTypeIdentifier())) != null) {
                            parseState = parsingParameterList;
                            break;
                        }
                        parseState = new Complete(this.getTypeIdentifier());
                        break;
                    }
                    default: {
                        parseState = this.unexpected(c);
                    }
                }
                return parseState;
            }

            @Override
            @NotNull
            public TypeIdentifier.ArrayOf getTypeIdentifier() {
                return new TypeIdentifier.ArrayOf(this.componentType);
            }

            private final TypeIdentifier forcePrimitive(TypeIdentifier componentType) {
                Class clazz = Primitives.unwrap(SerializationHelperKt.asClass(TypeIdentifier.getLocalType$default(componentType, null, 1, null)));
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"Primitives.unwrap(compon\u2026getLocalType().asClass())");
                return TypeIdentifier.Companion.forClass(clazz);
            }

            @Nullable
            public ParsingParameterList getParent() {
                return this.parent;
            }

            public ParsingArray(@NotNull TypeIdentifier componentType, @Nullable ParsingParameterList parent) {
                Intrinsics.checkParameterIsNotNull((Object)componentType, (String)"componentType");
                super(null);
                this.componentType = componentType;
                this.parent = parent;
            }

            @NotNull
            public final ParsingArray copy(@NotNull TypeIdentifier componentType, @Nullable ParsingParameterList parent) {
                Intrinsics.checkParameterIsNotNull((Object)componentType, (String)"componentType");
                return new ParsingArray(componentType, parent);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ParsingArray copy$default(ParsingArray parsingArray, TypeIdentifier typeIdentifier, ParsingParameterList parsingParameterList, int n, Object object) {
                if ((n & 1) != 0) {
                    typeIdentifier = parsingArray.componentType;
                }
                if ((n & 2) != 0) {
                    parsingParameterList = parsingArray.getParent();
                }
                return parsingArray.copy(typeIdentifier, parsingParameterList);
            }

            @NotNull
            public String toString() {
                return "ParsingArray(componentType=" + this.componentType + ", parent=" + this.getParent() + ")";
            }

            public int hashCode() {
                TypeIdentifier typeIdentifier = this.componentType;
                ParsingParameterList parsingParameterList = this.getParent();
                return (typeIdentifier != null ? typeIdentifier.hashCode() : 0) * 31 + (parsingParameterList != null ? ((Object)parsingParameterList).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ParsingArray)) break block3;
                        ParsingArray parsingArray = (ParsingArray)object;
                        if (!Intrinsics.areEqual((Object)this.componentType, (Object)parsingArray.componentType) || !Intrinsics.areEqual((Object)this.getParent(), (Object)parsingArray.getParent())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$Complete;", "Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "", "c", "accept", "(C)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "identifier", "copy", "(Lnet/corda/serialization/internal/model/TypeIdentifier;)Lnet/corda/serialization/internal/amqp/AMQPTypeIdentifierParser$ParseState$Complete;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "getTypeIdentifier", "()Lnet/corda/serialization/internal/model/TypeIdentifier;", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "<init>", "(Lnet/corda/serialization/internal/model/TypeIdentifier;)V", "serialization"})
        public static final class Complete
        extends ParseState {
            @NotNull
            private final TypeIdentifier identifier;

            @Override
            @NotNull
            public ParseState accept(char c) {
                ParseState parseState;
                switch (c) {
                    case ' ': {
                        parseState = this;
                        break;
                    }
                    case '[': {
                        parseState = new ParsingArray(this.identifier, null);
                        break;
                    }
                    default: {
                        parseState = this.unexpected(c);
                    }
                }
                return parseState;
            }

            @Override
            @NotNull
            public TypeIdentifier getTypeIdentifier() {
                return this.identifier;
            }

            public Complete(@NotNull TypeIdentifier identifier) {
                Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
                super(null);
                this.identifier = identifier;
            }

            @NotNull
            public final Complete copy(@NotNull TypeIdentifier identifier) {
                Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
                return new Complete(identifier);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Complete copy$default(Complete complete, TypeIdentifier typeIdentifier, int n, Object object) {
                if ((n & 1) != 0) {
                    typeIdentifier = complete.identifier;
                }
                return complete.copy(typeIdentifier);
            }

            @NotNull
            public String toString() {
                return "Complete(identifier=" + this.identifier + ")";
            }

            public int hashCode() {
                TypeIdentifier typeIdentifier = this.identifier;
                return typeIdentifier != null ? typeIdentifier.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Complete)) break block3;
                        Complete complete = (Complete)object;
                        if (!Intrinsics.areEqual((Object)this.identifier, (Object)complete.identifier)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

