/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.KeepForDJVM;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.ContextPropertyKeys;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationCustomSerializer;
import net.corda.core.serialization.SerializationWhitelist;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.CordaSerializationMagic;
import net.corda.serialization.internal.SerializationScheme;
import net.corda.serialization.internal.amqp.AMQPSerializationScheme;
import net.corda.serialization.internal.amqp.AMQPSerializerFactories;
import net.corda.serialization.internal.amqp.AbstractAMQPSerializationScheme;
import net.corda.serialization.internal.amqp.AbstractAMQPSerializationScheme$WhenMappings;
import net.corda.serialization.internal.amqp.AccessOrderLinkedHashMap;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationFactoryCacheKey;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.amqp.SerializerFactoryFactory;
import net.corda.serialization.internal.amqp.custom.PublicKeySerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u0000 92\u00020\u0001:\u00019BI\u0012\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0011\u0012\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u0011\u0012\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00150-\u0012\b\b\u0002\u00102\u001a\u000201\u00a2\u0006\u0004\b7\u00108J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J7\u0010\u000f\u001a\u00028\u0000\"\b\b\u0000\u0010\b*\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\rH$\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u0017\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\rH$\u00a2\u0006\u0004\b\u001f\u0010\u0017J/\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!\"\b\b\u0000\u0010\b*\u00020\u00072\u0006\u0010 \u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\"\u0010#R$\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010%R \u0010)\u001a\u0006\u0012\u0002\b\u00030(8\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\"\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u00150-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0019\u00102\u001a\u0002018\u0006@\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u0006:"}, d2={"Lnet/corda/serialization/internal/amqp/AbstractAMQPSerializationScheme;", "Lnet/corda/serialization/internal/SerializationScheme;", "Lnet/corda/serialization/internal/CordaSerializationMagic;", "magic", "", "canDeserializeVersion", "(Lnet/corda/serialization/internal/CordaSerializationMagic;)Z", "", "T", "Lnet/corda/core/utilities/ByteSequence;", "byteSequence", "Ljava/lang/Class;", "clazz", "Lnet/corda/core/serialization/SerializationContext;", "context", "deserialize", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "", "Lnet/corda/core/serialization/SerializationCustomSerializer;", "getRegisteredCustomSerializers", "()Ljava/util/Set;", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "getSerializerFactory", "(Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/serialization/internal/amqp/SerializerFactory;", "factory", "", "registerCustomSerializers", "(Lnet/corda/core/serialization/SerializationContext;Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "registerCustomWhitelists", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "rpcClientSerializerFactory", "rpcServerSerializerFactory", "obj", "Lnet/corda/core/serialization/SerializedBytes;", "serialize", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "cordappCustomSerializers", "Ljava/util/Set;", "Lnet/corda/core/serialization/SerializationWhitelist;", "cordappSerializationWhitelists", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "publicKeySerializer", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "getPublicKeySerializer", "()Lnet/corda/serialization/internal/amqp/CustomSerializer;", "", "Lnet/corda/serialization/internal/amqp/SerializationFactoryCacheKey;", "serializerFactoriesForContexts", "Ljava/util/Map;", "Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;", "sff", "Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;", "getSff", "()Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;", "maybeNotConcurrentSerializerFactoriesForContexts", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Lnet/corda/serialization/internal/amqp/SerializerFactoryFactory;)V", "Companion", "serialization"})
@KeepForDJVM
public abstract class AbstractAMQPSerializationScheme
implements SerializationScheme {
    private final Map<SerializationFactoryCacheKey, SerializerFactory> serializerFactoriesForContexts;
    @NotNull
    private final CustomSerializer<?> publicKeySerializer;
    private final Set<SerializationCustomSerializer<?, ?>> cordappCustomSerializers;
    private final Set<SerializationWhitelist> cordappSerializationWhitelists;
    @NotNull
    private final SerializerFactoryFactory sff;
    private static final Lazy serializationWhitelists$delegate;
    public static final Companion Companion;

    @NotNull
    public final Set<SerializationCustomSerializer<?, ?>> getRegisteredCustomSerializers() {
        return this.cordappCustomSerializers;
    }

    private final void registerCustomSerializers(SerializationContext context, SerializerFactory factory) {
        SerializationCustomSerializer customSerializer;
        factory.register(this.getPublicKeySerializer());
        AMQPSerializationScheme.registerCustomSerializers(factory);
        Iterable $receiver$iv = context.getCustomSerializers();
        for (Object element$iv : $receiver$iv) {
            customSerializer = (SerializationCustomSerializer)element$iv;
            factory.registerExternal(new CorDappCustomSerializer(customSerializer, factory));
        }
        $receiver$iv = this.cordappCustomSerializers;
        for (Object element$iv : $receiver$iv) {
            customSerializer = (SerializationCustomSerializer)element$iv;
            if (!Intrinsics.areEqual((Object)customSerializer.getClass().getClassLoader(), (Object)context.getDeserializationClassLoader())) continue;
            factory.registerExternal(new CorDappCustomSerializer(customSerializer, factory));
        }
        Object v = context.getProperties().get(ContextPropertyKeys.SERIALIZERS);
        if (v != null) {
            Object v2;
            Object $receiver = v2 = v;
            Iterable $receiver$iv2 = (Iterable)InternalUtils.uncheckedCast($receiver);
            for (Object element$iv : $receiver$iv2) {
                CustomSerializer it = (CustomSerializer)element$iv;
                factory.register(it);
            }
        }
    }

    private final void registerCustomWhitelists(SerializerFactory factory) {
        SerializationWhitelist it;
        Iterable $receiver$iv = AbstractAMQPSerializationScheme.Companion.getSerializationWhitelists();
        for (Object element$iv : $receiver$iv) {
            it = (SerializationWhitelist)element$iv;
            AMQPSerializationScheme.addToWhitelist(factory, it.getWhitelist());
        }
        $receiver$iv = this.cordappSerializationWhitelists;
        for (Object element$iv : $receiver$iv) {
            it = (SerializationWhitelist)element$iv;
            AMQPSerializationScheme.addToWhitelist(factory, it.getWhitelist());
        }
    }

    @NotNull
    protected abstract SerializerFactory rpcClientSerializerFactory(@NotNull SerializationContext var1);

    @NotNull
    protected abstract SerializerFactory rpcServerSerializerFactory(@NotNull SerializationContext var1);

    @NotNull
    public CustomSerializer<?> getPublicKeySerializer() {
        return this.publicKeySerializer;
    }

    @NotNull
    public final SerializerFactory getSerializerFactory(@NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializationFactoryCacheKey key = new SerializationFactoryCacheKey(context.getWhitelist(), context.getDeserializationClassLoader(), context.getPreventDataLoss(), context.getCustomSerializers());
        SerializerFactory serializerFactory = this.serializerFactoriesForContexts.get(key);
        if (serializerFactory == null) {
            SerializerFactory serializerFactory2 = this.serializerFactoriesForContexts.computeIfAbsent(key, new Function<SerializationFactoryCacheKey, SerializerFactory>(this, context){
                final /* synthetic */ AbstractAMQPSerializationScheme this$0;
                final /* synthetic */ SerializationContext $context;

                @NotNull
                public final SerializerFactory apply(@NotNull SerializationFactoryCacheKey it) {
                    SerializerFactory serializerFactory;
                    SerializerFactory serializerFactory2;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    switch (AbstractAMQPSerializationScheme$WhenMappings.$EnumSwitchMapping$0[this.$context.getUseCase().ordinal()]) {
                        case 1: {
                            serializerFactory2 = this.this$0.rpcClientSerializerFactory(this.$context);
                            break;
                        }
                        case 2: {
                            serializerFactory2 = this.this$0.rpcServerSerializerFactory(this.$context);
                            break;
                        }
                        default: {
                            serializerFactory2 = this.this$0.getSff().make(this.$context);
                        }
                    }
                    SerializerFactory it2 = serializerFactory = serializerFactory2;
                    AbstractAMQPSerializationScheme.access$registerCustomSerializers(this.this$0, this.$context, it2);
                    AbstractAMQPSerializationScheme.access$registerCustomWhitelists(this.this$0, it2);
                    return serializerFactory;
                }
                {
                    this.this$0 = abstractAMQPSerializationScheme;
                    this.$context = serializationContext;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)serializerFactory2, (String)"serializerFactoriesForCo\u2026)\n            }\n        }");
            serializerFactory = serializerFactory2;
        }
        return serializerFactory;
    }

    @Override
    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new DeserializationInput(serializerFactory).deserialize(byteSequence, clazz, context);
    }

    @Override
    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new SerializationOutput(serializerFactory).serialize(obj, context);
    }

    protected final boolean canDeserializeVersion(@NotNull CordaSerializationMagic magic) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)magic), (String)"magic");
        return Intrinsics.areEqual((Object)((Object)magic), (Object)((Object)SchemaKt.getAmqpMagic()));
    }

    @NotNull
    public final SerializerFactoryFactory getSff() {
        return this.sff;
    }

    public AbstractAMQPSerializationScheme(@NotNull Set<? extends SerializationCustomSerializer<?, ?>> cordappCustomSerializers, @NotNull Set<? extends SerializationWhitelist> cordappSerializationWhitelists, @NotNull Map<SerializationFactoryCacheKey, SerializerFactory> maybeNotConcurrentSerializerFactoriesForContexts, @NotNull SerializerFactoryFactory sff) {
        Map<SerializationFactoryCacheKey, SerializerFactory> map;
        Intrinsics.checkParameterIsNotNull(cordappCustomSerializers, (String)"cordappCustomSerializers");
        Intrinsics.checkParameterIsNotNull(cordappSerializationWhitelists, (String)"cordappSerializationWhitelists");
        Intrinsics.checkParameterIsNotNull(maybeNotConcurrentSerializerFactoriesForContexts, (String)"maybeNotConcurrentSerializerFactoriesForContexts");
        Intrinsics.checkParameterIsNotNull((Object)sff, (String)"sff");
        this.cordappCustomSerializers = cordappCustomSerializers;
        this.cordappSerializationWhitelists = cordappSerializationWhitelists;
        this.sff = sff;
        if (maybeNotConcurrentSerializerFactoriesForContexts instanceof AccessOrderLinkedHashMap) {
            Map<SerializationFactoryCacheKey, SerializerFactory> map2 = Collections.synchronizedMap(maybeNotConcurrentSerializerFactoriesForContexts);
            map = map2;
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.synchronized\u2026izerFactoriesForContexts)");
        } else {
            map = maybeNotConcurrentSerializerFactoriesForContexts;
        }
        this.serializerFactoriesForContexts = map;
        this.publicKeySerializer = PublicKeySerializer.INSTANCE;
    }

    public /* synthetic */ AbstractAMQPSerializationScheme(Set set, Set set2, Map map, SerializerFactoryFactory serializerFactoryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            serializerFactoryFactory = AMQPSerializerFactories.createSerializerFactoryFactory();
        }
        this(set, set2, map, serializerFactoryFactory);
    }

    static {
        Companion = new Companion(null);
        serializationWhitelists$delegate = LazyKt.lazy((Function0)Companion.serializationWhitelists.2.INSTANCE);
    }

    public static final /* synthetic */ void access$registerCustomSerializers(AbstractAMQPSerializationScheme $this, @NotNull SerializationContext context, @NotNull SerializerFactory factory) {
        $this.registerCustomSerializers(context, factory);
    }

    public static final /* synthetic */ void access$registerCustomWhitelists(AbstractAMQPSerializationScheme $this, @NotNull SerializerFactory factory) {
        $this.registerCustomWhitelists(factory);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nR#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028B@\u0002X\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/AbstractAMQPSerializationScheme$Companion;", "", "", "Lnet/corda/core/serialization/SerializationWhitelist;", "serializationWhitelists$delegate", "Lkotlin/Lazy;", "getSerializationWhitelists", "()Ljava/util/List;", "serializationWhitelists", "<init>", "()V", "serialization"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "serializationWhitelists", "getSerializationWhitelists()Ljava/util/List;"))};
        }

        private final List<SerializationWhitelist> getSerializationWhitelists() {
            Lazy lazy = serializationWhitelists$delegate;
            return (List)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

