/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.core.CordaThrowable;
import net.corda.core.internal.InternalUtils;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.CorDappCustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.DuplicateCustomSerializerException;
import net.corda.serialization.internal.amqp.IllegalCustomSerializerException;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.SerializerFor;
import net.corda.serialization.internal.model.DefaultCacheProvider;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bJ$\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0016R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u00020\u0016*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006("}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry;", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "descriptorBasedSerializerRegistry", "Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;", "(Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;)V", "allowedFor", "", "Ljava/lang/Class;", "(Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;Ljava/util/Set;)V", "customSerializerNames", "", "", "getCustomSerializerNames", "()Ljava/util/List;", "customSerializers", "", "Lnet/corda/serialization/internal/amqp/SerializerFor;", "customSerializersCache", "", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerIdentifier;", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult;", "isCustomSerializationForbidden", "", "(Ljava/lang/Class;)Z", "doFindCustomSerializer", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "clazz", "declaredType", "Ljava/lang/reflect/Type;", "findCustomSerializer", "register", "", "customSerializer", "Lnet/corda/serialization/internal/amqp/CustomSerializer;", "registerExternal", "Lnet/corda/serialization/internal/amqp/CorDappCustomSerializer;", "Companion", "CustomSerializerIdentifier", "CustomSerializerLookupResult", "serialization"})
public final class CachingCustomSerializerRegistry
implements CustomSerializerRegistry {
    private final Map<CustomSerializerIdentifier, CustomSerializerLookupResult> customSerializersCache;
    private final List<SerializerFor> customSerializers;
    private final DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry;
    private final Set<Class<?>> allowedFor;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getCustomSerializerNames() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.customSerializers;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void serializer2;
            SerializerFor serializerFor = (SerializerFor)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = serializer2 instanceof CorDappCustomSerializer ? serializer2.toString() : serializer2.getClass() + " - Classloader: " + serializer2.getClass().getClassLoader();
            collection.add(string);
        }
        return (List)var3_3;
    }

    @Override
    public void register(@NotNull CustomSerializer<? extends Object> customSerializer) {
        Map<CustomSerializerIdentifier, CustomSerializerLookupResult> map;
        Intrinsics.checkParameterIsNotNull(customSerializer, (String)"customSerializer");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string = "action=\"Registering custom serializer\", class=\"" + customSerializer.getType() + '\"';
            logger.trace(string);
        }
        if (!(map = this.customSerializersCache).isEmpty()) {
            logger.warn("Attempting to register custom serializer " + customSerializer.getType() + " in an active cache." + "All serializers should be registered before the cache comes into use.");
        }
        String string = customSerializer.getTypeDescriptor().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"customSerializer.typeDescriptor.toString()");
        this.descriptorBasedSerializerRegistry.getOrBuild(string, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<CustomSerializer<? extends Object>>(this, customSerializer){
            final /* synthetic */ CachingCustomSerializerRegistry this$0;
            final /* synthetic */ CustomSerializer $customSerializer;

            @NotNull
            public final CustomSerializer<? extends Object> invoke() {
                Collection collection = CachingCustomSerializerRegistry.access$getCustomSerializers$p(this.this$0);
                Iterator<TypeIdentifier> iterator = this.$customSerializer;
                collection.add(iterator);
                for (CustomSerializer customSerializer : this.$customSerializer.getAdditionalSerializers()) {
                    this.this$0.register(customSerializer);
                }
                for (TypeIdentifier typeIdentifier : this.$customSerializer.getDeserializationAliases()) {
                    Symbol aliasDescriptor = SchemaKt.typeDescriptorFor(typeIdentifier);
                    if (!(Intrinsics.areEqual((Object)aliasDescriptor, (Object)this.$customSerializer.getTypeDescriptor()) ^ true)) continue;
                    DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry = CachingCustomSerializerRegistry.access$getDescriptorBasedSerializerRegistry$p(this.this$0);
                    String string = aliasDescriptor.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aliasDescriptor.toString()");
                    descriptorBasedSerializerRegistry.set(string, this.$customSerializer);
                }
                return this.$customSerializer;
            }
            {
                this.this$0 = cachingCustomSerializerRegistry;
                this.$customSerializer = customSerializer;
                super(0);
            }
        }));
    }

    @Override
    public void registerExternal(@NotNull CorDappCustomSerializer customSerializer) {
        Map<CustomSerializerIdentifier, CustomSerializerLookupResult> map;
        Intrinsics.checkParameterIsNotNull((Object)customSerializer, (String)"customSerializer");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string = "action=\"Registering external serializer\", class=\"" + customSerializer.getType() + '\"';
            logger.trace(string);
        }
        if (!(map = this.customSerializersCache).isEmpty()) {
            logger.warn("Attempting to register custom serializer " + customSerializer.getType() + " in an active cache." + "All serializers must be registered before the cache comes into use.");
        }
        String string = customSerializer.getTypeDescriptor().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"customSerializer.typeDescriptor.toString()");
        this.descriptorBasedSerializerRegistry.getOrBuild(string, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<CorDappCustomSerializer>(this, customSerializer){
            final /* synthetic */ CachingCustomSerializerRegistry this$0;
            final /* synthetic */ CorDappCustomSerializer $customSerializer;

            @NotNull
            public final CorDappCustomSerializer invoke() {
                Collection collection = CachingCustomSerializerRegistry.access$getCustomSerializers$p(this.this$0);
                CorDappCustomSerializer corDappCustomSerializer = this.$customSerializer;
                collection.add(corDappCustomSerializer);
                return this.$customSerializer;
            }
            {
                this.this$0 = cachingCustomSerializerRegistry;
                this.$customSerializer = corDappCustomSerializer;
                super(0);
            }
        }));
    }

    @Override
    @Nullable
    public AMQPSerializer<Object> findCustomSerializer(@NotNull Class<?> clazz, @NotNull Type declaredType) {
        CustomSerializerLookupResult customSerializerLookupResult;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        CustomSerializerIdentifier typeIdentifier = new CustomSerializerIdentifier(TypeIdentifier.Companion.forClass(clazz), TypeIdentifier.Companion.forGenericType$default(TypeIdentifier.Companion, declaredType, null, 2, null));
        Map<CustomSerializerIdentifier, CustomSerializerLookupResult> $receiver$iv = this.customSerializersCache;
        CustomSerializerLookupResult value$iv = $receiver$iv.get(typeIdentifier);
        if (value$iv == null) {
            AMQPSerializer<Object> customSerializer = this.doFindCustomSerializer(clazz, declaredType);
            CustomSerializerLookupResult answer$iv = customSerializer == null ? (CustomSerializerLookupResult)CustomSerializerLookupResult.None.INSTANCE : (CustomSerializerLookupResult)new CustomSerializerLookupResult.CustomSerializerFound(customSerializer);
            $receiver$iv.put(typeIdentifier, answer$iv);
            customSerializerLookupResult = answer$iv;
        } else {
            customSerializerLookupResult = value$iv;
        }
        return customSerializerLookupResult.getSerializerIfFound();
    }

    /*
     * WARNING - void declaration
     */
    private final AMQPSerializer<Object> doFindCustomSerializer(Class<?> clazz, Type declaredType) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Class<?> declaredSuperClass = SerializationHelperKt.asClass(declaredType).getSuperclass();
        Iterable iterable = $receiver$iv = (Iterable)this.customSerializers;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            AMQPSerializer aMQPSerializer;
            AMQPSerializer aMQPSerializer2;
            Object element$iv$iv = element$iv$iv$iv;
            SerializerFor customSerializer = (SerializerFor)element$iv$iv;
            if (!customSerializer.isSerializerFor(clazz)) {
                aMQPSerializer2 = null;
            } else if (declaredSuperClass == null || !customSerializer.isSerializerFor(declaredSuperClass) || !customSerializer.getRevealSubclassesInSchema()) {
                SerializerFor serializerFor;
                Logger $receiver$iv2 = logger;
                if ($receiver$iv2.isDebugEnabled()) {
                    Logger logger = $receiver$iv2;
                    String string = "action=\"Using custom serializer\", class=" + clazz.getTypeName() + ", declaredType=" + declaredType.getTypeName();
                    logger.debug(string);
                }
                if (!((serializerFor = customSerializer) instanceof AMQPSerializer)) {
                    serializerFor = null;
                }
                aMQPSerializer2 = (AMQPSerializer)((Object)serializerFor);
            } else {
                aMQPSerializer2 = new CustomSerializer.SubClass(clazz, (CustomSerializer)InternalUtils.uncheckedCast((Object)customSerializer));
            }
            if (aMQPSerializer2 == null) continue;
            AMQPSerializer it$iv$iv = aMQPSerializer = aMQPSerializer2;
            destination$iv$iv.add(it$iv$iv);
        }
        List declaredSerializers = (List)destination$iv$iv;
        if (declaredSerializers.isEmpty()) {
            return null;
        }
        if (declaredSerializers.size() > 1) {
            Collection<String> collection;
            $receiver$iv = declaredSerializers;
            StringBuilder stringBuilder = new StringBuilder().append("Duplicate custom serializers detected for ").append(clazz).append(": ");
            Logger logger = CachingCustomSerializerRegistry.logger;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Object element$iv$iv$iv;
                element$iv$iv$iv = (AMQPSerializer)item$iv$iv;
                collection = destination$iv$iv;
                String string = Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            logger.warn(stringBuilder.append(collection).toString());
            throw (Throwable)new DuplicateCustomSerializerException(declaredSerializers, clazz);
        }
        if (this.isCustomSerializationForbidden(clazz)) {
            logger.warn("Illegal custom serializer detected for " + clazz + ": " + Reflection.getOrCreateKotlinClass(CollectionsKt.first((List)declaredSerializers).getClass()).getQualifiedName());
            throw (Throwable)new IllegalCustomSerializerException((AMQPSerializer)CollectionsKt.first((List)declaredSerializers), clazz);
        }
        Object object = CollectionsKt.first((List)declaredSerializers);
        AMQPSerializer it = (AMQPSerializer)object;
        return it instanceof CustomSerializer ? ((CustomSerializer)it).specialiseFor(declaredType) : it;
    }

    private final boolean isCustomSerializationForbidden(@NotNull Class<?> $receiver) {
        boolean bl;
        if (AMQPTypeIdentifiers.INSTANCE.isPrimitive($receiver)) {
            bl = true;
        } else if (SerializationHelperKt.isSubClassOf($receiver, (Type)((Object)CordaThrowable.class))) {
            bl = false;
        } else {
            boolean bl2;
            block7: {
                Iterable $receiver$iv = this.allowedFor;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Class it = (Class)element$iv;
                        if (!it.isAssignableFrom($receiver)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2 ? false : $receiver.isAnnotationPresent(CordaSerializable.class);
        }
        return bl;
    }

    public CachingCustomSerializerRegistry(@NotNull DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry, @NotNull Set<? extends Class<?>> allowedFor) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)descriptorBasedSerializerRegistry, (String)"descriptorBasedSerializerRegistry");
        Intrinsics.checkParameterIsNotNull(allowedFor, (String)"allowedFor");
        this.descriptorBasedSerializerRegistry = descriptorBasedSerializerRegistry;
        this.allowedFor = allowedFor;
        this.customSerializersCache = DefaultCacheProvider.INSTANCE.createCache();
        CachingCustomSerializerRegistry cachingCustomSerializerRegistry = this;
        cachingCustomSerializerRegistry.customSerializers = list = (List)new ArrayList();
    }

    public CachingCustomSerializerRegistry(@NotNull DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)descriptorBasedSerializerRegistry, (String)"descriptorBasedSerializerRegistry");
        this(descriptorBasedSerializerRegistry, SetsKt.emptySet());
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ List access$getCustomSerializers$p(CachingCustomSerializerRegistry $this) {
        return $this.customSerializers;
    }

    @NotNull
    public static final /* synthetic */ DescriptorBasedSerializerRegistry access$getDescriptorBasedSerializerRegistry$p(CachingCustomSerializerRegistry $this) {
        return $this.descriptorBasedSerializerRegistry;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J$\u0010\u0005\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerIdentifier;", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "actualTypeIdentifier", "declaredTypeIdentifier", "copy", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Lnet/corda/serialization/internal/model/TypeIdentifier;)Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerIdentifier;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "<init>", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Lnet/corda/serialization/internal/model/TypeIdentifier;)V", "serialization"})
    private static final class CustomSerializerIdentifier {
        @NotNull
        private final TypeIdentifier actualTypeIdentifier;
        @NotNull
        private final TypeIdentifier declaredTypeIdentifier;

        public CustomSerializerIdentifier(@NotNull TypeIdentifier actualTypeIdentifier, @NotNull TypeIdentifier declaredTypeIdentifier) {
            Intrinsics.checkParameterIsNotNull((Object)actualTypeIdentifier, (String)"actualTypeIdentifier");
            Intrinsics.checkParameterIsNotNull((Object)declaredTypeIdentifier, (String)"declaredTypeIdentifier");
            this.actualTypeIdentifier = actualTypeIdentifier;
            this.declaredTypeIdentifier = declaredTypeIdentifier;
        }

        @NotNull
        public final CustomSerializerIdentifier copy(@NotNull TypeIdentifier actualTypeIdentifier, @NotNull TypeIdentifier declaredTypeIdentifier) {
            Intrinsics.checkParameterIsNotNull((Object)actualTypeIdentifier, (String)"actualTypeIdentifier");
            Intrinsics.checkParameterIsNotNull((Object)declaredTypeIdentifier, (String)"declaredTypeIdentifier");
            return new CustomSerializerIdentifier(actualTypeIdentifier, declaredTypeIdentifier);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CustomSerializerIdentifier copy$default(CustomSerializerIdentifier customSerializerIdentifier, TypeIdentifier typeIdentifier, TypeIdentifier typeIdentifier2, int n, Object object) {
            if ((n & 1) != 0) {
                typeIdentifier = customSerializerIdentifier.actualTypeIdentifier;
            }
            if ((n & 2) != 0) {
                typeIdentifier2 = customSerializerIdentifier.declaredTypeIdentifier;
            }
            return customSerializerIdentifier.copy(typeIdentifier, typeIdentifier2);
        }

        @NotNull
        public String toString() {
            return "CustomSerializerIdentifier(actualTypeIdentifier=" + this.actualTypeIdentifier + ", declaredTypeIdentifier=" + this.declaredTypeIdentifier + ")";
        }

        public int hashCode() {
            TypeIdentifier typeIdentifier = this.actualTypeIdentifier;
            TypeIdentifier typeIdentifier2 = this.declaredTypeIdentifier;
            return (typeIdentifier != null ? typeIdentifier.hashCode() : 0) * 31 + (typeIdentifier2 != null ? typeIdentifier2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CustomSerializerIdentifier)) break block3;
                    CustomSerializerIdentifier customSerializerIdentifier = (CustomSerializerIdentifier)object;
                    if (!Intrinsics.areEqual((Object)this.actualTypeIdentifier, (Object)customSerializerIdentifier.actualTypeIdentifier) || !Intrinsics.areEqual((Object)this.declaredTypeIdentifier, (Object)customSerializerIdentifier.declaredTypeIdentifier)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult;", "", "()V", "serializerIfFound", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "getSerializerIfFound", "()Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "CustomSerializerFound", "None", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult$None;", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult$CustomSerializerFound;", "serialization"})
    private static abstract class CustomSerializerLookupResult {
        @Nullable
        public abstract AMQPSerializer<Object> getSerializerIfFound();

        private CustomSerializerLookupResult() {
        }

        public /* synthetic */ CustomSerializerLookupResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult$None;", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult;", "()V", "serializerIfFound", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "getSerializerIfFound", "()Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "serialization"})
        public static final class None
        extends CustomSerializerLookupResult {
            @Nullable
            private static final AMQPSerializer<Object> serializerIfFound;
            public static final None INSTANCE;

            @Override
            @Nullable
            public AMQPSerializer<Object> getSerializerIfFound() {
                return serializerIfFound;
            }

            private None() {
                super(null);
            }

            static {
                None none;
                INSTANCE = none = new None();
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J \u0010\u0005\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0016@\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult$CustomSerializerFound;", "Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "serializerIfFound", "copy", "(Lnet/corda/serialization/internal/amqp/AMQPSerializer;)Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$CustomSerializerLookupResult$CustomSerializerFound;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "getSerializerIfFound", "()Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "<init>", "(Lnet/corda/serialization/internal/amqp/AMQPSerializer;)V", "serialization"})
        public static final class CustomSerializerFound
        extends CustomSerializerLookupResult {
            @NotNull
            private final AMQPSerializer<Object> serializerIfFound;

            @Override
            @NotNull
            public AMQPSerializer<Object> getSerializerIfFound() {
                return this.serializerIfFound;
            }

            public CustomSerializerFound(@NotNull AMQPSerializer<? extends Object> serializerIfFound) {
                Intrinsics.checkParameterIsNotNull(serializerIfFound, (String)"serializerIfFound");
                super(null);
                this.serializerIfFound = serializerIfFound;
            }

            @NotNull
            public final CustomSerializerFound copy(@NotNull AMQPSerializer<? extends Object> serializerIfFound) {
                Intrinsics.checkParameterIsNotNull(serializerIfFound, (String)"serializerIfFound");
                return new CustomSerializerFound(serializerIfFound);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ CustomSerializerFound copy$default(CustomSerializerFound customSerializerFound, AMQPSerializer aMQPSerializer, int n, Object object) {
                if ((n & 1) != 0) {
                    aMQPSerializer = customSerializerFound.getSerializerIfFound();
                }
                return customSerializerFound.copy(aMQPSerializer);
            }

            @NotNull
            public String toString() {
                return "CustomSerializerFound(serializerIfFound=" + this.getSerializerIfFound() + ")";
            }

            public int hashCode() {
                AMQPSerializer<Object> aMQPSerializer = this.getSerializerIfFound();
                return aMQPSerializer != null ? aMQPSerializer.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CustomSerializerFound)) break block3;
                        CustomSerializerFound customSerializerFound = (CustomSerializerFound)object;
                        if (!Intrinsics.areEqual(this.getSerializerIfFound(), customSerializerFound.getSerializerIfFound())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/serialization/internal/amqp/CachingCustomSerializerRegistry$Companion;", "", "<init>", "()V", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

