/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.NotSerializableException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPExceptionsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.ObjectBuilder;
import net.corda.serialization.internal.amqp.PropertySerializer;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR&\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lnet/corda/serialization/internal/amqp/ComposableObjectReader;", "", "obj", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "schemas", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "input", "Lnet/corda/core/serialization/SerializationContext;", "context", "readObject", "(Ljava/lang/Object;Lnet/corda/serialization/internal/amqp/SerializationSchemas;Lnet/corda/serialization/internal/amqp/DeserializationInput;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "Lkotlin/Function0;", "Lnet/corda/serialization/internal/amqp/ObjectBuilder;", "objectBuilderProvider", "Lkotlin/jvm/functions/Function0;", "", "", "Lnet/corda/serialization/internal/model/PropertyName;", "Lnet/corda/serialization/internal/amqp/PropertySerializer;", "propertySerializers", "Ljava/util/Map;", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "typeIdentifier", "<init>", "(Lnet/corda/serialization/internal/model/TypeIdentifier;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "serialization"})
public final class ComposableObjectReader {
    @NotNull
    private final TypeIdentifier typeIdentifier;
    private final Map<String, PropertySerializer> propertySerializers;
    private final Function0<ObjectBuilder> objectBuilderProvider;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            if (!(obj instanceof List)) {
                throw (Throwable)new NotSerializableException("Body of described type is unexpected " + obj);
            }
            if (((List)obj).size() < this.propertySerializers.size()) {
                throw (Throwable)new NotSerializableException(((List)obj).size() + " objects to deserialize, but " + this.propertySerializers.size() + " properties in described type " + this.typeIdentifier.prettyPrint(false));
            }
            ObjectBuilder builder = (ObjectBuilder)this.objectBuilderProvider.invoke();
            builder.initialize();
            Sequence $receiver$iv = SequencesKt.map((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)obj)), (Sequence)CollectionsKt.asSequence((Iterable)this.propertySerializers.values())), (Function1)((Function1)new Function1<Pair<? extends Object, ? extends PropertySerializer>, Object>(this, obj, schemas, input, context){
                final /* synthetic */ ComposableObjectReader this$0;
                final /* synthetic */ Object $obj$inlined;
                final /* synthetic */ SerializationSchemas $schemas$inlined;
                final /* synthetic */ DeserializationInput $input$inlined;
                final /* synthetic */ SerializationContext $context$inlined;
                {
                    this.this$0 = composableObjectReader;
                    this.$obj$inlined = object;
                    this.$schemas$inlined = serializationSchemas;
                    this.$input$inlined = deserializationInput;
                    this.$context$inlined = serializationContext;
                    super(1);
                }

                @Nullable
                public final Object invoke(@NotNull Pair<? extends Object, ? extends PropertySerializer> $item_property) {
                    Intrinsics.checkParameterIsNotNull($item_property, (String)"<name for destructuring parameter 0>");
                    Object item = $item_property.component1();
                    PropertySerializer property = (PropertySerializer)$item_property.component2();
                    return property.readProperty(item, this.$schemas$inlined, this.$input$inlined, this.$context$inlined);
                }
            }));
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void propertyValue;
                int n = index$iv++;
                Object e = item$iv;
                int slot = n;
                builder.populate(slot, propertyValue);
            }
            return builder.build();
        }
        catch (Throwable th$iv) {
            Throwable throwable = th$iv;
            if (throwable instanceof AMQPNotSerializableException) {
                List<String> list = ((AMQPNotSerializableException)th$iv).getClassHierarchy();
                String string = this.typeIdentifier.prettyPrint(false);
                list.add(string);
            } else if (!(throwable instanceof ClassNotFoundException) && !(throwable instanceof NoClassDefFoundError)) {
                StringBuilder stringBuilder = new StringBuilder();
                Throwable throwable2 = th$iv;
                String string = this.typeIdentifier.prettyPrint(false);
                AMQPExceptionsKt.access$setMessage(throwable2, stringBuilder.append(string).append(" -> ").append(th$iv.getMessage()).toString());
            }
            throw th$iv;
        }
    }

    public ComposableObjectReader(@NotNull TypeIdentifier typeIdentifier, @NotNull Map<String, ? extends PropertySerializer> propertySerializers, @NotNull Function0<? extends ObjectBuilder> objectBuilderProvider) {
        Intrinsics.checkParameterIsNotNull((Object)typeIdentifier, (String)"typeIdentifier");
        Intrinsics.checkParameterIsNotNull(propertySerializers, (String)"propertySerializers");
        Intrinsics.checkParameterIsNotNull(objectBuilderProvider, (String)"objectBuilderProvider");
        this.typeIdentifier = typeIdentifier;
        this.propertySerializers = propertySerializers;
        this.objectBuilderProvider = objectBuilderProvider;
    }
}

