/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.EnumEvolutionSerializer;
import net.corda.serialization.internal.amqp.EvolutionObjectSerializer;
import net.corda.serialization.internal.amqp.EvolutionSerializationException;
import net.corda.serialization.internal.amqp.EvolutionSerializerFactory;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.model.BaseLocalTypes;
import net.corda.serialization.internal.model.EnumTransforms;
import net.corda.serialization.internal.model.EvolutionConstructorInformation;
import net.corda.serialization.internal.model.LocalConstructorInformation;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.RemotePropertyInformation;
import net.corda.serialization.internal.model.RemoteTypeInformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J0\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00190\tH\u0002J,\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020!0\tH\u0002J \u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J6\u0010)\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00120\tH\u0002J\u001c\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#*\u00020/2\u0006\u0010+\u001a\u000200H\u0002J\u001c\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u00101\u001a\u00020\u0007*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u00102\u001a\u000203*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J$\u00104\u001a\u000203*\u00020*2\u0016\u00105\u001a\u0012\u0012\b\u0012\u00060\u0019j\u0002`6\u0012\u0004\u0012\u00020\u00120\tH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0007*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultEvolutionSerializerFactory;", "Lnet/corda/serialization/internal/amqp/EvolutionSerializerFactory;", "localSerializerFactory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "classLoader", "Ljava/lang/ClassLoader;", "mustPreserveDataWhenEvolving", "", "primitiveTypes", "", "Ljava/lang/Class;", "baseTypes", "Lnet/corda/serialization/internal/model/BaseLocalTypes;", "(Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;Ljava/lang/ClassLoader;ZLjava/util/Map;Lnet/corda/serialization/internal/model/BaseLocalTypes;)V", "primitiveBoxedTypes", "getPrimitiveTypes", "()Ljava/util/Map;", "mustBeProvided", "Lnet/corda/serialization/internal/model/LocalPropertyInformation;", "getMustBeProvided", "(Lnet/corda/serialization/internal/model/LocalPropertyInformation;)Z", "boxed", "primitiveType", "constantsAreReordered", "localOrdinals", "", "", "convertedOrdinals", "findEvolverConstructor", "Lnet/corda/serialization/internal/model/EvolutionConstructorInformation;", "constructors", "", "properties", "Lnet/corda/serialization/internal/model/RemotePropertyInformation;", "getEvolutionSerializer", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "remote", "Lnet/corda/serialization/internal/model/RemoteTypeInformation;", "local", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "buildComposableEvolutionSerializer", "Lnet/corda/serialization/internal/model/RemoteTypeInformation$Composable;", "localTypeInformation", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Composable;", "constructor", "Lnet/corda/serialization/internal/model/LocalConstructorInformation;", "Lnet/corda/serialization/internal/model/RemoteTypeInformation$AnEnum;", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AnEnum;", "propertyNamesMatch", "validateCompatibility", "", "validateEvolvability", "localProperties", "Lnet/corda/serialization/internal/model/PropertyName;", "serialization"})
public final class DefaultEvolutionSerializerFactory
implements EvolutionSerializerFactory {
    private final Map<Class<?>, Class<?>> primitiveBoxedTypes;
    private final LocalSerializerFactory localSerializerFactory;
    private final ClassLoader classLoader;
    private final boolean mustPreserveDataWhenEvolving;
    @NotNull
    private final Map<Class<?>, Class<?>> primitiveTypes;
    private final BaseLocalTypes baseTypes;

    @Override
    @Nullable
    public AMQPSerializer<Object> getEvolutionSerializer(@NotNull RemoteTypeInformation remote, @NotNull LocalTypeInformation local) {
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
        RemoteTypeInformation remoteTypeInformation = remote;
        return remoteTypeInformation instanceof RemoteTypeInformation.Composable ? (local instanceof LocalTypeInformation.Composable ? this.getEvolutionSerializer((RemoteTypeInformation.Composable)remote, (LocalTypeInformation.Composable)local) : null) : (remoteTypeInformation instanceof RemoteTypeInformation.AnEnum ? (local instanceof LocalTypeInformation.AnEnum ? this.getEvolutionSerializer((RemoteTypeInformation.AnEnum)remote, (LocalTypeInformation.AnEnum)local) : null) : null);
    }

    private final AMQPSerializer<Object> getEvolutionSerializer(@NotNull RemoteTypeInformation.Composable $receiver, LocalTypeInformation.Composable localTypeInformation) {
        Map<String, LocalPropertyInformation> map;
        Object constructorForEvolution;
        if (this.propertyNamesMatch($receiver, localTypeInformation)) {
            this.validateCompatibility($receiver, localTypeInformation);
            return null;
        }
        EvolutionConstructorInformation bestMatchEvolutionConstructor = this.findEvolverConstructor(localTypeInformation.getEvolutionConstructors(), $receiver.getProperties());
        Object object = bestMatchEvolutionConstructor;
        if (object == null || (object = ((EvolutionConstructorInformation)object).getConstructor()) == null) {
            object = constructorForEvolution = localTypeInformation.getConstructor();
        }
        if ((map = bestMatchEvolutionConstructor) == null || (map = ((EvolutionConstructorInformation)((Object)map)).getProperties()) == null) {
            map = localTypeInformation.getProperties();
        }
        Map<String, LocalPropertyInformation> evolverProperties = map;
        this.validateEvolvability($receiver, evolverProperties);
        return this.buildComposableEvolutionSerializer($receiver, localTypeInformation, (LocalConstructorInformation)constructorForEvolution, evolverProperties);
    }

    private final boolean propertyNamesMatch(@NotNull RemoteTypeInformation.Composable $receiver, LocalTypeInformation.Composable localTypeInformation) {
        return Intrinsics.areEqual($receiver.getProperties().keySet(), localTypeInformation.getProperties().keySet());
    }

    /*
     * WARNING - void declaration
     */
    private final void validateCompatibility(@NotNull RemoteTypeInformation.Composable $receiver, LocalTypeInformation.Composable localTypeInformation) {
        Sequence $receiver$iv = SequencesKt.zip((Sequence)MapsKt.asSequence($receiver.getProperties()), (Sequence)CollectionsKt.asSequence((Iterable)localTypeInformation.getProperties().values()));
        for (Object element$iv : $receiver$iv) {
            void name;
            Class<?> remoteClass;
            Map.Entry entry;
            Pair $remote_localProperty = (Pair)element$iv;
            Map.Entry remote = (Map.Entry)$remote_localProperty.component1();
            LocalPropertyInformation localProperty = (LocalPropertyInformation)$remote_localProperty.component2();
            Map.Entry entry2 = entry = remote;
            String string = (String)entry2.getKey();
            entry2 = entry;
            RemotePropertyInformation remoteProperty = (RemotePropertyInformation)entry2.getValue();
            Class<?> localClass = SerializationHelperKt.asClass(localProperty.getType().getObservedType());
            if (localClass.isAssignableFrom(remoteClass = SerializationHelperKt.asClass(remoteProperty.getType().getTypeIdentifier().getLocalType(this.classLoader))) || !(Intrinsics.areEqual(remoteClass, this.getPrimitiveTypes().get(localClass)) ^ true)) continue;
            throw (Throwable)new EvolutionSerializationException($receiver, "Local type " + localClass + " of property " + (String)name + " is not assignable from remote type " + remoteClass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final EvolutionConstructorInformation findEvolverConstructor(List<EvolutionConstructorInformation> constructors, Map<String, RemotePropertyInformation> properties2) {
        Object v1;
        block6: {
            Map.Entry entry;
            Object object;
            Object object2;
            void $receiver$iv$iv;
            Object $receiver$iv = properties2;
            Map<String, RemotePropertyInformation> map = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void $$_$_info;
                void it$iv$iv;
                object2 = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map2 = object;
                entry = $$_$_info;
                RemotePropertyInformation info = (RemotePropertyInformation)entry.getValue();
                Class<?> clazz = SerializationHelperKt.asClass(info.getType().getTypeIdentifier().getLocalType(this.classLoader));
                map2.put(k2, clazz);
            }
            Map propertyTypes = destination$iv$iv;
            $receiver$iv = constructors;
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean bl;
                Object element$iv;
                block5: {
                    element$iv = iterator$iv.previous();
                    EvolutionConstructorInformation $$_$_evolverProperties = (EvolutionConstructorInformation)element$iv;
                    Map<String, LocalPropertyInformation> evolverProperties = $$_$_evolverProperties.component2();
                    Map<String, LocalPropertyInformation> $receiver$iv2 = evolverProperties;
                    if ($receiver$iv2.isEmpty()) {
                        bl = true;
                    } else {
                        object2 = $receiver$iv2;
                        object = object2.entrySet().iterator();
                        while (object.hasNext()) {
                            Class<?> evolverPropertyType;
                            Map.Entry element$iv2;
                            Map.Entry $name_evolverProperty;
                            entry = $name_evolverProperty = (element$iv2 = (Map.Entry)object.next());
                            String name = (String)entry.getKey();
                            entry = $name_evolverProperty;
                            LocalPropertyInformation evolverProperty = (LocalPropertyInformation)entry.getValue();
                            Class propertyType = (Class)propertyTypes.get(name);
                            if (propertyType == null ? !evolverProperty.isMandatory() : (evolverPropertyType = SerializationHelperKt.asClass(evolverProperty.getType().getObservedType())).isAssignableFrom(propertyType) || propertyType.isPrimitive() && evolverPropertyType.isAssignableFrom(this.boxed(propertyType)) || evolverPropertyType.isPrimitive() && this.boxed(evolverPropertyType).isAssignableFrom(propertyType)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        return v1;
    }

    private final Class<?> boxed(Class<?> primitiveType) {
        Class<?> clazz = this.primitiveBoxedTypes.get(primitiveType);
        if (clazz == null) {
            throw (Throwable)new IllegalStateException("Unknown primitive type '" + primitiveType + '\'');
        }
        return clazz;
    }

    private final void validateEvolvability(@NotNull RemoteTypeInformation.Composable $receiver, Map<String, ? extends LocalPropertyInformation> localProperties) {
        Set<String> remotePropertyNames = $receiver.getProperties().keySet();
        Set<String> localPropertyNames = localProperties.keySet();
        Set newProperties = SetsKt.minus(localPropertyNames, (Iterable)remotePropertyNames);
        Iterable $receiver$iv = newProperties;
        for (Object element$iv : $receiver$iv) {
            String propertyName = (String)element$iv;
            LocalPropertyInformation localPropertyInformation = localProperties.get(propertyName);
            if (localPropertyInformation == null) {
                Intrinsics.throwNpe();
            }
            if (!this.getMustBeProvided(localPropertyInformation)) continue;
            throw (Throwable)new EvolutionSerializationException($receiver, "Mandatory property " + propertyName + " of local type is not present in remote type. " + "This implies the type has not evolved in a backwards compatible way. " + "Consider making " + propertyName + " nullable in the newer version of this type.");
        }
    }

    private final boolean getMustBeProvided(@NotNull LocalPropertyInformation $receiver) {
        LocalPropertyInformation localPropertyInformation = $receiver;
        return localPropertyInformation instanceof LocalPropertyInformation.ConstructorPairedProperty ? $receiver.isMandatory() : (localPropertyInformation instanceof LocalPropertyInformation.PrivateConstructorPairedProperty ? $receiver.isMandatory() : false);
    }

    /*
     * WARNING - void declaration
     */
    private final AMQPSerializer<Object> getEvolutionSerializer(@NotNull RemoteTypeInformation.AnEnum $receiver, LocalTypeInformation.AnEnum localTypeInformation) {
        void $receiver$iv$iv;
        Object item$iv$iv3;
        void $receiver$iv$iv2;
        Pair pair;
        Collection collection;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        if (Intrinsics.areEqual($receiver.getMembers(), localTypeInformation.getMembers())) {
            return null;
        }
        EnumTransforms remoteTransforms = $receiver.getTransforms();
        EnumTransforms localTransforms = localTypeInformation.getTransforms();
        EnumTransforms transforms = remoteTransforms.getSize() > localTransforms.getSize() ? remoteTransforms : localTransforms;
        Iterable iterable = $receiver$iv = (Iterable)localTypeInformation.getMembers();
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $receiver$iv$iv3) {
            void ord2;
            void member;
            int n = index$iv$iv++;
            String string = (String)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            pair = TuplesKt.to((Object)member, (Object)((int)ord2));
            collection.add(pair);
        }
        Map localOrdinals = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $receiver$iv2 = $receiver.getMembers();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        int index$iv$iv2 = 0;
        for (Object item$iv$iv3 : $receiver$iv$iv2) {
            void ord;
            void member;
            int n = index$iv$iv2++;
            String ord2 = (String)item$iv$iv3;
            int $i$a$1$mapIndexed = n;
            collection = destination$iv$iv2;
            pair = TuplesKt.to((Object)member, (Object)((int)ord));
            collection.add(pair);
        }
        Map remoteOrdinals = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        Map rules = MapsKt.plus(transforms.getDefaults(), transforms.getRenames());
        Function1<String, String> findLocal$ = new Function1<String, String>($receiver, localOrdinals, localTypeInformation, rules){
            final /* synthetic */ RemoteTypeInformation.AnEnum receiver$0;
            final /* synthetic */ Map $localOrdinals;
            final /* synthetic */ LocalTypeInformation.AnEnum $localTypeInformation;
            final /* synthetic */ Map $rules;

            @NotNull
            public final String invoke(@NotNull String remote) {
                String string;
                while (true) {
                    Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
                    if (this.$localOrdinals.keySet().contains(remote)) {
                        string = remote;
                        break;
                    }
                    string = this.$localTypeInformation.getFallbacks().get(remote);
                    if (string != null) break;
                    if ((String)this.$rules.get(remote) != null) continue;
                    throw (Throwable)new EvolutionSerializationException(this.receiver$0, "Cannot resolve local enum member " + remote + " to a member of " + this.$localOrdinals.keySet() + " using rules " + this.$rules);
                }
                return string;
            }
            {
                this.receiver$0 = anEnum;
                this.$localOrdinals = map;
                this.$localTypeInformation = anEnum2;
                this.$rules = map2;
                super(1);
            }
        };
        Iterable $receiver$iv3 = $receiver.getMembers();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
        item$iv$iv3 = $receiver$iv3;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv3;
            String it = (String)element$iv$iv;
            Pair pair2 = TuplesKt.to((Object)it, (Object)findLocal$.invoke(it));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map conversions = destination$iv$iv3;
        Map convertedOrdinals2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)remoteOrdinals), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Integer>, Pair<? extends Integer, ? extends String>>(conversions){
            final /* synthetic */ Map $conversions;

            @NotNull
            public final Pair<Integer, String> invoke(@NotNull Map.Entry<String, Integer> $member_ord) {
                Intrinsics.checkParameterIsNotNull($member_ord, (String)"<name for destructuring parameter 0>");
                Map.Entry<String, Integer> entry = $member_ord;
                String member = entry.getKey();
                entry = $member_ord;
                int ord = ((Number)entry.getValue()).intValue();
                Integer n = ord;
                V v = this.$conversions.get(member);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return TuplesKt.to((Object)n, v);
            }
            {
                this.$conversions = map;
                super(1);
            }
        })));
        if (this.constantsAreReordered(localOrdinals, convertedOrdinals2)) {
            throw (Throwable)new EvolutionSerializationException($receiver, "Constants have been reordered, additions must be appended to the end");
        }
        return new EnumEvolutionSerializer(localTypeInformation.getObservedType(), this.localSerializerFactory, this.baseTypes, conversions, localOrdinals);
    }

    private final boolean constantsAreReordered(Map<String, Integer> localOrdinals, Map<Integer, String> convertedOrdinals2) {
        boolean bl;
        block8: {
            if (localOrdinals.size() <= convertedOrdinals2.size()) {
                Map<String, Integer> $receiver$iv = localOrdinals;
                if ($receiver$iv.isEmpty()) {
                    bl = false;
                } else {
                    Map<String, Integer> map = $receiver$iv;
                    Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Integer> element$iv;
                        Map.Entry<String, Integer> $name_ordinal;
                        Map.Entry<String, Integer> entry = $name_ordinal = (element$iv = iterator.next());
                        String name = entry.getKey();
                        entry = $name_ordinal;
                        int ordinal = ((Number)entry.getValue()).intValue();
                        if (!(Intrinsics.areEqual((Object)convertedOrdinals2.get(ordinal), (Object)name) ^ true)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                Map<Integer, String> $receiver$iv = convertedOrdinals2;
                if ($receiver$iv.isEmpty()) {
                    bl = false;
                } else {
                    Map<Integer, String> map = $receiver$iv;
                    Iterator<Map.Entry<Integer, String>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Integer, String> element$iv;
                        Map.Entry<Integer, String> $ordinal_name;
                        Map.Entry<Integer, String> entry = $ordinal_name = (element$iv = iterator.next());
                        int ordinal = ((Number)entry.getKey()).intValue();
                        entry = $ordinal_name;
                        String name = entry.getValue();
                        Integer n = localOrdinals.get(name);
                        if (!(n == null || n != ordinal)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final AMQPSerializer<Object> buildComposableEvolutionSerializer(@NotNull RemoteTypeInformation.Composable $receiver, LocalTypeInformation.Composable localTypeInformation, LocalConstructorInformation constructor, Map<String, ? extends LocalPropertyInformation> properties2) {
        return EvolutionObjectSerializer.Companion.make(localTypeInformation, $receiver, constructor, properties2, this.classLoader, this.mustPreserveDataWhenEvolving);
    }

    @NotNull
    public Map<Class<?>, Class<?>> getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultEvolutionSerializerFactory(@NotNull LocalSerializerFactory localSerializerFactory2, @NotNull ClassLoader classLoader, boolean mustPreserveDataWhenEvolving, @NotNull Map<Class<?>, ? extends Class<?>> primitiveTypes, @NotNull BaseLocalTypes baseTypes) {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)localSerializerFactory2, (String)"localSerializerFactory");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Intrinsics.checkParameterIsNotNull(primitiveTypes, (String)"primitiveTypes");
        Intrinsics.checkParameterIsNotNull((Object)baseTypes, (String)"baseTypes");
        this.localSerializerFactory = localSerializerFactory2;
        this.classLoader = classLoader;
        this.mustPreserveDataWhenEvolving = mustPreserveDataWhenEvolving;
        this.primitiveTypes = primitiveTypes;
        this.baseTypes = baseTypes;
        Iterable iterable = this.getPrimitiveTypes().entrySet();
        DefaultEvolutionSerializerFactory defaultEvolutionSerializerFactory = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var8_9 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object receiver;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            map = destination$iv$iv;
            Object v = ((Map.Entry)receiver).getValue();
            receiver = element$iv$iv;
            Object k = ((Map.Entry)receiver).getKey();
            map.put(v, k);
        }
        defaultEvolutionSerializerFactory.primitiveBoxedTypes = map = destination$iv$iv;
    }
}

