/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.internal.MissingSerializerException;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.serialization.internal.amqp.AMQPRemoteTypeModel;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.DefaultRemoteSerializerFactory;
import net.corda.serialization.internal.amqp.DescriptorBasedSerializerRegistry;
import net.corda.serialization.internal.amqp.EvolutionSerializerFactory;
import net.corda.serialization.internal.amqp.LocalSerializerFactory;
import net.corda.serialization.internal.amqp.RemoteAndLocalTypeInformation;
import net.corda.serialization.internal.amqp.RemoteSerializerFactory;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.LocalTypeModel;
import net.corda.serialization.internal.model.RemoteTypeInformation;
import net.corda.serialization.internal.model.TypeIdentifier;
import net.corda.serialization.internal.model.TypeLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020 0\u001f2\u0016\u0010!\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\"\u001a\u00020#*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010$\u001a\u00020#*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010%\u001a\u00020#*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultRemoteSerializerFactory;", "Lnet/corda/serialization/internal/amqp/RemoteSerializerFactory;", "evolutionSerializerFactory", "Lnet/corda/serialization/internal/amqp/EvolutionSerializerFactory;", "descriptorBasedSerializerRegistry", "Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;", "remoteTypeModel", "Lnet/corda/serialization/internal/amqp/AMQPRemoteTypeModel;", "localTypeModel", "Lnet/corda/serialization/internal/model/LocalTypeModel;", "typeLoader", "Lnet/corda/serialization/internal/model/TypeLoader;", "localSerializerFactory", "Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;", "(Lnet/corda/serialization/internal/amqp/EvolutionSerializerFactory;Lnet/corda/serialization/internal/amqp/DescriptorBasedSerializerRegistry;Lnet/corda/serialization/internal/amqp/AMQPRemoteTypeModel;Lnet/corda/serialization/internal/model/LocalTypeModel;Lnet/corda/serialization/internal/model/TypeLoader;Lnet/corda/serialization/internal/amqp/LocalSerializerFactory;)V", "get", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "typeDescriptor", "", "Lnet/corda/serialization/internal/model/TypeDescriptor;", "schema", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "context", "Lnet/corda/core/serialization/SerializationContext;", "getUncached", "remoteTypeInformation", "Lnet/corda/serialization/internal/model/RemoteTypeInformation;", "localTypeInformation", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "reflect", "", "Lnet/corda/serialization/internal/amqp/RemoteAndLocalTypeInformation;", "remoteInformation", "isCompatibleWith", "", "isDeserialisableWithoutEvolutionTo", "isEvolvableTo", "Companion", "serialization"})
public final class DefaultRemoteSerializerFactory
implements RemoteSerializerFactory {
    private final EvolutionSerializerFactory evolutionSerializerFactory;
    private final DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry;
    private final AMQPRemoteTypeModel remoteTypeModel;
    private final LocalTypeModel localTypeModel;
    private final TypeLoader typeLoader;
    private final LocalSerializerFactory localSerializerFactory;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public AMQPSerializer<Object> get(@NotNull String typeDescriptor2, @NotNull SerializationSchemas schema, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)typeDescriptor2, (String)"typeDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.descriptorBasedSerializerRegistry.getOrBuild(typeDescriptor2, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<AMQPSerializer<? extends Object>>(this, typeDescriptor2, schema, context){
            final /* synthetic */ DefaultRemoteSerializerFactory this$0;
            final /* synthetic */ String $typeDescriptor;
            final /* synthetic */ SerializationSchemas $schema;
            final /* synthetic */ SerializationContext $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AMQPSerializer<Object> invoke() {
                void $receiver$iv$iv;
                Map reflected;
                Map $receiver$iv;
                String string;
                Object object;
                Logger $receiver$iv2 = DefaultRemoteSerializerFactory.access$getLogger$cp();
                if ($receiver$iv2.isTraceEnabled()) {
                    object = $receiver$iv2;
                    string = "get Serializer descriptor=" + this.$typeDescriptor;
                    object.trace(string);
                }
                Map<String, RemoteTypeInformation> remoteTypeInformationMap = DefaultRemoteSerializerFactory.access$getRemoteTypeModel$p(this.this$0).interpret(this.$schema);
                Map map = $receiver$iv = (reflected = DefaultRemoteSerializerFactory.access$reflect(this.this$0, remoteTypeInformationMap, this.$context));
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$receiver$iv.size()));
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    void $descriptor_remoteLocalPair;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    string = k;
                    object = map2;
                    void var14_15 = $descriptor_remoteLocalPair;
                    String descriptor = (String)var14_15.getKey();
                    var14_15 = $descriptor_remoteLocalPair;
                    RemoteAndLocalTypeInformation remoteLocalPair = (RemoteAndLocalTypeInformation)var14_15.getValue();
                    AMQPSerializer<Object> aMQPSerializer = DefaultRemoteSerializerFactory.access$getDescriptorBasedSerializerRegistry$p(this.this$0).getOrBuild(descriptor, (Function0<? extends AMQPSerializer<? extends Object>>)((Function0)new Function0<AMQPSerializer<? extends Object>>(remoteLocalPair, this){
                        final /* synthetic */ RemoteAndLocalTypeInformation $remoteLocalPair;
                        final /* synthetic */ get.1 this$0;
                        {
                            this.$remoteLocalPair = remoteAndLocalTypeInformation;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        @NotNull
                        public final AMQPSerializer<Object> invoke() {
                            return DefaultRemoteSerializerFactory.access$getUncached(this.this$0.this$0, this.$remoteLocalPair.getRemoteTypeInformation(), this.$remoteLocalPair.getLocalTypeInformation(), this.this$0.$context);
                        }
                    }));
                    object.put(string, aMQPSerializer);
                }
                Map serializers = destination$iv$iv;
                AMQPSerializer aMQPSerializer = (AMQPSerializer)serializers.get(this.$typeDescriptor);
                if (aMQPSerializer == null) {
                    throw (Throwable)new MissingSerializerException("Could not find type matching descriptor " + this.$typeDescriptor + '.', this.$typeDescriptor);
                }
                return aMQPSerializer;
            }
            {
                this.this$0 = defaultRemoteSerializerFactory;
                this.$typeDescriptor = string;
                this.$schema = serializationSchemas;
                this.$context = serializationContext;
                super(0);
            }
        }));
    }

    private final AMQPSerializer<Object> getUncached(RemoteTypeInformation remoteTypeInformation, LocalTypeInformation localTypeInformation, SerializationContext context) {
        AMQPSerializer<Object> aMQPSerializer;
        String remoteDescriptor = remoteTypeInformation.getTypeDescriptor();
        AMQPSerializer<Object> localSerializer = this.localSerializerFactory.get(localTypeInformation);
        String localDescriptor = localSerializer.getTypeDescriptor().toString();
        if (Intrinsics.areEqual((Object)localDescriptor, (Object)remoteDescriptor)) {
            aMQPSerializer = localSerializer;
        } else if (this.isDeserialisableWithoutEvolutionTo(remoteTypeInformation, localTypeInformation)) {
            aMQPSerializer = localSerializer;
        } else if (this.isEvolvableTo(remoteTypeInformation, localTypeInformation)) {
            aMQPSerializer = this.evolutionSerializerFactory.getEvolutionSerializer(remoteTypeInformation, localTypeInformation);
            if (aMQPSerializer == null) {
                aMQPSerializer = localSerializer;
            }
        } else if (this.isCompatibleWith(remoteTypeInformation, localTypeInformation, context)) {
            aMQPSerializer = localSerializer;
        } else {
            logger.warn("\nMismatch between type descriptors, but remote type is not evolvable to local type.\n\nRemote type (descriptor: " + remoteDescriptor + ")\n" + remoteTypeInformation.prettyPrint(false) + "\n\nLocal type (descriptor " + localDescriptor + "):\n" + localTypeInformation.prettyPrint(false) + "\n        ");
            aMQPSerializer = localSerializer;
        }
        return aMQPSerializer;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, RemoteAndLocalTypeInformation> reflect(Map<String, ? extends RemoteTypeInformation> remoteInformation, SerializationContext context) {
        Object object;
        void var14_13;
        Map.Entry $$_$_type;
        Map map;
        Object k;
        Object k2;
        Map.Entry it$iv$iv;
        Map map2;
        Map<Object, Object> $receiver$iv$iv;
        Map<Object, Object> $receiver$iv = this.typeLoader.load(remoteInformation.values(), context);
        Map<TypeIdentifier, Type> map3 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            k2 = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = k2;
            map = map2;
            var14_13 = $$_$_type;
            Type type = (Type)var14_13.getValue();
            object = this.localTypeModel.inspect(type);
            map.put(k, object);
        }
        Map localInformationByIdentifier = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = remoteInformation;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $$_$_remoteInformation;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            k2 = it$iv$iv.getKey();
            $$_$_type = (Map.Entry)element$iv$iv$iv;
            k = k2;
            map = map2;
            var14_13 = $$_$_remoteInformation;
            RemoteTypeInformation remoteInformation2 = (RemoteTypeInformation)var14_13.getValue();
            object = new RemoteAndLocalTypeInformation(remoteInformation2, (LocalTypeInformation)MapsKt.getValue((Map)localInformationByIdentifier, (Object)remoteInformation2.getTypeIdentifier()));
            map.put(k, object);
        }
        return destination$iv$iv;
    }

    private final boolean isEvolvableTo(@NotNull RemoteTypeInformation $receiver, LocalTypeInformation localTypeInformation) {
        RemoteTypeInformation remoteTypeInformation = $receiver;
        return remoteTypeInformation instanceof RemoteTypeInformation.Composable ? localTypeInformation instanceof LocalTypeInformation.Composable : (remoteTypeInformation instanceof RemoteTypeInformation.AnEnum ? localTypeInformation instanceof LocalTypeInformation.AnEnum : false);
    }

    private final boolean isDeserialisableWithoutEvolutionTo(@NotNull RemoteTypeInformation $receiver, LocalTypeInformation localTypeInformation) {
        return $receiver instanceof RemoteTypeInformation.Parameterised && (localTypeInformation instanceof LocalTypeInformation.ACollection || localTypeInformation instanceof LocalTypeInformation.AMap);
    }

    private final boolean isCompatibleWith(@NotNull RemoteTypeInformation $receiver, LocalTypeInformation localTypeInformation, SerializationContext context) {
        List<RemoteTypeInformation> list = Collections.singletonList($receiver);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"singletonList(this)");
        Map<TypeIdentifier, Type> localTypes = this.typeLoader.load((Collection<? extends RemoteTypeInformation>)list, context);
        return localTypes.size() == 1 && Intrinsics.areEqual((Object)localTypeInformation.getObservedType(), (Object)((Type)CollectionsKt.first((Iterable)localTypes.values())));
    }

    public DefaultRemoteSerializerFactory(@NotNull EvolutionSerializerFactory evolutionSerializerFactory, @NotNull DescriptorBasedSerializerRegistry descriptorBasedSerializerRegistry, @NotNull AMQPRemoteTypeModel remoteTypeModel, @NotNull LocalTypeModel localTypeModel, @NotNull TypeLoader typeLoader, @NotNull LocalSerializerFactory localSerializerFactory2) {
        Intrinsics.checkParameterIsNotNull((Object)evolutionSerializerFactory, (String)"evolutionSerializerFactory");
        Intrinsics.checkParameterIsNotNull((Object)descriptorBasedSerializerRegistry, (String)"descriptorBasedSerializerRegistry");
        Intrinsics.checkParameterIsNotNull((Object)remoteTypeModel, (String)"remoteTypeModel");
        Intrinsics.checkParameterIsNotNull((Object)localTypeModel, (String)"localTypeModel");
        Intrinsics.checkParameterIsNotNull((Object)typeLoader, (String)"typeLoader");
        Intrinsics.checkParameterIsNotNull((Object)localSerializerFactory2, (String)"localSerializerFactory");
        this.evolutionSerializerFactory = evolutionSerializerFactory;
        this.descriptorBasedSerializerRegistry = descriptorBasedSerializerRegistry;
        this.remoteTypeModel = remoteTypeModel;
        this.localTypeModel = localTypeModel;
        this.typeLoader = typeLoader;
        this.localSerializerFactory = localSerializerFactory2;
    }

    static {
        Companion = new Companion(null);
        logger = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @NotNull
    public static final /* synthetic */ AMQPRemoteTypeModel access$getRemoteTypeModel$p(DefaultRemoteSerializerFactory $this) {
        return $this.remoteTypeModel;
    }

    @NotNull
    public static final /* synthetic */ Map access$reflect(DefaultRemoteSerializerFactory $this, @NotNull Map remoteInformation, @NotNull SerializationContext context) {
        return $this.reflect(remoteInformation, context);
    }

    @NotNull
    public static final /* synthetic */ DescriptorBasedSerializerRegistry access$getDescriptorBasedSerializerRegistry$p(DefaultRemoteSerializerFactory $this) {
        return $this.descriptorBasedSerializerRegistry;
    }

    @NotNull
    public static final /* synthetic */ AMQPSerializer access$getUncached(DefaultRemoteSerializerFactory $this, @NotNull RemoteTypeInformation remoteTypeInformation, @NotNull LocalTypeInformation localTypeInformation, @NotNull SerializationContext context) {
        return $this.getUncached(remoteTypeInformation, localTypeInformation, context);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/amqp/DefaultRemoteSerializerFactory$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

