/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPExceptionsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.PropertyReader;
import net.corda.serialization.internal.amqp.PropertyWriteStrategy;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/corda/serialization/internal/amqp/DescribedTypeWriteStrategy;", "Lnet/corda/serialization/internal/amqp/PropertyWriteStrategy;", "name", "", "propertyInformation", "Lnet/corda/serialization/internal/model/LocalPropertyInformation;", "reader", "Lnet/corda/serialization/internal/amqp/PropertyReader;", "serializerProvider", "Lkotlin/Function0;", "Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "", "(Ljava/lang/String;Lnet/corda/serialization/internal/model/LocalPropertyInformation;Lnet/corda/serialization/internal/amqp/PropertyReader;Lkotlin/jvm/functions/Function0;)V", "nameForDebug", "getNameForDebug", "()Ljava/lang/String;", "serializer", "getSerializer", "()Lnet/corda/serialization/internal/amqp/AMQPSerializer;", "serializer$delegate", "Lkotlin/Lazy;", "writeClassInfo", "", "output", "Lnet/corda/serialization/internal/amqp/SerializationOutput;", "writeProperty", "obj", "data", "Lorg/apache/qpid/proton/codec/Data;", "context", "Lnet/corda/core/serialization/SerializationContext;", "debugIndent", "", "serialization"})
public final class DescribedTypeWriteStrategy
implements PropertyWriteStrategy {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy serializer$delegate;
    private final String name;
    private final LocalPropertyInformation propertyInformation;
    private final PropertyReader reader;
    private final Function0<AMQPSerializer<Object>> serializerProvider;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DescribedTypeWriteStrategy.class), "serializer", "getSerializer()Lnet/corda/serialization/internal/amqp/AMQPSerializer;"))};
    }

    private final AMQPSerializer<Object> getSerializer() {
        Lazy lazy = this.serializer$delegate;
        return (AMQPSerializer)lazy.getValue();
    }

    private final String getNameForDebug() {
        return this.name + '(' + this.propertyInformation.getType().getTypeIdentifier().prettyPrint(false) + ')';
    }

    @Override
    public void writeClassInfo(@NotNull SerializationOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (!(this.propertyInformation.getType() instanceof LocalTypeInformation.Top)) {
            this.getSerializer().writeClassInfo(output);
        }
    }

    @Override
    public void writeProperty(@Nullable Object obj, @NotNull Data data, @NotNull SerializationOutput output, @NotNull SerializationContext context, int debugIndent) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            Object propertyValue = this.reader.read(obj);
            output.writeObjectOrNull$serialization(propertyValue, data, this.propertyInformation.getType().getObservedType(), context, debugIndent);
        }
        catch (Throwable th$iv) {
            Throwable throwable = th$iv;
            if (throwable instanceof AMQPNotSerializableException) {
                List<String> list = ((AMQPNotSerializableException)th$iv).getClassHierarchy();
                String string = this.getNameForDebug();
                list.add(string);
            } else if (!(throwable instanceof ClassNotFoundException) && !(throwable instanceof NoClassDefFoundError)) {
                StringBuilder stringBuilder = new StringBuilder();
                Throwable throwable2 = th$iv;
                String string = this.getNameForDebug();
                AMQPExceptionsKt.access$setMessage(throwable2, stringBuilder.append(string).append(" -> ").append(th$iv.getMessage()).toString());
            }
            throw th$iv;
        }
    }

    public DescribedTypeWriteStrategy(@NotNull String name, @NotNull LocalPropertyInformation propertyInformation, @NotNull PropertyReader reader, @NotNull Function0<? extends AMQPSerializer<? extends Object>> serializerProvider) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)propertyInformation, (String)"propertyInformation");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(serializerProvider, (String)"serializerProvider");
        this.name = name;
        this.propertyInformation = propertyInformation;
        this.reader = reader;
        this.serializerProvider = serializerProvider;
        this.serializer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AMQPSerializer<? extends Object>>(this){
            final /* synthetic */ DescribedTypeWriteStrategy this$0;

            @NotNull
            public final AMQPSerializer<Object> invoke() {
                return (AMQPSerializer)DescribedTypeWriteStrategy.access$getSerializerProvider$p(this.this$0).invoke();
            }
            {
                this.this$0 = describedTypeWriteStrategy;
                super(0);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ Function0 access$getSerializerProvider$p(DescribedTypeWriteStrategy $this) {
        return $this.serializerProvider;
    }
}

