/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.io.InputStream;
import java.io.NotSerializableException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.core.serialization.EncodingWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationEncoding;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.serialization.internal.ByteBufferInputStream;
import net.corda.serialization.internal.CordaSerializationEncoding;
import net.corda.serialization.internal.NullEncodingWhitelist;
import net.corda.serialization.internal.SectionId;
import net.corda.serialization.internal.amqp.AMQPNoTypeNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.AMQPSerializer;
import net.corda.serialization.internal.amqp.AMQPStreams;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.DeserializationInput$Companion$WhenMappings;
import net.corda.serialization.internal.amqp.Envelope;
import net.corda.serialization.internal.amqp.IdentityKey;
import net.corda.serialization.internal.amqp.ObjectAndEnvelope;
import net.corda.serialization.internal.amqp.ReferencedObject;
import net.corda.serialization.internal.amqp.SchemaKt;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.amqp.SerializerFactory;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0002\u00a2\u0006\u0002\u0010\rJ0\u0010\u000e\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\b\u00a2\u0006\u0002\u0010\u0014J3\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00172\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J:\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001a\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00172\u0006\u0010\u0012\u001a\u00020\u0013J5\u0010\u001b\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010'\u001a\u0004\u0018\u00010\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010)\u001a\u00020**\u00020&2\u0006\u0010+\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializationInput;", "", "serializerFactory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "logger", "Lorg/slf4j/Logger;", "objectHistory", "", "des", "R", "generator", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "deserialize", "T", "bytes", "Lnet/corda/core/serialization/SerializedBytes;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/serialization/SerializedBytes;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "Lnet/corda/core/utilities/ByteSequence;", "clazz", "Ljava/lang/Class;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "deserializeAndReturnEnvelope", "Lnet/corda/serialization/internal/amqp/ObjectAndEnvelope;", "doReadObject", "envelope", "Lnet/corda/serialization/internal/amqp/Envelope;", "(Lnet/corda/serialization/internal/amqp/Envelope;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "getEnvelope", "byteSequence", "readObject", "obj", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "type", "Ljava/lang/reflect/Type;", "readObjectOrNull", "schema", "materiallyEquivalentTo", "", "that", "Companion", "serialization"})
@KeepForDJVM
public final class DeserializationInput {
    private final List<Object> objectHistory;
    private final Logger logger;
    private final SerializerFactory serializerFactory;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Envelope getEnvelope(@NotNull ByteSequence byteSequence, @NotNull SerializationContext context) throws AMQPNoTypeNotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Companion.getEnvelope(byteSequence, context.getEncodingWhitelist());
    }

    private final <T> T deserialize(SerializedBytes<T> bytes, SerializationContext context) throws AMQPNotSerializableException, AMQPNoTypeNotSerializableException {
        ByteSequence byteSequence = (ByteSequence)bytes;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.deserialize(byteSequence, Object.class, context);
    }

    private final <R> R des(Function0<? extends R> generator) throws AMQPNotSerializableException, AMQPNoTypeNotSerializableException {
        try {
            Object object = generator.invoke();
            return (R)object;
        }
        catch (AMQPNotSerializableException amqp) {
            amqp.log("Deserialize", this.logger);
            throw (Throwable)new NotSerializableException(amqp.getMitigation());
        }
        catch (NotSerializableException nse) {
            throw (Throwable)nse;
        }
        catch (Exception e) {
            NotSerializableException notSerializableException;
            NotSerializableException $receiver = notSerializableException = new NotSerializableException("Internal deserialization failure: " + e.getClass().getName() + ": " + e.getMessage());
            $receiver.initCause(e);
            throw (Throwable)notSerializableException;
        }
        finally {
            this.objectHistory.clear();
        }
    }

    @NotNull
    public final <T> T deserialize(@NotNull ByteSequence bytes, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (T)this.des((Function0)new Function0<T>(this, context, bytes, clazz){
            final /* synthetic */ DeserializationInput this$0;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ ByteSequence $bytes;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final T invoke() {
                Object object;
                V v = this.$context.getProperties().get("AMQP_ENVELOPE_CACHE");
                if (!TypeIntrinsics.isMutableMap(v)) {
                    v = null;
                }
                if ((object = (Map)v) == null || (object = (Envelope)object.computeIfAbsent(new IdentityKey(this.$bytes), (Function)new Function<IdentityKey, Envelope>(this){
                    final /* synthetic */ deserialize.1 this$0;

                    @NotNull
                    public final Envelope apply(@NotNull IdentityKey key) {
                        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                        return DeserializationInput.Companion.getEnvelope(key.getBytes(), this.this$0.$context.getEncodingWhitelist());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })) == null) {
                    object = DeserializationInput.Companion.getEnvelope(this.$bytes, this.$context.getEncodingWhitelist());
                }
                Object envelope2 = object;
                Logger $receiver$iv = DeserializationInput.access$getLogger$p(this.this$0);
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string = "deserialize blob scheme=\"" + ((Envelope)envelope2).getSchema() + '\"';
                    logger.trace(string);
                }
                Object object2 = envelope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"envelope");
                return (T)DeserializationInput.access$doReadObject(this.this$0, (Envelope)object2, this.$clazz, this.$context);
            }
            {
                this.this$0 = deserializationInput;
                this.$context = serializationContext;
                this.$bytes = byteSequence;
                this.$clazz = clazz;
                super(0);
            }
        });
    }

    @NotNull
    public final <T> ObjectAndEnvelope<T> deserializeAndReturnEnvelope(@NotNull SerializedBytes<T> bytes, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull(bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (ObjectAndEnvelope)this.des((Function0)new Function0<ObjectAndEnvelope<? extends T>>(this, bytes, context, clazz){
            final /* synthetic */ DeserializationInput this$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ SerializationContext $context;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final ObjectAndEnvelope<T> invoke() {
                Envelope envelope2 = DeserializationInput.Companion.getEnvelope((ByteSequence)this.$bytes, this.$context.getEncodingWhitelist());
                return new ObjectAndEnvelope<Object>(DeserializationInput.access$doReadObject(this.this$0, envelope2, this.$clazz, this.$context), envelope2);
            }
            {
                this.this$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$context = serializationContext;
                this.$clazz = clazz;
                super(0);
            }
        });
    }

    private final <T> T doReadObject(Envelope envelope2, Class<T> clazz, SerializationContext context) {
        T t = clazz.cast(this.readObjectOrNull(SchemaKt.redescribe(envelope2.getObj(), clazz), new SerializationSchemas(envelope2.getSchema(), envelope2.getTransformsSchema()), clazz, context));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"clazz.cast(readObjectOrN\u2026text = context\n        ))");
        return t;
    }

    @Nullable
    public final Object readObjectOrNull(@Nullable Object obj, @NotNull SerializationSchemas schema, @NotNull Type type, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return obj == null ? null : this.readObject(obj, schema, type, context);
    }

    @NotNull
    public final Object readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull Type type, @NotNull SerializationContext context) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (obj instanceof DescribedType && Intrinsics.areEqual((Object)ReferencedObject.Companion.getDESCRIPTOR(), (Object)((DescribedType)obj).getDescriptor())) {
            Object object2 = ((DescribedType)obj).getDescribed();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.amqp.UnsignedInteger");
            }
            int objectIndex = ((UnsignedInteger)object2).intValue();
            if (objectIndex >= this.objectHistory.size()) {
                throw (Throwable)new AMQPNotSerializableException(type, "Retrieval of existing reference failed. Requested index " + objectIndex + ' ' + "is outside of the bounds for the list of size: " + this.objectHistory.size(), null, null, 12, null);
            }
            Object objectRetrieved = this.objectHistory.get(objectIndex);
            if (!SerializationHelperKt.isSubClassOf(objectRetrieved.getClass(), SerializationHelperKt.asClass(type))) {
                throw (Throwable)new AMQPNotSerializableException(type, "Existing reference type mismatch. Expected: '" + type + "', found: '" + objectRetrieved.getClass() + "' " + "@ " + objectIndex, null, null, 12, null);
            }
            object = objectRetrieved;
        } else {
            byte[] objectRead;
            Object object3;
            Object object4 = obj;
            if (object4 instanceof DescribedType) {
                Type type2;
                Type $receiver;
                AMQPSerializer<Object> serializer2 = this.serializerFactory.get(((DescribedType)obj).getDescriptor().toString(), schemas, context);
                if (Intrinsics.areEqual((Object)type, (Object)TypeIdentifier.getLocalType$default(TypeIdentifier.UnknownType.INSTANCE, null, 1, null)) ^ true && Intrinsics.areEqual((Object)serializer2.getType(), (Object)type) ^ true && !SerializationHelperKt.isSubClassOf($receiver = (type2 = serializer2.getType()), type) && !this.materiallyEquivalentTo($receiver, type)) {
                    throw (Throwable)new AMQPNotSerializableException(type, "Described type with descriptor " + ((DescribedType)obj).getDescriptor() + " was " + "expected to be of type " + type + " but was " + serializer2.getType(), null, null, 12, null);
                }
                Object object5 = ((DescribedType)obj).getDescribed();
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"obj.described");
                object3 = serializer2.readObject(object5, schemas, this, context);
            } else {
                object3 = object4 instanceof Binary ? ((Binary)obj).getArray() : (Object)(objectRead = type instanceof Class && ((Class)type).isPrimitive() ? (Object)obj : (Object)this.serializerFactory.get(obj.getClass(), type).readObject(obj, schemas, this, context));
            }
            if (this.serializerFactory.isSuitableForObjectReference(objectRead.getClass())) {
                Intrinsics.checkExpressionValueIsNotNull((Object)objectRead, (String)"objectRead");
                this.objectHistory.add(objectRead);
            }
            object = objectRead;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"if (obj is DescribedType\u2026 objectRead\n            }");
        return object;
    }

    private final boolean materiallyEquivalentTo(@NotNull Type $receiver, Type that) {
        boolean bl;
        Type type = that;
        if (type instanceof ParameterizedType) {
            bl = Intrinsics.areEqual(SerializationHelperKt.asClass($receiver), SerializationHelperKt.asClass(that));
        } else if (type instanceof TypeVariable) {
            Object[] objectArray = ((TypeVariable)that).getBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"that.bounds");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"that.bounds.first()");
            bl = SerializationHelperKt.isSubClassOf($receiver, (Type)object);
        } else if (type instanceof WildcardType) {
            Object[] objectArray = ((WildcardType)that).getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"that.upperBounds");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"that.upperBounds.first()");
            bl = SerializationHelperKt.isSubClassOf($receiver, (Type)object);
        } else {
            bl = false;
        }
        return bl;
    }

    public DeserializationInput(@NotNull SerializerFactory serializerFactory) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)serializerFactory, (String)"serializerFactory");
        this.serializerFactory = serializerFactory;
        DeserializationInput deserializationInput = this;
        deserializationInput.objectHistory = list = (List)new ArrayList();
        deserializationInput = this;
        Logger logger = LoggerFactory.getLogger(DeserializationInput.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(T::class.java)");
        list = logger;
        deserializationInput.logger = list;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DeserializationInput $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Object access$doReadObject(DeserializationInput $this, @NotNull Envelope envelope2, @NotNull Class clazz, @NotNull SerializationContext context) {
        return $this.doReadObject(envelope2, clazz, context);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ5\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/corda/serialization/internal/amqp/DeserializationInput$Companion;", "", "()V", "getEnvelope", "Lnet/corda/serialization/internal/amqp/Envelope;", "byteSequence", "Lnet/corda/core/utilities/ByteSequence;", "encodingWhitelist", "Lnet/corda/core/serialization/EncodingWhitelist;", "withDataBytes", "T", "task", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "(Lnet/corda/core/utilities/ByteSequence;Lnet/corda/core/serialization/EncodingWhitelist;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "serialization"})
    public static final class Companion {
        public final <T> T withDataBytes(@NotNull ByteSequence byteSequence, @NotNull EncodingWhitelist encodingWhitelist, @NotNull Function1<? super ByteBuffer, ? extends T> task) throws AMQPNoTypeNotSerializableException {
            Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
            Intrinsics.checkParameterIsNotNull((Object)encodingWhitelist, (String)"encodingWhitelist");
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            ByteBuffer byteBuffer = SchemaKt.getAmqpMagic().consume(byteSequence);
            if (byteBuffer == null) {
                throw (Throwable)new AMQPNoTypeNotSerializableException("Serialization header does not match.", null, 2, null);
            }
            ByteBuffer amqpSequence = byteBuffer;
            InputStream stream = new ByteBufferInputStream(amqpSequence);
            while (true) {
                switch (DeserializationInput$Companion$WhenMappings.$EnumSwitchMapping$0[SectionId.Companion.getReader().readFrom(stream).ordinal()]) {
                    case 1: {
                        CordaSerializationEncoding encoding = CordaSerializationEncoding.Companion.getReader().readFrom(stream);
                        if (!encodingWhitelist.acceptEncoding((SerializationEncoding)encoding)) {
                            AMQPNoTypeNotSerializableException aMQPNoTypeNotSerializableException;
                            String string = "Encoding not permitted: %s";
                            Object[] objectArray = new Object[]{encoding};
                            AMQPNoTypeNotSerializableException aMQPNoTypeNotSerializableException2 = aMQPNoTypeNotSerializableException;
                            AMQPNoTypeNotSerializableException aMQPNoTypeNotSerializableException3 = aMQPNoTypeNotSerializableException;
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                            String string3 = string2;
                            aMQPNoTypeNotSerializableException2(string3, null, 2, null);
                            throw (Throwable)aMQPNoTypeNotSerializableException3;
                        }
                        stream = encoding.wrap(stream);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Object object = task.invoke((Object)AMQPStreams.asByteBuffer(stream));
                        return (T)object;
                    }
                }
                continue;
                break;
            }
            finally {
                stream.close();
            }
        }

        @NotNull
        public final Envelope getEnvelope(@NotNull ByteSequence byteSequence, @NotNull EncodingWhitelist encodingWhitelist) throws AMQPNoTypeNotSerializableException {
            Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
            Intrinsics.checkParameterIsNotNull((Object)encodingWhitelist, (String)"encodingWhitelist");
            return (Envelope)this.withDataBytes(byteSequence, encodingWhitelist, getEnvelope.1.INSTANCE);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Envelope getEnvelope$default(Companion companion, ByteSequence byteSequence, EncodingWhitelist encodingWhitelist, int n, Object object) throws AMQPNoTypeNotSerializableException {
            if ((n & 2) != 0) {
                encodingWhitelist = NullEncodingWhitelist.INSTANCE;
            }
            return companion.getEnvelope(byteSequence, encodingWhitelist);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

