/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0017\u0010\u0002\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0017\u0010\u0004\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0017\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0000H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003*D\b\u0002\u0010\b\"\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00062\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0006\u00a8\u0006\t"}, d2={"Ljava/lang/Class;", "", "checkDictionary", "(Ljava/lang/Class;)V", "checkHashMap", "checkSupportedMapType", "Lkotlin/Function1;", "", "MapCreationFunction", "serialization"})
public final class MapSerializerKt {
    public static final void checkSupportedMapType(@NotNull Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        MapSerializerKt.checkHashMap($receiver);
        MapSerializerKt.checkDictionary($receiver);
    }

    private static final void checkHashMap(@NotNull Class<?> $receiver) {
        if (HashMap.class.isAssignableFrom($receiver) && !LinkedHashMap.class.isAssignableFrom($receiver)) {
            throw (Throwable)new IllegalArgumentException("Map type " + $receiver + " is unstable under iteration. Suggested fix: use java.util.LinkedHashMap instead.");
        }
    }

    private static final void checkDictionary(@NotNull Class<?> $receiver) {
        if (Dictionary.class.isAssignableFrom($receiver)) {
            throw (Throwable)new IllegalArgumentException("Unable to serialise deprecated type " + $receiver + ". Suggested fix: prefer java.util.map implementations");
        }
    }
}

