/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp;

import com.google.common.reflect.TypeResolver;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001aF\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001aF\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a*\u0010\r\u001a\u0004\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0004\u001a\u00020\u0010H\u0002\u001a(\u0010\r\u001a\u0004\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0004\u001a\u00020\u0002\u00a8\u0006\u0011"}, d2={"findPathToDeclared", "Lkotlin/sequences/Sequence;", "Ljava/lang/reflect/Type;", "startingType", "declaredType", "chain", "findPathViaGenericSuperclass", "startingClass", "Ljava/lang/Class;", "resolver", "Lkotlin/Function1;", "extendedChain", "findPathViaInterfaces", "inferTypeVariables", "actualClass", "declaredClass", "Ljava/lang/reflect/ParameterizedType;", "serialization"})
public final class TypeParameterUtilsKt {
    @Nullable
    public static final Type inferTypeVariables(@NotNull Class<?> actualClass, @NotNull Class<?> declaredClass, @NotNull Type declaredType) {
        Type type;
        Intrinsics.checkParameterIsNotNull(actualClass, (String)"actualClass");
        Intrinsics.checkParameterIsNotNull(declaredClass, (String)"declaredClass");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        Type type2 = declaredType;
        if (type2 instanceof ParameterizedType) {
            type = TypeParameterUtilsKt.inferTypeVariables(actualClass, declaredClass, (ParameterizedType)declaredType);
        } else if (type2 instanceof GenericArrayType) {
            Type declaredComponent = ((GenericArrayType)declaredType).getGenericComponentType();
            Class<?> clazz = actualClass.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"actualClass.componentType");
            Type type3 = declaredComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"declaredComponent");
            Type type4 = TypeParameterUtilsKt.inferTypeVariables(clazz, SerializationHelperKt.asClass(type3), declaredComponent);
            type = type4 != null ? SerializationHelperKt.asArray(type4) : null;
        } else {
            type = actualClass;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private static final Type inferTypeVariables(Class<?> actualClass, Class<?> declaredClass, ParameterizedType declaredType) {
        void $receiver$iv;
        TypeResolver initial$iv;
        if (Intrinsics.areEqual(declaredClass, actualClass)) {
            return null;
        }
        TypeVariable<Class<?>>[] typeVariableArray = actualClass.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"actualClass.typeParameters");
        TypeVariable<Class<?>>[] typeVariableArray2 = typeVariableArray;
        if (typeVariableArray2.length == 0) {
            return actualClass;
        }
        Object object = TypeParameterUtilsKt.findPathToDeclared$default(actualClass, declaredType, null, 4, null);
        if (object == null || (object = SequencesKt.toList((Sequence)object)) == null) {
            throw (Throwable)new AMQPNotSerializableException(declaredType, "No inheritance path between actual " + actualClass + " and declared " + declaredType + '.', null, null, 12, null);
        }
        Object implementationChain = object;
        Type start = (Type)CollectionsKt.last((List)implementationChain);
        List rest = CollectionsKt.drop((Iterable)CollectionsKt.dropLast((List)implementationChain, (int)1), (int)1);
        Iterable iterable = CollectionsKt.reversed((Iterable)rest);
        TypeResolver accumulator$iv = initial$iv = new TypeResolver().where(start, (Type)declaredType);
        for (Object element$iv : $receiver$iv) {
            void chainEntry;
            Type type = (Type)element$iv;
            TypeResolver resolved = accumulator$iv;
            Type newResolved = resolved.resolveType((Type)chainEntry);
            accumulator$iv = new TypeResolver().where((Type)chainEntry, newResolved);
        }
        TypeResolver resolver2 = accumulator$iv;
        ParameterizedType endType = SerializationHelperKt.asParameterizedType(actualClass);
        return resolver2.resolveType((Type)endType);
    }

    private static final Sequence<Type> findPathToDeclared(Type startingType, Type declaredType, Sequence<? extends Type> chain) {
        Sequence extendedChain = SequencesKt.plus(chain, (Object)startingType);
        Class<?> startingClass = SerializationHelperKt.asClass(startingType);
        if (Intrinsics.areEqual(startingClass, SerializationHelperKt.asClass(declaredType))) {
            return extendedChain;
        }
        Function1 resolver2 = (Function1)new Function1<Type, Type>(startingClass, startingType){
            final /* synthetic */ Class $startingClass;
            final /* synthetic */ Type $startingType;

            public final Type invoke(@NotNull Type type) {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                return new TypeResolver().where((Type)SerializationHelperKt.asParameterizedType(this.$startingClass), (Type)SerializationHelperKt.asParameterizedType(this.$startingType)).resolveType(type);
            }
            {
                this.$startingClass = clazz;
                this.$startingType = type;
                super(1);
            }
        };
        Sequence<Type> sequence = TypeParameterUtilsKt.findPathViaGenericSuperclass(startingClass, (Function1<? super Type, ? extends Type>)resolver2, declaredType, (Sequence<? extends Type>)extendedChain);
        if (sequence == null) {
            sequence = TypeParameterUtilsKt.findPathViaInterfaces(startingClass, (Function1<? super Type, ? extends Type>)resolver2, declaredType, (Sequence<? extends Type>)extendedChain);
        }
        return sequence;
    }

    static /* bridge */ /* synthetic */ Sequence findPathToDeclared$default(Type type, Type type2, Sequence sequence, int n, Object object) {
        if ((n & 4) != 0) {
            sequence = SequencesKt.emptySequence();
        }
        return TypeParameterUtilsKt.findPathToDeclared(type, type2, (Sequence<? extends Type>)sequence);
    }

    private static final Sequence<Type> findPathViaInterfaces(Class<?> startingClass, Function1<? super Type, ? extends Type> resolver2, Type declaredType, Sequence<? extends Type> extendedChain) {
        Object[] objectArray = startingClass.getGenericInterfaces();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"startingClass.genericInterfaces");
        return (Sequence)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<Type, Sequence<? extends Type>>(resolver2, declaredType, extendedChain){
            final /* synthetic */ Function1 $resolver;
            final /* synthetic */ Type $declaredType;
            final /* synthetic */ Sequence $extendedChain;

            @Nullable
            public final Sequence<Type> invoke(Type it) {
                Type type = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"it");
                return TypeParameterUtilsKt.access$findPathToDeclared((Type)this.$resolver.invoke((Object)type), this.$declaredType, this.$extendedChain);
            }
            {
                this.$resolver = function1;
                this.$declaredType = type;
                this.$extendedChain = sequence;
                super(1);
            }
        }))));
    }

    private static final Sequence<Type> findPathViaGenericSuperclass(Class<?> startingClass, Function1<? super Type, ? extends Type> resolver2, Type declaredType, Sequence<? extends Type> extendedChain) {
        Type type = startingClass.getGenericSuperclass();
        if (type == null) {
            return null;
        }
        Type superClass = type;
        return TypeParameterUtilsKt.findPathToDeclared((Type)resolver2.invoke((Object)superClass), declaredType, extendedChain);
    }

    @Nullable
    public static final /* synthetic */ Sequence access$findPathToDeclared(@NotNull Type startingType, @NotNull Type declaredType, @NotNull Sequence chain) {
        return TypeParameterUtilsKt.findPathToDeclared(startingType, declaredType, (Sequence<? extends Type>)chain);
    }
}

