/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.RestrictedType;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J(\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lnet/corda/serialization/internal/amqp/custom/InputStreamSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Implements;", "Ljava/io/InputStream;", "()V", "revealSubclassesInSchema", "", "getRevealSubclassesInSchema", "()Z", "schemaForDocumentation", "Lnet/corda/serialization/internal/amqp/Schema;", "getSchemaForDocumentation", "()Lnet/corda/serialization/internal/amqp/Schema;", "readObject", "obj", "", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "input", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "context", "Lnet/corda/core/serialization/SerializationContext;", "writeDescribedObject", "", "data", "Lorg/apache/qpid/proton/codec/Data;", "type", "Ljava/lang/reflect/Type;", "output", "Lnet/corda/serialization/internal/amqp/SerializationOutput;", "serialization"})
public final class InputStreamSerializer
extends CustomSerializer.Implements<InputStream> {
    private static final boolean revealSubclassesInSchema = true;
    @NotNull
    private static final Schema schemaForDocumentation;
    public static final InputStreamSerializer INSTANCE;

    @Override
    public boolean getRevealSubclassesInSchema() {
        return revealSubclassesInSchema;
    }

    @Override
    @NotNull
    public Schema getSchemaForDocumentation() {
        return schemaForDocumentation;
    }

    @Override
    public void writeDescribedObject(@NotNull InputStream obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output, @NotNull SerializationContext context) {
        int numberOfBytesRead;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int n = 4096;
        int n2 = obj.available() + 1;
        int startingSize = Math.max(n, n2);
        byte[] buffer = new byte[startingSize];
        int pos = 0;
        while ((numberOfBytesRead = obj.read(buffer, pos, buffer.length - pos)) != -1) {
            if ((pos += numberOfBytesRead) != buffer.length) continue;
            byte[] byArray = buffer;
            int n3 = 4096;
            int n4 = obj.available() + 1;
            int n5 = buffer.length;
            int n6 = Math.max(n3, n4);
            n3 = n5 + n6;
            Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(byArray, n3), (String)"java.util.Arrays.copyOf(this, newSize)");
        }
        data.putBinary(new Binary(buffer, 0, pos));
    }

    @Override
    @NotNull
    public InputStream readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        byte[] bits;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = input.readObject(obj, schemas, (Type)((Object)byte[].class), context);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] byArray = bits = (byte[])object;
        return new ByteArrayInputStream(byArray);
    }

    private InputStreamSerializer() {
        super(InputStream.class);
    }

    static {
        InputStreamSerializer inputStreamSerializer;
        INSTANCE = inputStreamSerializer = new InputStreamSerializer();
        revealSubclassesInSchema = true;
        schemaForDocumentation = new Schema(CollectionsKt.listOf((Object)new RestrictedType(inputStreamSerializer.getType().toString(), "", CollectionsKt.listOf((Object)inputStreamSerializer.getType().toString()), AMQPTypeIdentifiers.INSTANCE.primitiveTypeName((Type)((Object)byte[].class)), inputStreamSerializer.getDescriptor(), CollectionsKt.emptyList())));
    }
}

