/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.KeepForDJVM;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/serialization/internal/amqp/custom/LocalTimeSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Proxy;", "Ljava/time/LocalTime;", "Lnet/corda/serialization/internal/amqp/custom/LocalTimeSerializer$LocalTimeProxy;", "factory", "Lnet/corda/serialization/internal/amqp/SerializerFactory;", "(Lnet/corda/serialization/internal/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "LocalTimeProxy", "serialization"})
public final class LocalTimeSerializer
extends CustomSerializer.Proxy<LocalTime, LocalTimeProxy> {
    @Override
    @NotNull
    protected LocalTimeProxy toProxy(@NotNull LocalTime obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return new LocalTimeProxy((byte)obj.getHour(), (byte)obj.getMinute(), (byte)obj.getSecond(), obj.getNano());
    }

    @Override
    @NotNull
    protected LocalTime fromProxy(@NotNull LocalTimeProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        LocalTime localTime = LocalTime.of(proxy.getHour(), proxy.getMinute(), proxy.getSecond(), proxy.getNano());
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"LocalTime.of(\n          \u2026         proxy.nano\n    )");
        return localTime;
    }

    public LocalTimeSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(LocalTime.class, LocalTimeProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lnet/corda/serialization/internal/amqp/custom/LocalTimeSerializer$LocalTimeProxy;", "", "hour", "", "minute", "second", "nano", "", "(BBBI)V", "getHour", "()B", "getMinute", "getNano", "()I", "getSecond", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "serialization"})
    @KeepForDJVM
    public static final class LocalTimeProxy {
        private final byte hour;
        private final byte minute;
        private final byte second;
        private final int nano;

        public final byte getHour() {
            return this.hour;
        }

        public final byte getMinute() {
            return this.minute;
        }

        public final byte getSecond() {
            return this.second;
        }

        public final int getNano() {
            return this.nano;
        }

        public LocalTimeProxy(byte hour, byte minute, byte second, int nano) {
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.nano = nano;
        }

        public final byte component1() {
            return this.hour;
        }

        public final byte component2() {
            return this.minute;
        }

        public final byte component3() {
            return this.second;
        }

        public final int component4() {
            return this.nano;
        }

        @NotNull
        public final LocalTimeProxy copy(byte hour, byte minute, byte second, int nano) {
            return new LocalTimeProxy(hour, minute, second, nano);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LocalTimeProxy copy$default(LocalTimeProxy localTimeProxy, byte by, byte by2, byte by3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                by = localTimeProxy.hour;
            }
            if ((n2 & 2) != 0) {
                by2 = localTimeProxy.minute;
            }
            if ((n2 & 4) != 0) {
                by3 = localTimeProxy.second;
            }
            if ((n2 & 8) != 0) {
                n = localTimeProxy.nano;
            }
            return localTimeProxy.copy(by, by2, by3, n);
        }

        @NotNull
        public String toString() {
            return "LocalTimeProxy(hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", nano=" + this.nano + ")";
        }

        public int hashCode() {
            return ((Byte.hashCode(this.hour) * 31 + Byte.hashCode(this.minute)) * 31 + Byte.hashCode(this.second)) * 31 + Integer.hashCode(this.nano);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LocalTimeProxy)) break block3;
                    LocalTimeProxy localTimeProxy = (LocalTimeProxy)object;
                    if (!(this.hour == localTimeProxy.hour) || !(this.minute == localTimeProxy.minute) || !(this.second == localTimeProxy.second) || !(this.nano == localTimeProxy.nano)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

