/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.amqp.custom;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.serialization.internal.amqp.AMQPTypeIdentifiers;
import net.corda.serialization.internal.amqp.CustomSerializer;
import net.corda.serialization.internal.amqp.DeserializationInput;
import net.corda.serialization.internal.amqp.RestrictedType;
import net.corda.serialization.internal.amqp.Schema;
import net.corda.serialization.internal.amqp.SerializationOutput;
import net.corda.serialization.internal.amqp.SerializationSchemas;
import net.corda.serialization.internal.amqp.custom.CacheKey;
import net.corda.serialization.internal.amqp.custom.X509CRLSerializer;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lnet/corda/serialization/internal/amqp/custom/X509CRLSerializer;", "Lnet/corda/serialization/internal/amqp/CustomSerializer$Implements;", "Ljava/security/cert/X509CRL;", "()V", "schemaForDocumentation", "Lnet/corda/serialization/internal/amqp/Schema;", "getSchemaForDocumentation", "()Lnet/corda/serialization/internal/amqp/Schema;", "generateCRL", "bytes", "", "readObject", "obj", "", "schemas", "Lnet/corda/serialization/internal/amqp/SerializationSchemas;", "input", "Lnet/corda/serialization/internal/amqp/DeserializationInput;", "context", "Lnet/corda/core/serialization/SerializationContext;", "writeDescribedObject", "", "data", "Lorg/apache/qpid/proton/codec/Data;", "type", "Ljava/lang/reflect/Type;", "output", "Lnet/corda/serialization/internal/amqp/SerializationOutput;", "serialization"})
public final class X509CRLSerializer
extends CustomSerializer.Implements<X509CRL> {
    @NotNull
    private static final Schema schemaForDocumentation;
    public static final X509CRLSerializer INSTANCE;

    @Override
    @NotNull
    public Schema getSchemaForDocumentation() {
        return schemaForDocumentation;
    }

    @Override
    public void writeDescribedObject(@NotNull X509CRL obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        byte[] byArray = obj.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"obj.encoded");
        SerializationOutput.writeObject$serialization$default(output, byArray, data, this.getClazz(), context, 0, 16, null);
    }

    @Override
    @NotNull
    public X509CRL readObject(@NotNull Object obj, @NotNull SerializationSchemas schemas, @NotNull DeserializationInput input, @NotNull SerializationContext context) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object2 = input.readObject(obj, schemas, (Type)((Object)byte[].class), context);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] bytes = (byte[])object2;
        Object v = context.getProperties().get("DESERIALIZATION_CACHE");
        if (!TypeIntrinsics.isMutableMap(v)) {
            v = null;
        }
        if ((object = (Map)v) == null || (object = (X509CRL)object.computeIfAbsent(new CacheKey(bytes), readObject.1.INSTANCE)) == null) {
            object = this.generateCRL(bytes);
        }
        return object;
    }

    private final X509CRL generateCRL(byte[] bytes) {
        byte[] byArray = bytes;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CRL cRL = certificateFactory.generateCRL(byteArrayInputStream);
        if (cRL == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509CRL");
        }
        return (X509CRL)cRL;
    }

    private X509CRLSerializer() {
        super(X509CRL.class);
    }

    static {
        X509CRLSerializer x509CRLSerializer;
        INSTANCE = x509CRLSerializer = new X509CRLSerializer();
        schemaForDocumentation = new Schema(CollectionsKt.listOf((Object)new RestrictedType(x509CRLSerializer.getType().toString(), "", CollectionsKt.listOf((Object)x509CRLSerializer.getType().toString()), AMQPTypeIdentifiers.INSTANCE.primitiveTypeName((Type)((Object)byte[].class)), x509CRLSerializer.getDescriptor(), CollectionsKt.emptyList())));
    }

    @NotNull
    public static final /* synthetic */ X509CRL access$generateCRL(X509CRLSerializer $this, @NotNull byte[] bytes) {
        return $this.generateCRL(bytes);
    }
}

