/*
 * Decompiled with CFR 0.152.
 */
package net.corda.serialization.internal.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.corda.serialization.internal.amqp.AMQPExceptionsKt;
import net.corda.serialization.internal.amqp.AMQPNotSerializableException;
import net.corda.serialization.internal.amqp.CustomSerializerRegistry;
import net.corda.serialization.internal.amqp.SerializationHelperKt;
import net.corda.serialization.internal.model.FingerprintWriter;
import net.corda.serialization.internal.model.LocalPropertyInformation;
import net.corda.serialization.internal.model.LocalTypeInformation;
import net.corda.serialization.internal.model.TypeIdentifier;
import org.apache.qpid.proton.amqp.Symbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u001c\u0010)\u001a\u00020\u00152\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020,0+H\u0002J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0016\u0010.\u001a\u00020\u00152\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0!H\u0002J\u001e\u00100\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001502H\u0002J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnet/corda/serialization/internal/model/FingerPrintingState;", "", "customSerializerRegistry", "Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;", "classLoader", "Ljava/lang/ClassLoader;", "writer", "Lnet/corda/serialization/internal/model/FingerprintWriter;", "(Lnet/corda/serialization/internal/amqp/CustomSerializerRegistry;Ljava/lang/ClassLoader;Lnet/corda/serialization/internal/model/FingerprintWriter;)V", "typesSeen", "", "Lnet/corda/serialization/internal/model/TypeIdentifier;", "adjustType", "Lkotlin/Pair;", "", "Lnet/corda/serialization/internal/model/LocalTypeInformation;", "propertyType", "fingerprint", "", "type", "fingerprintAbstract", "", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Abstract;", "fingerprintCollection", "Lnet/corda/serialization/internal/model/LocalTypeInformation$ACollection;", "fingerprintComposable", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Composable;", "fingerprintEnum", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AnEnum;", "fingerprintInterface", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AnInterface;", "fingerprintInterfaces", "interfaces", "", "fingerprintMap", "Lnet/corda/serialization/internal/model/LocalTypeInformation$AMap;", "fingerprintName", "fingerprintNewType", "fingerprintNonComposable", "Lnet/corda/serialization/internal/model/LocalTypeInformation$NonComposable;", "fingerprintOpaque", "fingerprintProperties", "properties", "", "Lnet/corda/serialization/internal/model/LocalPropertyInformation;", "fingerprintType", "fingerprintTypeParameters", "typeParameters", "fingerprintWithCustomSerializerOrElse", "defaultAction", "Lkotlin/Function0;", "hasSeen", "Companion", "serialization"})
final class FingerPrintingState {
    private final Set<TypeIdentifier> typesSeen;
    private final CustomSerializerRegistry customSerializerRegistry;
    private final ClassLoader classLoader;
    private final FingerprintWriter writer;
    private static LocalTypeInformation.Atomic CHARACTER_TYPE;
    public static final Companion Companion;

    @NotNull
    public final String fingerprint(@NotNull LocalTypeInformation type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.fingerprintType((LocalTypeInformation)type).writer.getFingerprint();
    }

    private final FingerPrintingState fingerprintType(LocalTypeInformation type) {
        FingerPrintingState fingerPrintingState = this;
        FingerPrintingState $receiver = fingerPrintingState;
        if ($receiver.hasSeen(type.getTypeIdentifier())) {
            $receiver.writer.writeAlreadySeen();
        } else if (type instanceof LocalTypeInformation.Cycle) {
            $receiver.fingerprintType(((LocalTypeInformation.Cycle)type).getFollow());
        } else {
            try {
                $receiver.typesSeen.add(type.getTypeIdentifier());
                $receiver.fingerprintNewType(type);
            }
            catch (Throwable th$iv) {
                Throwable throwable = th$iv;
                if (throwable instanceof AMQPNotSerializableException) {
                    List<String> list = ((AMQPNotSerializableException)th$iv).getClassHierarchy();
                    String string = type.getObservedType().getTypeName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.observedType.typeName");
                    String string2 = string;
                    list.add(string2);
                } else if (!(throwable instanceof ClassNotFoundException) && !(throwable instanceof NoClassDefFoundError)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Throwable throwable2 = th$iv;
                    String string = type.getObservedType().getTypeName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.observedType.typeName");
                    String string3 = string;
                    AMQPExceptionsKt.access$setMessage(throwable2, stringBuilder.append(string3).append(" -> ").append(th$iv.getMessage()).toString());
                }
                throw th$iv;
            }
        }
        return fingerPrintingState;
    }

    private final FingerPrintingState fingerprintNewType(LocalTypeInformation type) {
        FingerPrintingState fingerPrintingState;
        FingerPrintingState $receiver = fingerPrintingState = this;
        LocalTypeInformation localTypeInformation = type;
        if (localTypeInformation instanceof LocalTypeInformation.Cycle) {
            throw (Throwable)new IllegalStateException("Cyclic references must be dereferenced before fingerprinting");
        }
        if (localTypeInformation instanceof LocalTypeInformation.Unknown) {
            $receiver.writer.writeUnknown();
        } else if (localTypeInformation instanceof LocalTypeInformation.Top) {
            $receiver.writer.writeTop();
        } else if (localTypeInformation instanceof LocalTypeInformation.AnArray) {
            $receiver.fingerprintType(((LocalTypeInformation.AnArray)type).getComponentType());
            $receiver.writer.writeArray();
        } else if (localTypeInformation instanceof LocalTypeInformation.ACollection) {
            $receiver.fingerprintCollection((LocalTypeInformation.ACollection)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.AMap) {
            $receiver.fingerprintMap((LocalTypeInformation.AMap)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.Atomic) {
            $receiver.fingerprintName(type);
        } else if (localTypeInformation instanceof LocalTypeInformation.Opaque) {
            $receiver.fingerprintOpaque(type);
        } else if (localTypeInformation instanceof LocalTypeInformation.AnEnum) {
            $receiver.fingerprintEnum((LocalTypeInformation.AnEnum)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.AnInterface) {
            $receiver.fingerprintInterface((LocalTypeInformation.AnInterface)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.Abstract) {
            $receiver.fingerprintAbstract((LocalTypeInformation.Abstract)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.Singleton) {
            $receiver.fingerprintName(type);
        } else if (localTypeInformation instanceof LocalTypeInformation.Composable) {
            $receiver.fingerprintComposable((LocalTypeInformation.Composable)type);
        } else if (localTypeInformation instanceof LocalTypeInformation.NonComposable) {
            $receiver.fingerprintNonComposable((LocalTypeInformation.NonComposable)type);
        }
        return fingerPrintingState;
    }

    private final void fingerprintCollection(LocalTypeInformation.ACollection type) {
        this.fingerprintName(type);
        this.fingerprintType(type.getElementType());
    }

    private final void fingerprintMap(LocalTypeInformation.AMap type) {
        this.fingerprintName(type);
        this.fingerprintType(type.getKeyType());
        this.fingerprintType(type.getValueType());
    }

    private final void fingerprintOpaque(LocalTypeInformation type) {
        this.fingerprintWithCustomSerializerOrElse(type, (Function0<Unit>)((Function0)new Function0<Unit>(this, type){
            final /* synthetic */ FingerPrintingState this$0;
            final /* synthetic */ LocalTypeInformation $type;

            public final void invoke() {
                FingerPrintingState.access$fingerprintName(this.this$0, this.$type);
            }
            {
                this.this$0 = fingerPrintingState;
                this.$type = localTypeInformation;
                super(0);
            }
        }));
    }

    private final void fingerprintInterface(LocalTypeInformation.AnInterface type) {
        this.fingerprintWithCustomSerializerOrElse(type, (Function0<Unit>)((Function0)new Function0<Unit>(this, type){
            final /* synthetic */ FingerPrintingState this$0;
            final /* synthetic */ LocalTypeInformation.AnInterface $type;

            public final void invoke() {
                FingerPrintingState.access$fingerprintName(this.this$0, this.$type);
                FingerPrintingState.access$getWriter$p(this.this$0).writeAlreadySeen();
                FingerPrintingState.access$fingerprintInterfaces(this.this$0, this.$type.getInterfaces());
                FingerPrintingState.access$fingerprintTypeParameters(this.this$0, this.$type.getTypeParameters());
            }
            {
                this.this$0 = fingerPrintingState;
                this.$type = anInterface;
                super(0);
            }
        }));
    }

    private final void fingerprintAbstract(LocalTypeInformation.Abstract type) {
        this.fingerprintWithCustomSerializerOrElse(type, (Function0<Unit>)((Function0)new Function0<Unit>(this, type){
            final /* synthetic */ FingerPrintingState this$0;
            final /* synthetic */ LocalTypeInformation.Abstract $type;

            public final void invoke() {
                FingerPrintingState.access$fingerprintName(this.this$0, this.$type);
                FingerPrintingState.access$fingerprintProperties(this.this$0, this.$type.getProperties());
                FingerPrintingState.access$fingerprintInterfaces(this.this$0, this.$type.getInterfaces());
                FingerPrintingState.access$fingerprintTypeParameters(this.this$0, this.$type.getTypeParameters());
            }
            {
                this.this$0 = fingerPrintingState;
                this.$type = abstract_;
                super(0);
            }
        }));
    }

    private final void fingerprintNonComposable(LocalTypeInformation.NonComposable type) {
        this.fingerprintWithCustomSerializerOrElse(type, (Function0<Unit>)((Function0)new Function0<Unit>(this, type){
            final /* synthetic */ FingerPrintingState this$0;
            final /* synthetic */ LocalTypeInformation.NonComposable $type;

            public final void invoke() {
                FingerPrintingState.access$fingerprintName(this.this$0, this.$type);
                FingerPrintingState.access$fingerprintProperties(this.this$0, this.$type.getProperties());
                FingerPrintingState.access$fingerprintInterfaces(this.this$0, this.$type.getInterfaces());
                FingerPrintingState.access$fingerprintTypeParameters(this.this$0, this.$type.getTypeParameters());
            }
            {
                this.this$0 = fingerPrintingState;
                this.$type = nonComposable;
                super(0);
            }
        }));
    }

    private final void fingerprintComposable(LocalTypeInformation.Composable type) {
        this.fingerprintWithCustomSerializerOrElse(type, (Function0<Unit>)((Function0)new Function0<Unit>(this, type){
            final /* synthetic */ FingerPrintingState this$0;
            final /* synthetic */ LocalTypeInformation.Composable $type;

            public final void invoke() {
                FingerPrintingState.access$fingerprintName(this.this$0, this.$type);
                FingerPrintingState.access$fingerprintProperties(this.this$0, this.$type.getProperties());
                FingerPrintingState.access$fingerprintInterfaces(this.this$0, this.$type.getInterfaces());
                FingerPrintingState.access$fingerprintTypeParameters(this.this$0, this.$type.getTypeParameters());
            }
            {
                this.this$0 = fingerPrintingState;
                this.$type = composable;
                super(0);
            }
        }));
    }

    private final void fingerprintName(LocalTypeInformation type) {
        TypeIdentifier identifier = type.getTypeIdentifier();
        TypeIdentifier typeIdentifier = identifier;
        if (typeIdentifier instanceof TypeIdentifier.ArrayOf) {
            this.writer.write(((TypeIdentifier.ArrayOf)identifier).getComponentType().getName()).writeArray();
        } else {
            this.writer.write(identifier.getName());
        }
    }

    private final void fingerprintTypeParameters(List<? extends LocalTypeInformation> typeParameters) {
        Iterable $receiver$iv = typeParameters;
        for (Object element$iv : $receiver$iv) {
            LocalTypeInformation it = (LocalTypeInformation)element$iv;
            this.fingerprintType(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fingerprintProperties(Map<String, ? extends LocalPropertyInformation> properties2) {
        Sequence $receiver$iv = MapsKt.asSequence(properties2);
        Sequence sequence = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        $receiver$iv = SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator);
        for (Object element$iv : $receiver$iv) {
            void neverMandatory;
            Map.Entry $propertyName_propertyType;
            Map.Entry entry = $propertyName_propertyType = (Map.Entry)element$iv;
            String propertyName = (String)entry.getKey();
            entry = $propertyName_propertyType;
            LocalPropertyInformation propertyType = (LocalPropertyInformation)entry.getValue();
            Pair<Boolean, LocalTypeInformation> pair = this.adjustType(propertyType.getType());
            boolean bl = (Boolean)pair.component1();
            LocalTypeInformation adjustedType = (LocalTypeInformation)pair.component2();
            this.fingerprintType(adjustedType);
            this.writer.write(propertyName);
            if (propertyType.isMandatory() && neverMandatory == false) {
                this.writer.writeNotNullable();
                continue;
            }
            this.writer.writeNullable();
        }
    }

    private final Pair<Boolean, LocalTypeInformation> adjustType(LocalTypeInformation propertyType) {
        return Intrinsics.areEqual((Object)propertyType.getTypeIdentifier().getName(), (Object)"char") ? TuplesKt.to((Object)true, (Object)CHARACTER_TYPE) : TuplesKt.to((Object)false, (Object)propertyType);
    }

    private final void fingerprintInterfaces(List<? extends LocalTypeInformation> interfaces) {
        Iterable $receiver$iv = interfaces;
        for (Object element$iv : $receiver$iv) {
            LocalTypeInformation it = (LocalTypeInformation)element$iv;
            this.fingerprintType(it);
        }
    }

    private final void fingerprintEnum(LocalTypeInformation.AnEnum type) {
        this.writer.write(type.getMembers()).write(type.getTypeIdentifier().getName()).writeEnum();
    }

    private final void fingerprintWithCustomSerializerOrElse(LocalTypeInformation type, Function0<Unit> defaultAction) {
        String customTypeDescriptor;
        Type observedGenericType;
        Type observedType = type.getObservedType();
        Class<?> observedClass = SerializationHelperKt.asClass(observedType);
        Symbol symbol = this.customSerializerRegistry.findCustomSerializer(observedClass, observedGenericType = !(observedType instanceof ParameterizedType) && type.getTypeIdentifier() instanceof TypeIdentifier.Parameterised && Intrinsics.areEqual(observedClass, Class.class) ^ true ? type.getTypeIdentifier().getLocalType(this.classLoader) : observedType);
        String string = symbol != null && (symbol = symbol.getTypeDescriptor()) != null ? symbol.toString() : (customTypeDescriptor = null);
        if (customTypeDescriptor != null) {
            this.writer.write(customTypeDescriptor);
        } else {
            defaultAction.invoke();
        }
    }

    private final boolean hasSeen(TypeIdentifier type) {
        return this.typesSeen.contains(type) && Intrinsics.areEqual((Object)type, (Object)TypeIdentifier.UnknownType.INSTANCE) ^ true;
    }

    public FingerPrintingState(@NotNull CustomSerializerRegistry customSerializerRegistry, @NotNull ClassLoader classLoader, @NotNull FingerprintWriter writer) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)customSerializerRegistry, (String)"customSerializerRegistry");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.customSerializerRegistry = customSerializerRegistry;
        this.classLoader = classLoader;
        this.writer = writer;
        FingerPrintingState fingerPrintingState = this;
        fingerPrintingState.typesSeen = set = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        CHARACTER_TYPE = new LocalTypeInformation.Atomic(Character.class, TypeIdentifier.Companion.forClass(Character.class));
    }

    public static final /* synthetic */ void access$fingerprintName(FingerPrintingState $this, @NotNull LocalTypeInformation type) {
        $this.fingerprintName(type);
    }

    @NotNull
    public static final /* synthetic */ FingerprintWriter access$getWriter$p(FingerPrintingState $this) {
        return $this.writer;
    }

    public static final /* synthetic */ void access$fingerprintInterfaces(FingerPrintingState $this, @NotNull List interfaces) {
        $this.fingerprintInterfaces(interfaces);
    }

    public static final /* synthetic */ void access$fingerprintTypeParameters(FingerPrintingState $this, @NotNull List typeParameters) {
        $this.fingerprintTypeParameters(typeParameters);
    }

    public static final /* synthetic */ void access$fingerprintProperties(FingerPrintingState $this, @NotNull Map properties2) {
        $this.fingerprintProperties(properties2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/serialization/internal/model/FingerPrintingState$Companion;", "", "()V", "CHARACTER_TYPE", "Lnet/corda/serialization/internal/model/LocalTypeInformation$Atomic;", "serialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

