/*
 * Decompiled with CFR 0.152.
 */
package net.corda.v5.serialization;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingSerializerException
extends NotSerializableException {
    private final String typeDescriptor;
    private final List<String> typeNames;

    private MissingSerializerException(@NotNull String message, @Nullable String typeDescriptor, @NotNull List<String> typeNames) {
        super(message);
        Objects.requireNonNull(message, "message may not be null");
        Objects.requireNonNull(typeNames, "typeNames may not be null");
        this.typeDescriptor = typeDescriptor;
        this.typeNames = List.copyOf(typeNames);
    }

    public MissingSerializerException(@NotNull String message, @NotNull String typeDescriptor) {
        this(message, typeDescriptor, Collections.emptyList());
        Objects.requireNonNull(typeDescriptor, "typeDescriptor may not be null");
    }

    public MissingSerializerException(@NotNull String message, @NotNull List<String> typeNames) {
        this(message, null, typeNames);
    }

    @Nullable
    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @NotNull
    public List<String> getTypeNames() {
        return this.typeNames;
    }
}

