/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.components;

import java.io.Serializable;
import java.util.HashMap;
import net.databinder.DataStaticService;
import net.databinder.auth.IAuthSession;
import net.databinder.auth.IAuthSettings;
import net.databinder.auth.components.DataSignInPage;
import net.databinder.auth.components.RSAPasswordTextField;
import net.databinder.auth.data.IUser;
import net.databinder.auth.valid.EqualPasswordConvertedInputValidator;
import net.databinder.components.NullPlug;
import net.databinder.components.hibernate.DataForm;
import net.databinder.models.HibernateObjectModel;
import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.SimpleFormComponentLabel;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;

public class DataProfilePanel
extends Panel {
    private DataSignInPage.ReturnPage returnPage;
    private ProfileForm form;

    public DataProfilePanel(String id, DataSignInPage.ReturnPage returnPage) {
        super(id);
        this.returnPage = returnPage;
        this.add((Component)new FeedbackPanel("feedback"));
        HibernateObjectModel userModel = DataSignInPage.getAuthSession().getUserModel();
        if (userModel == null) {
            userModel = new HibernateObjectModel(((IAuthSettings)this.getApplication()).getUserClass());
        }
        this.form = new ProfileForm("registerForm", userModel);
        this.add((Component)this.form);
    }

    public static boolean isAvailable(String username) {
        Session session = DataStaticService.getHibernateSession();
        IAuthSettings authSettings = (IAuthSettings)Application.get();
        Criteria c = session.createCriteria(authSettings.getUserClass());
        authSettings.getUserCriteriaBuilder(username).build(c);
        IUser found = (IUser)c.uniqueResult();
        IUser current = ((IAuthSession)WebSession.get()).getUser();
        return found == null || found.equals(current);
    }

    protected Component highFormSocket(String id) {
        return new NullPlug(id);
    }

    protected Component lowFormSocket(String id) {
        return new NullPlug(id);
    }

    public ProfileForm getForm() {
        return this.form;
    }

    public static class UsernameValidator
    extends StringValidator {
        protected void onValidate(IValidatable validatable) {
            String username = (String)validatable.getValue();
            if (username != null && !DataProfilePanel.isAvailable(username)) {
                HashMap<String, String> m = new HashMap<String, String>(1);
                m.put("username", username);
                this.error(validatable, "data.auth.username.taken", m);
            }
        }
    }

    protected class ProfileForm
    extends DataForm {
        private RequiredTextField username;
        private RSAPasswordTextField password;
        private RSAPasswordTextField passwordConfirm;
        private CheckBox rememberMe;

        IUser getUser() {
            return (IUser)this.getPersistentObjectModel().getObject();
        }

        boolean existing() {
            return DataStaticService.getHibernateSession().contains((Object)this.getUser());
        }

        public ProfileForm(String id, HibernateObjectModel userModel) {
            super(id, userModel);
            this.add(DataProfilePanel.this.highFormSocket("highFormSocket"));
            this.username = new RequiredTextField("username");
            this.add((Component)this.username);
            this.username.add((IValidator)new UsernameValidator());
            this.username.setLabel((IModel)new ResourceModel("data.auth.username", "Username"));
            this.add((Component)new SimpleFormComponentLabel("username-label", (LabeledWebMarkupContainer)this.username));
            this.password = new RSAPasswordTextField("password", (Form)this){

                public boolean isRequired() {
                    return !ProfileForm.this.existing();
                }
            };
            this.add((Component)this.password);
            this.password.setLabel((IModel)new ResourceModel("data.auth.password", "Password"));
            this.add((Component)new SimpleFormComponentLabel("password-label", (LabeledWebMarkupContainer)this.password));
            this.passwordConfirm = new RSAPasswordTextField("passwordConfirm", (IModel)new Model(), (Form)this){

                public boolean isRequired() {
                    return !ProfileForm.this.existing();
                }
            };
            this.add((Component)this.passwordConfirm);
            this.add((IFormValidator)new EqualPasswordConvertedInputValidator((FormComponent)this.password, (FormComponent)this.passwordConfirm));
            this.passwordConfirm.setLabel((IModel)new ResourceModel("data.auth.passwordConfirm", "Retype Password"));
            this.add((Component)new SimpleFormComponentLabel("passwordConfirm-label", (LabeledWebMarkupContainer)this.passwordConfirm));
            this.rememberMe = new CheckBox("rememberMe", (IModel)new Model((Serializable)Boolean.FALSE));
            this.add((Component)new WebMarkupContainer("rememberMeRow"){

                public boolean isVisible() {
                    return !ProfileForm.this.existing();
                }
            }.add((Component)this.rememberMe));
            this.add(DataProfilePanel.this.lowFormSocket("lowFormSocket"));
            this.add(new WebMarkupContainer("submit").add((IBehavior)new AttributeModifier("value", (IModel)new AbstractReadOnlyModel(){

                public Object getObject() {
                    return ProfileForm.this.existing() ? ProfileForm.this.getString("auth.data.update", null, "Update Account") : ProfileForm.this.getString("data.auth.register", null, "Register");
                }
            })));
        }

        protected void onSubmit() {
            super.onSubmit();
            DataSignInPage.getAuthSession().signIn(this.getUser(), (Boolean)this.rememberMe.getModelObject());
            if (DataProfilePanel.this.returnPage == null) {
                if (!this.continueToOriginalDestination()) {
                    this.setResponsePage(this.getApplication().getHomePage());
                }
            } else {
                this.setResponsePage(DataProfilePanel.this.returnPage.get());
            }
        }
    }
}

