/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.components;

import net.databinder.auth.IAuthSession;
import net.databinder.auth.IAuthSettings;
import net.databinder.auth.components.DataProfilePanel;
import net.databinder.auth.components.DataSignInPanel;
import net.databinder.auth.data.IUser;
import net.databinder.components.DataStyleLink;
import net.databinder.components.SourceList;
import net.databinder.models.HibernateObjectModel;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class DataSignInPage
extends WebPage {
    private SourceList sourceList;
    private Component profileSocket;
    private Component signinSocket;
    private SourceList.SourceLink profileLink;
    private SourceList.SourceLink signinLink;

    public DataSignInPage(PageParameters params) {
        this(params, null);
    }

    public DataSignInPage(ReturnPage returnPage) {
        this(null, returnPage);
    }

    public DataSignInPage(PageParameters params, ReturnPage returnPage) {
        IAuthSettings app = null;
        try {
            app = (IAuthSettings)Application.get();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (app == null || !app.getSignInPageClass().isInstance((Object)this)) {
            throw new UnauthorizedInstantiationException(DataSignInPage.class);
        }
        if (params != null) {
            String username = params.getString("username");
            String token = params.getString("token");
            if (username != null && token != null) {
                HibernateObjectModel userModel = new HibernateObjectModel(app.getUserClass(), app.getUserCriteriaBuilder(username));
                IUser.CookieAuth user = (IUser.CookieAuth)userModel.getObject();
                if (user != null && app.getToken(user).equals(token)) {
                    DataSignInPage.getAuthSession().signIn(user, true);
                }
                this.setResponsePage(((Application)app).getHomePage());
                this.setRedirect(true);
                return;
            }
        }
        this.add((Component)new Label("title", (IModel)new ResourceModel("data.auth.title.sign_in", "Please sign in")));
        this.add((Component)new DataStyleLink("dataStylesheet"));
        this.sourceList = new SourceList();
        this.profileSocket = this.profileSocket("profileSocket", returnPage);
        this.add(this.profileSocket);
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("profileLinkWrapper"){

            public boolean isVisible() {
                return DataSignInPage.this.profileLink.isEnabled();
            }
        };
        SourceList sourceList = this.sourceList;
        sourceList.getClass();
        this.profileLink = new SourceList.SourceLink(sourceList, "profileLink", this.profileSocket);
        this.add((Component)webMarkupContainer.add((Component)this.profileLink));
        this.signinSocket = this.signinSocket("signinSocket", returnPage);
        this.add(this.signinSocket);
        WebMarkupContainer webMarkupContainer2 = new WebMarkupContainer("signinLinkWrapper"){

            public boolean isVisible() {
                return DataSignInPage.this.signinLink.isEnabled();
            }
        };
        SourceList sourceList2 = this.sourceList;
        sourceList2.getClass();
        this.signinLink = new SourceList.SourceLink(sourceList2, "signinLink", this.signinSocket);
        this.add((Component)webMarkupContainer2.add((Component)this.signinLink));
        this.signinLink.onClick();
    }

    protected Component signinSocket(String id, ReturnPage returnPage) {
        return new DataSignInPanel(id, returnPage);
    }

    protected Component profileSocket(String id, ReturnPage returnPage) {
        return new DataProfilePanel(id, returnPage);
    }

    protected static IAuthSession getAuthSession() {
        return (IAuthSession)Session.get();
    }

    public static interface ReturnPage
    extends IClusterable {
        public Page get();
    }
}

