/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.components;

import java.io.Serializable;
import net.databinder.auth.components.DataSignInPage;
import net.databinder.auth.components.RSAPasswordTextField;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.SimpleFormComponentLabel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class DataSignInPanel
extends Panel {
    private DataSignInPage.ReturnPage returnPage;

    public DataSignInPanel(String id, DataSignInPage.ReturnPage returnPage) {
        super(id);
        this.returnPage = returnPage;
        this.add((Component)new FeedbackPanel("feedback"));
        this.add((Component)new SignInForm("signInForm"));
    }

    protected class SignInForm
    extends Form {
        private CheckBox rememberMe;
        private TextField username;
        private TextField password;

        protected SignInForm(String id) {
            super(id);
            this.username = new RequiredTextField("username", (IModel)new Model());
            this.add((Component)this.username);
            this.username.setLabel((IModel)new ResourceModel("data.auth.username", "Username"));
            this.add((Component)new SimpleFormComponentLabel("username-label", (LabeledWebMarkupContainer)this.username));
            this.password = new RSAPasswordTextField("password", (IModel)new Model(), this);
            this.add((Component)this.password);
            this.password.setLabel((IModel)new ResourceModel("data.auth.password", "Password"));
            this.add((Component)new SimpleFormComponentLabel("password-label", (LabeledWebMarkupContainer)this.password));
            this.rememberMe = new CheckBox("rememberMe", (IModel)new Model((Serializable)Boolean.FALSE));
            this.add((Component)this.rememberMe);
        }

        protected void onSubmit() {
            if (DataSignInPage.getAuthSession().signIn((String)this.username.getModelObject(), (String)this.password.getModelObject(), (Boolean)this.rememberMe.getModelObject())) {
                if (DataSignInPanel.this.returnPage == null) {
                    if (!this.continueToOriginalDestination()) {
                        this.setResponsePage(this.getApplication().getHomePage());
                    }
                } else {
                    this.setResponsePage(DataSignInPanel.this.returnPage.get());
                }
            } else {
                this.error((Serializable)((Object)this.getLocalizer().getString("signInFailed", (Component)this, "Sorry, these credentials are not recognized.")));
            }
        }
    }
}

