/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.components;

import net.databinder.auth.IAuthSession;
import net.databinder.auth.IAuthSettings;
import net.databinder.auth.components.DataProfilePage;
import net.databinder.auth.components.DataSignInPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class DataUserStatusPanel
extends Panel {
    public DataUserStatusPanel(String id) {
        super(id);
        WebMarkupContainer wrapper = new WebMarkupContainer("signedInWrapper"){

            public boolean isVisible() {
                return DataUserStatusPanel.this.getAuthSession().isSignedIn();
            }
        };
        this.add((Component)wrapper);
        wrapper.add((Component)new Label("username", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return DataUserStatusPanel.this.getAuthSession().getUser().toString();
            }
        }));
        wrapper.add((Component)new Link("profile"){

            public void onClick() {
                this.setResponsePage((Page)DataUserStatusPanel.this.profilePage());
            }
        });
        wrapper.add((Component)new Link("signOut"){

            public void onClick() {
                DataUserStatusPanel.this.getAuthSession().signOut();
                this.setResponsePage(this.getApplication().getHomePage());
            }
        });
        this.add((Component)this.getSignInLink("signIn"));
    }

    protected WebPage profilePage() {
        return new DataProfilePage(new DataSignInPage.ReturnPage(){

            public Page get() {
                return DataUserStatusPanel.this.getPage();
            }
        });
    }

    protected Link getSignInLink(String id) {
        return new Link(id){

            public void onClick() {
                this.redirectToInterceptPage(this.getPageFactory().newPage(((IAuthSettings)this.getApplication()).getSignInPageClass()));
            }

            public boolean isVisible() {
                return !DataUserStatusPanel.this.getAuthSession().isSignedIn();
            }
        };
    }

    protected IAuthSession getAuthSession() {
        return (IAuthSession)this.getSession();
    }
}

