/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.components;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.crypt.Base64;

public class RSAPasswordTextField
extends PasswordTextField
implements IHeaderContributor {
    private static final ResourceReference RSA_JS = new JavascriptResourceReference(RSAPasswordTextField.class, "RSA.js");
    private static final ResourceReference BARRETT_JS = new JavascriptResourceReference(RSAPasswordTextField.class, "Barrett.js");
    private static final ResourceReference BIGINT_JS = new JavascriptResourceReference(RSAPasswordTextField.class, "BigInt.js");
    private String challenge;
    private static KeyPair keypair;

    public RSAPasswordTextField(String id, Form form) {
        super(id);
        this.init(form);
    }

    public RSAPasswordTextField(String id, IModel model, Form form) {
        super(id, model);
        this.init(form);
    }

    protected void init(Form form) {
        this.setOutputMarkupId(true);
        form.add((IBehavior)new AttributeAppender("onsubmit", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                StringBuilder eventBuf = new StringBuilder();
                eventBuf.append("if (").append(RSAPasswordTextField.this.getElementValue()).append(" != null && ").append(RSAPasswordTextField.this.getElementValue()).append(" != '') ").append(RSAPasswordTextField.this.getElementValue()).append(" = encryptedString(key, ").append(RSAPasswordTextField.this.getChallengeVar()).append("+ '|' + ").append(RSAPasswordTextField.this.getElementValue()).append(");");
                return eventBuf.toString();
            }
        }, ""));
        this.challenge = new String(Base64.encodeBase64((byte[])BigInteger.valueOf(new SecureRandom().nextLong()).toByteArray()));
    }

    protected Object convertValue(String[] value) throws ConversionException {
        String enc = (String)super.convertValue(value);
        if (enc == null) {
            return null;
        }
        try {
            Cipher rsa = Cipher.getInstance("RSA");
            rsa.init(2, keypair.getPrivate());
            String dec = new String(rsa.doFinal(RSAPasswordTextField.hex2data(enc)));
            String[] toks = dec.split("\\|", 2);
            if (toks.length != 2 || !toks[0].equals(this.challenge)) {
                throw new ConversionException("incorrect or empy challenge value").setResourceKey("RSAPasswordTextField.failed.challenge");
            }
            return toks[1];
        }
        catch (GeneralSecurityException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(BIGINT_JS);
        response.renderJavascriptReference(BARRETT_JS);
        response.renderJavascriptReference(RSA_JS);
        RSAPublicKey pub = (RSAPublicKey)keypair.getPublic();
        StringBuilder keyBuf = new StringBuilder();
        keyBuf.append("setMaxDigits(131);\nvar key= new RSAKeyPair('").append(pub.getPublicExponent().toString(16)).append("', '', '").append(pub.getModulus().toString(16)).append("');");
        response.renderJavascript((CharSequence)keyBuf.toString(), "rsa_key");
        StringBuilder chalBuf = new StringBuilder();
        chalBuf.append("var ").append(this.getChallengeVar()).append(" = '").append(this.challenge).append("';");
        response.renderJavascript((CharSequence)chalBuf.toString(), null);
    }

    protected String getChallengeVar() {
        return this.getMarkupId() + "_challenge";
    }

    protected String getElementValue() {
        return "document.getElementById('" + this.getMarkupId() + "').value ";
    }

    private static final byte[] hex2data(String str) {
        if (str == null) {
            return new byte[0];
        }
        int len = str.length();
        char[] hex = str.toCharArray();
        byte[] buf = new byte[len / 2];
        for (int pos = 0; pos < len / 2; ++pos) {
            buf[pos] = (byte)(RSAPasswordTextField.toDataNibble(hex[2 * pos]) << 4 & 0xF0 | RSAPasswordTextField.toDataNibble(hex[2 * pos + 1]) & 0xF);
        }
        return buf;
    }

    private static byte toDataNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)((byte)c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (byte)((byte)c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (byte)((byte)c - 65 + 10);
        }
        return -1;
    }

    static {
        try {
            keypair = KeyPairGenerator.getInstance("RSA").genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WicketRuntimeException("Can't find RSA provider", (Throwable)e);
        }
    }
}

