/*
 * Decompiled with CFR 0.152.
 */
package net.databinder.auth.data;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.persistence.Transient;
import net.databinder.auth.IAuthSettings;
import net.databinder.auth.data.IUser;
import org.apache.wicket.Application;
import org.apache.wicket.authorization.strategies.role.Roles;
import org.apache.wicket.util.crypt.Base64;
import org.apache.wicket.util.crypt.Base64UrlSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserBase
implements IUser.CookieAuth,
Serializable {
    public abstract Set<String> getRoles();

    public abstract String getPasswordHash();

    @Override
    public abstract String getUsername();

    @Override
    public boolean hasAnyRole(Roles validRoles) {
        for (String role : this.getRoles()) {
            if (!validRoles.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    protected static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA Hash algorithm not found.", e);
        }
    }

    @Override
    @Transient
    public String getToken(String location) {
        MessageDigest md = UserBase.getMessageDigest();
        md.update(((IAuthSettings)Application.get()).getSalt());
        md.update(this.getPasswordHash().getBytes());
        md.update(location.getBytes());
        byte[] hash = md.digest(this.getUsername().getBytes());
        return new String(Base64UrlSafe.encodeBase64((byte[])hash));
    }

    public static String getHash(String password) {
        MessageDigest md = UserBase.getMessageDigest();
        md.update(((IAuthSettings)Application.get()).getSalt());
        byte[] hash = md.digest(password.getBytes());
        return new String(Base64.encodeBase64((byte[])hash));
    }
}

