/*
 * Decompiled with CFR 0.152.
 */
package net.deechael.chschar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.deechael.chschar.ChineseCharacter;
import net.deechael.chschar.ChineseCharacterBuilder;
import net.deechael.chschar.Phoneticization;
import net.deechael.chschar.Tone;
import org.jetbrains.annotations.NotNull;

public final class ChineseCharacterLibrary {
    static final Map<Character, ChineseCharacter> characters = new HashMap<Character, ChineseCharacter>();

    @NotNull
    public static ChineseCharacter get(char c) {
        if (!characters.containsKey(Character.valueOf(c))) {
            throw new RuntimeException("Character \"" + c + "\" is not a Chinese character");
        }
        return characters.get(Character.valueOf(c));
    }

    public static boolean has(char c) {
        return characters.containsKey(Character.valueOf(c));
    }

    public static int getSupported() {
        return characters.size();
    }

    private ChineseCharacterLibrary() {
    }

    static {
        InputStream inputStream = ChineseCharacterLibrary.class.getClassLoader().getResourceAsStream("pinyins.txt");
        if (inputStream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            List lines = reader.lines().collect(Collectors.toList());
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String line : lines) {
                if (!line.contains(" ")) continue;
                String[] splitA = line.split(" ");
                char character = (char)Integer.parseInt(splitA[0], 16);
                String splitA1 = splitA[1];
                String spiltA1R = splitA1.substring(1, splitA1.length() - 1);
                String[] pronunciations = spiltA1R.contains(",") ? spiltA1R.split(",") : new String[]{spiltA1R};
                ChineseCharacterBuilder builder = ChineseCharacterBuilder.builder();
                builder.initialize(character);
                for (String pronunciation : pronunciations) {
                    Tone t;
                    String phoneticization = pronunciation.substring(0, pronunciation.length() - 1).replace("u:", "v").replace("^", "");
                    if (phoneticization.equalsIgnoreCase("none")) continue;
                    String tone = pronunciation.substring(pronunciation.length() - 1);
                    Phoneticization p = Phoneticization.valueOf(phoneticization.toUpperCase());
                    switch (Integer.parseInt(tone)) {
                        case 1: {
                            t = Tone.LEVEL;
                            break;
                        }
                        case 2: {
                            t = Tone.RISING;
                            break;
                        }
                        case 3: {
                            t = Tone.FALLING_RISING;
                            break;
                        }
                        case 4: {
                            t = Tone.FALLING;
                            break;
                        }
                        default: {
                            t = Tone.SOFT;
                        }
                    }
                    builder.pronunciation(p, t);
                }
                characters.put(Character.valueOf(character), builder.build());
            }
        }
        characters.put(Character.valueOf('\u3400'), ChineseCharacterBuilder.builder().initialize('\u3400').pronunciation(Phoneticization.QIU, Tone.LEVEL).build());
        characters.put(Character.valueOf('\u3401'), ChineseCharacterBuilder.builder().initialize('\u3401').pronunciation(Phoneticization.TIAN, Tone.FALLING_RISING).pronunciation(Phoneticization.TIAN, Tone.FALLING).build());
        characters.put(Character.valueOf('\u3402'), ChineseCharacterBuilder.builder().initialize('\u3402').pronunciation(Phoneticization.XI, Tone.FALLING_RISING).build());
        characters.put(Character.valueOf('\u3404'), ChineseCharacterBuilder.builder().initialize('\u3404').pronunciation(Phoneticization.KUA, Tone.FALLING).build());
        characters.put(Character.valueOf('\u3405'), ChineseCharacterBuilder.builder().initialize('\u3405').pronunciation(Phoneticization.WU, Tone.FALLING_RISING).build());
        characters.put(Character.valueOf('\u3406'), ChineseCharacterBuilder.builder().initialize('\u3406').pronunciation(Phoneticization.YIN, Tone.FALLING_RISING).pronunciation(Phoneticization.YI, Tone.LEVEL).build());
        characters.put(Character.valueOf('\u3407'), ChineseCharacterBuilder.builder().initialize('\u3407').pronunciation(Phoneticization.JIU, Tone.FALLING_RISING).build());
        characters.put(Character.valueOf('\u3408'), ChineseCharacterBuilder.builder().initialize('\u3408').pronunciation(Phoneticization.RU, Tone.FALLING).build());
        characters.put(Character.valueOf('\u3409'), ChineseCharacterBuilder.builder().initialize('\u3409').pronunciation(Phoneticization.DING, Tone.LEVEL).build());
        characters.put(Character.valueOf('\u340a'), ChineseCharacterBuilder.builder().initialize('\u340a').pronunciation(Phoneticization.SHI, Tone.FALLING).build());
        characters.put(Character.valueOf('\u340b'), ChineseCharacterBuilder.builder().initialize('\u340b').pronunciation(Phoneticization.TU, Tone.FALLING_RISING).build());
    }
}

