/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.deelam.graphtools.GraphRecordEdge;
import net.deelam.graphtools.GraphRecordElement;
import net.deelam.graphtools.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphRecord
extends GraphRecordElement
implements Vertex,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(GraphRecord.class);
    private static final long serialVersionUID = 201508251201L;
    private static String NODE_TYPE_KEY = "_type";
    private static int SUPERNODE_THRESHOLD = 100000;
    protected Map<String, Edge> inEdges = new HashMap<String, Edge>();
    protected Map<String, Edge> outEdges = new HashMap<String, Edge>();

    public static String getType(Vertex v) {
        return (String)v.getProperty(NODE_TYPE_KEY);
    }

    public String getType() {
        return GraphRecord.getType(this);
    }

    public GraphRecord(String strId) {
        super(strId);
    }

    public GraphRecord(String strId, String nodeType) {
        super(strId);
        this.setProperty(NODE_TYPE_KEY, nodeType);
    }

    public GraphRecordEdge getInEdge(String edgeId) {
        return (GraphRecordEdge)this.inEdges.get(edgeId);
    }

    public GraphRecordEdge getOutEdge(String edgeId) {
        return (GraphRecordEdge)this.outEdges.get(edgeId);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Edge addEdge(String label, Vertex inVertex) {
        GraphRecordEdge edge = new GraphRecordEdge(label, this, inVertex);
        this.outEdges.put(edge.getStringId(), edge);
        return edge;
    }

    public void addEdge(GraphRecordEdge edge) {
        boolean valid = false;
        if (edge.getVertex(Direction.IN).equals(this)) {
            valid = true;
            if (this.inEdges.get(edge.getStringId()) != null) {
                new RuntimeException("InEdge already exists with id=" + edge.getStringId()).printStackTrace();
            }
            this.inEdges.put(edge.getStringId(), edge);
            if (this.inEdges.size() % SUPERNODE_THRESHOLD == 0) {
                log.warn("Vertex id={} has at least {} in-edges!", this.getId(), (Object)this.inEdges.size());
            }
        }
        if (edge.getVertex(Direction.OUT).equals(this)) {
            valid = true;
            if (this.outEdges.get(edge.getStringId()) != null) {
                new RuntimeException("OutEdge already exists with id=" + edge.getStringId()).printStackTrace();
            }
            this.outEdges.put(edge.getStringId(), edge);
            if (this.outEdges.size() % SUPERNODE_THRESHOLD == 0) {
                log.warn("Vertex id={} has at least {} out-edges!", this.getId(), (Object)this.outEdges.size());
            }
        }
        if (!valid) {
            log.error("Edge does not connect to this vertex=" + this + ": edge: outV=" + edge.getVertex(Direction.OUT) + " inV=" + edge.getVertex(Direction.IN) + " " + GraphUtils.toString(edge));
        }
    }

    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        HashSet<String> labelSet = new HashSet<String>(Arrays.asList(labels));
        if (direction == Direction.IN) {
            return this.filterEdges(this.inEdges.values(), labelSet);
        }
        if (direction == Direction.OUT) {
            return this.filterEdges(this.outEdges.values(), labelSet);
        }
        ArrayList<Edge> bothEs = new ArrayList<Edge>();
        Iterable<Edge> inE = this.filterEdges(this.inEdges.values(), labelSet);
        Iterables.addAll(bothEs, inE);
        Iterable<Edge> outE = this.filterEdges(this.outEdges.values(), labelSet);
        Iterables.addAll(bothEs, outE);
        return bothEs;
    }

    Iterable<Edge> filterEdges(Collection<Edge> edges, Set<String> labelSet) {
        ArrayList<Edge> filteredEdges = new ArrayList<Edge>(edges.size());
        for (Edge e : edges) {
            if (labelSet.size() > 0 && !labelSet.contains(e.getLabel())) continue;
            filteredEdges.add(e);
        }
        return Iterables.unmodifiableIterable(filteredEdges);
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        Direction oppDir = GraphRecord.getOppositeDirection(direction);
        ArrayList<Vertex> otherVs = new ArrayList<Vertex>();
        for (Edge e : this.getEdges(direction, labels)) {
            if (oppDir == null) {
                Vertex inV = e.getVertex(Direction.IN);
                if (!inV.equals(this)) {
                    otherVs.add(inV);
                    continue;
                }
                otherVs.add(e.getVertex(Direction.OUT));
                continue;
            }
            otherVs.add(e.getVertex(oppDir));
        }
        return Iterables.unmodifiableIterable(otherVs);
    }

    public static Direction getOppositeDirection(Direction direction) {
        if (direction == Direction.IN) {
            return Direction.OUT;
        }
        if (direction == Direction.OUT) {
            return Direction.IN;
        }
        return null;
    }

    public VertexQuery query() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "GraphRecord[" + super.toString() + ",outEdges=" + this.outEdges.size() + " inEdges=" + this.inEdges.size() + "]";
    }

    public void setLongId(long id) {
        this.setProperty(LONG_ID_PROPKEY, id);
    }

    public Long getLongId() {
        return (Long)this.getProperty(LONG_ID_PROPKEY);
    }

    public GraphRecord() {
    }

    public static void setNODE_TYPE_KEY(String NODE_TYPE_KEY) {
        GraphRecord.NODE_TYPE_KEY = NODE_TYPE_KEY;
    }

    public static void setSUPERNODE_THRESHOLD(int SUPERNODE_THRESHOLD) {
        GraphRecord.SUPERNODE_THRESHOLD = SUPERNODE_THRESHOLD;
    }

    public Map<String, Edge> getInEdges() {
        return this.inEdges;
    }

    public Map<String, Edge> getOutEdges() {
        return this.outEdges;
    }
}

