/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.google.common.base.Preconditions;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import java.util.concurrent.atomic.AtomicBoolean;
import net.deelam.graphtools.GraphUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTransaction {
    private static final Logger log = LoggerFactory.getLogger(GraphTransaction.class);
    protected static final ThreadLocal<TransactionalGraph> graphHolder = new ThreadLocal();
    protected static final ThreadLocal<MutableInt> nestingCounter = new ThreadLocal<MutableInt>(){

        @Override
        protected MutableInt initialValue() {
            return new MutableInt(0);
        }
    };
    protected static final ThreadLocal<AtomicBoolean> rollbackCalled = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    public static int begin(TransactionalGraph currGraph) {
        Preconditions.checkNotNull((Object)currGraph);
        TransactionalGraph g = graphHolder.get();
        if (g == null) {
            currGraph.commit();
            graphHolder.set(currGraph);
            nestingCounter.get().increment();
            return nestingCounter.get().intValue();
        }
        if (g == currGraph) {
            nestingCounter.get().increment();
            return nestingCounter.get().intValue();
        }
        if (GraphUtils.isWrappedWithin((Graph)g, (Graph)currGraph)) {
            nestingCounter.get().increment();
            return nestingCounter.get().intValue();
        }
        log.error("This transaction only supports working with one graph ({}) at a time: {}\n   Or maybe you forgot to commit() or rollback() the previous transaction?", (Object)g, (Object)currGraph);
        throw new IllegalArgumentException("This transaction only supports working with one graph at a time: Expecting " + g + " but got " + currGraph + ".  The second graph is not equal to or nested in the first graph.  Also make sure there is a commit() for every begin().");
    }

    public static boolean rollback(int tx) {
        GraphTransaction.updateNestingDepth(tx);
        if (!rollbackCalled.get().get()) {
            rollbackCalled.get().set(true);
        }
        if (GraphTransaction.isOuterMostTransaction()) {
            GraphTransaction.endTransaction();
            return true;
        }
        return false;
    }

    private static void updateNestingDepth(int depth) {
        if (depth < nestingCounter.get().intValue()) {
            log.warn("Transaction depth mismatch: expected {} but got {}.  This can occur if you called rollback.  Readjusting depth.\n   Did you forget to catch an exception and call rollback?", (Object)nestingCounter.get().intValue(), (Object)depth);
            nestingCounter.get().setValue(depth - 1);
        } else {
            nestingCounter.get().decrement();
        }
    }

    public static boolean commit(int tx) {
        GraphTransaction.updateNestingDepth(tx);
        if (GraphTransaction.isOuterMostTransaction()) {
            return GraphTransaction.endTransaction();
        }
        log.trace("Depth={}, Not yet committing transaction on graph: {}", (Object)nestingCounter.get(), (Object)graphHolder.get());
        return false;
    }

    public static boolean isInTransaction() {
        return graphHolder.get() != null;
    }

    public static boolean isOuterMostTransaction() {
        return nestingCounter.get().intValue() == 0;
    }

    public static void checkTransactionsClosed() {
        Preconditions.checkState((!GraphTransaction.isInTransaction() ? 1 : 0) != 0);
    }

    private static boolean endTransaction() {
        nestingCounter.remove();
        if (rollbackCalled.get().get()) {
            rollbackCalled.remove();
            log.warn("Rolling back outer-most transaction on graph: {}", (Object)graphHolder.get());
            graphHolder.get().rollback();
            graphHolder.remove();
            return false;
        }
        rollbackCalled.remove();
        log.debug("Committing outer-most transaction on graph: {}", (Object)graphHolder.get());
        graphHolder.get().commit();
        graphHolder.remove();
        return true;
    }
}

