/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.google.common.base.Preconditions;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.deelam.graphtools.GraphUtils;
import net.deelam.graphtools.IdGraphFactory;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUri {
    private static final Logger log = LoggerFactory.getLogger(GraphUri.class);
    private static final String URI_PATH = "_uriPath";
    public static final String URI_SCHEMA_PART = "_uriSchemaSpecificPart";
    private final String scheme;
    private final URI baseUri;
    private Configuration config;
    private static Map<String, IdGraphFactory> graphFtry = new HashMap<String, IdGraphFactory>(5);

    public GraphUri(String uri) {
        this(uri, (Configuration)new BaseConfiguration());
    }

    public GraphUri(String uri, Configuration config) {
        int colonIndx = uri.indexOf(58);
        Preconditions.checkState((colonIndx > 0 ? 1 : 0) != 0, (Object)"Expecting something like 'tinker:'");
        this.scheme = uri.substring(0, colonIndx);
        this.baseUri = URI.create(uri.substring(colonIndx + 1));
        this.config = config;
        this.parseUriPath(this.baseUri);
    }

    public IdGraph openIdGraph() {
        return this.openIdGraph(KeyIndexableGraph.class);
    }

    public IdGraph openExistingIdGraph() throws FileNotFoundException {
        IdGraphFactory factory = graphFtry.get(this.scheme);
        Preconditions.checkNotNull((Object)factory, (Object)("Unknown schema: " + this.scheme));
        if (factory.exists(this)) {
            return this.openIdGraph(KeyIndexableGraph.class);
        }
        throw new FileNotFoundException("Graph not found at " + this.getUriPath());
    }

    public IdGraph createNewIdGraph(boolean deleteExisting) throws IOException {
        IdGraphFactory factory = graphFtry.get(this.scheme);
        Preconditions.checkNotNull((Object)factory, (Object)("Unknown schema: " + this.scheme));
        if (factory.exists(this)) {
            if (deleteExisting) {
                factory.delete(this);
            } else {
                throw new FileAlreadyExistsException("Graph exists at: " + this.getUriPath());
            }
        }
        IdGraph<KeyIndexableGraph> graph = this.openIdGraph(KeyIndexableGraph.class);
        return graph;
    }

    public <T extends KeyIndexableGraph> IdGraph<T> openIdGraph(Class<T> baseGraphClass) {
        IdGraphFactory factory = graphFtry.get(this.scheme);
        Preconditions.checkNotNull((Object)factory, (Object)("Unknown schema: " + this.scheme));
        if (this.config == null) {
            this.config = new BaseConfiguration();
        }
        this.config.setProperty(URI_SCHEMA_PART, (Object)this.baseUri.getSchemeSpecificPart());
        this.parseQuery(this.baseUri.toString());
        IdGraph graph = factory.open(this);
        log.info("Opened graph=" + graph);
        GraphUtils.addMetaDataNode(this, graph);
        return graph;
    }

    public static void printConfig(Configuration conf) {
        Iterator itr = conf.getKeys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            System.out.println(key + "=" + conf.getString(key));
        }
    }

    private void parseUriPath(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return;
        }
        Preconditions.checkNotNull((Object)path);
        if (path.length() > 1 && path.charAt(1) == '.') {
            path = path.substring(1);
        }
        this.config.setProperty(URI_PATH, (Object)path);
    }

    private void parseQuery(String uriStr) {
        int queryIndx = uriStr.indexOf(63);
        if (queryIndx < 0) {
            return;
        }
        String queryStr = uriStr.substring(queryIndx + 1);
        if (queryStr != null) {
            for (String kv : queryStr.split("&")) {
                String[] pair = kv.split("=");
                this.config.setProperty(pair[0], (Object)pair[1]);
            }
        }
    }

    public static void register(String scheme, IdGraphFactory factory) {
        graphFtry.put(scheme, factory);
    }

    public URI getUri() {
        return this.baseUri;
    }

    public String getUriPath() {
        return this.getConfig().getString(URI_PATH);
    }

    public String[] getVertexTypes() {
        String[] types = new String[]{};
        return types;
    }

    public String[] getEdgeLabels() {
        String[] labels = new String[]{};
        return labels;
    }

    @ConstructorProperties(value={"scheme", "baseUri"})
    public GraphUri(String scheme, URI baseUri) {
        this.scheme = scheme;
        this.baseUri = baseUri;
    }

    public String toString() {
        return "GraphUri(scheme=" + this.scheme + ", baseUri=" + this.baseUri + ", config=" + this.getConfig() + ")";
    }

    public Configuration getConfig() {
        return this.config;
    }
}

