/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.util.Date;
import net.deelam.graphtools.GraphTransaction;
import net.deelam.graphtools.GraphUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphUtils.class);
    private static final String METADATA_VERTEXID = "_GRAPH_METADATA_";
    private static final String TIMESTAMP_PROP = "_GRAPHURI_";
    private static final String GRAPHURI_PROP = "_GRAPHURI_";
    private static final String VERTEXTYPES_PROP = "_VERTEXTYPES_";
    private static final String EDGELABELS_PROP = "_EDGELABELS_";

    public static boolean hasSameEndpoints(Edge e, Edge e2) {
        Vertex outV = e2.getVertex(Direction.OUT);
        Vertex inV = e2.getVertex(Direction.IN);
        return GraphUtils.hasEndpoints(e2, outV, inV);
    }

    public static boolean hasEndpoints(Edge e, Vertex outV, Vertex inV) {
        Vertex outV1 = e.getVertex(Direction.OUT);
        Vertex inV1 = e.getVertex(Direction.IN);
        boolean equalsEndpoints = true;
        if (!outV1.equals(outV)) {
            log.error("outVertex not equal: " + outV1 + "!=" + outV);
            equalsEndpoints = false;
        }
        if (!inV1.equals(inV)) {
            log.error("inVertex not equal: " + inV1 + "!=" + inV);
            equalsEndpoints = false;
        }
        return equalsEndpoints;
    }

    public static long getNodeCount(Graph graph) {
        return Iterables.size((Iterable)graph.getVertices());
    }

    public static long getEdgeCount(Graph graph) {
        return Iterables.size((Iterable)graph.getEdges());
    }

    public static String count(Graph graph) {
        StringBuilder sb = new StringBuilder(graph.toString());
        sb.append(": ");
        sb.append(GraphUtils.getNodeCount(graph)).append(" nodes, ");
        sb.append(GraphUtils.getEdgeCount(graph)).append(" edges");
        return sb.toString();
    }

    public static String toString(Graph graph) {
        return GraphUtils.toString(graph, -1);
    }

    public static String toString(Graph graph, int numSamples) {
        return GraphUtils.toString(graph, numSamples, (String[])null);
    }

    public static String toString(Graph graph, int numSamples, String ... propsToPrint) {
        StringBuilder sb = new StringBuilder(graph.toString());
        sb.append("\n Nodes:\n");
        int nodeCount = 0;
        for (Vertex n : graph.getVertices()) {
            if (numSamples >= 0 && ++nodeCount >= numSamples) continue;
            sb.append("  ").append(n.getId()).append(": ");
            sb.append(n.getPropertyKeys());
            sb.append("\n    ").append(GraphUtils.toString((Element)n, "\n    ", propsToPrint)).append("\n");
        }
        sb.append(" Edges:\n");
        int edgeCount = 0;
        for (Edge e : graph.getEdges()) {
            ++edgeCount;
            if (numSamples >= 0 && nodeCount >= numSamples) continue;
            sb.append("  ").append(e.getLabel()).append(" ").append(e.getId()).append(" (");
            sb.append(e.getVertex(Direction.OUT)).append("->").append(e.getVertex(Direction.IN));
            sb.append("): ");
            sb.append(e.getPropertyKeys());
            sb.append("\n    ").append(GraphUtils.toString((Element)e, "\n    ", propsToPrint)).append("\n");
        }
        sb.append("(").append(nodeCount).append(" nodes, ").append(edgeCount).append(" edges)");
        return sb.toString();
    }

    public static String toString(Element n, String delim, String ... propsToPrint) {
        StringBuilder sb = new StringBuilder();
        if (propsToPrint != null) {
            if (propsToPrint.length == 0) {
                propsToPrint = n.getPropertyKeys().toArray(propsToPrint);
            }
            boolean first = true;
            for (String propKey : propsToPrint) {
                if (n.getProperty(propKey) == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(delim);
                }
                sb.append(propKey).append("=").append(n.getProperty(propKey));
            }
        }
        return sb.toString();
    }

    public static String toString(Element n, String delim, boolean printId) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (printId) {
            sb.append("id=").append(n.getId());
            first = false;
        }
        for (String propKey : n.getPropertyKeys()) {
            if (n.getProperty(propKey) == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(propKey).append("=").append(n.getProperty(propKey));
        }
        return sb.toString();
    }

    public static String toString(Element n) {
        return "\n\t" + (n instanceof Edge ? ((Edge)n).getLabel() + "\n\t" : "") + GraphUtils.toString(n, "\n\t", true);
    }

    public static String toString(Iterable<? extends Element> elems) {
        StringBuilder sb = new StringBuilder();
        for (Element element : elems) {
            sb.append("\n\t").append(GraphUtils.toString(element, "\n\t", true));
        }
        return sb.toString();
    }

    public static boolean isWrappedWithin(Graph g, Graph currGraph) {
        while (g instanceof WrapperGraph) {
            if ((g = ((WrapperGraph)g).getBaseGraph()) != currGraph) continue;
            return true;
        }
        return false;
    }

    public static <T extends Graph> T unwrapToGraphType(Class<T> clazz, Graph g) {
        if (clazz.isInstance(g)) {
            return (T)g;
        }
        while (g instanceof WrapperGraph) {
            if (!clazz.isInstance(g = ((WrapperGraph)g).getBaseGraph())) continue;
            return (T)g;
        }
        return null;
    }

    public static void clearGraph(Graph graph) {
        Preconditions.checkNotNull((Object)graph);
        for (Edge e : graph.getEdges()) {
            graph.removeEdge(e);
        }
        for (Vertex v : graph.getVertices()) {
            graph.removeVertex(v);
        }
    }

    public static void clearGraph(TransactionalGraph graph) {
        Preconditions.checkNotNull((Object)graph);
        int tx = GraphTransaction.begin(graph);
        try {
            for (Edge e : graph.getEdges()) {
                graph.removeEdge(e);
            }
            for (Vertex v : graph.getVertices()) {
                graph.removeVertex(v);
            }
            GraphTransaction.commit(tx);
        }
        catch (RuntimeException re) {
            GraphTransaction.rollback(tx);
            throw re;
        }
    }

    public static void addMetaDataNode(GraphUri gUri, IdGraph<?> graph) {
        Vertex mdV = graph.getVertex((Object)METADATA_VERTEXID);
        if (mdV == null) {
            mdV = graph.addVertex((Object)METADATA_VERTEXID);
            mdV.setProperty("_GRAPHURI_", (Object)new Date().toString());
            mdV.setProperty("_GRAPHURI_", (Object)gUri.toString());
        }
    }
}

