/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools.graphfactories;

import com.google.common.collect.Iterators;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import net.deelam.graphtools.GraphUri;
import net.deelam.graphtools.IdGraphFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGraphFactoryOrientdb
implements IdGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(IdGraphFactoryOrientdb.class);
    private static final String CONFIG_PREFIX = "blueprints.orientdb.";

    public static void register() {
        GraphUri.register("orientdb", new IdGraphFactoryOrientdb());
    }

    public IdGraph<OrientGraph> open(GraphUri gUri) {
        String[] keys;
        Configuration conf = gUri.getConfig();
        for (String key : keys = (String[])Iterators.toArray((Iterator)conf.getKeys(), String.class)) {
            if (key.startsWith(CONFIG_PREFIX)) continue;
            conf.setProperty(CONFIG_PREFIX + key, conf.getProperty(key));
        }
        this.setDefaultAuthentication(conf);
        URI uri = gUri.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("Provide a URI like so: plocal:/tmp/.., remote:localhost/tinkpop, memory:tinkpop");
        }
        log.info("Opening OrientDB graph at URI=" + uri);
        conf.setProperty("blueprints.orientdb.url", (Object)uri.toString());
        IdGraph graph = new IdGraph((KeyIndexableGraph)new OrientGraph(conf));
        return graph;
    }

    private void setDefaultAuthentication(Configuration conf) {
        String pwd;
        String username = conf.getString("blueprints.orientdb.username");
        if (username == null) {
            log.info("Using default OrientDB username");
            conf.setProperty("blueprints.orientdb.username", (Object)"admin");
        }
        if ((pwd = conf.getString("blueprints.orientdb.password")) == null) {
            log.info("Using default OrientDB password");
            conf.setProperty("blueprints.orientdb.password", (Object)"admin");
        }
    }

    private DB_TYPE getDBType(GraphUri gUri) {
        URI uri = gUri.getUri();
        return DB_TYPE.valueOf(uri.getScheme());
    }

    @Override
    public void delete(GraphUri gUri) throws IOException {
        DB_TYPE dbType = this.getDBType(gUri);
        if (dbType == DB_TYPE.plocal) {
            File pathFile = new File(gUri.getUri().getSchemeSpecificPart());
            log.info("Deleting OrientDB at {}", (Object)pathFile);
            FileUtils.deleteDirectory((File)pathFile);
        }
    }

    @Override
    public boolean exists(GraphUri gUri) {
        DB_TYPE dbType = this.getDBType(gUri);
        if (dbType == DB_TYPE.plocal) {
            File pathFile = new File(gUri.getUri().getSchemeSpecificPart());
            return pathFile.exists();
        }
        return false;
    }

    static enum DB_TYPE {
        plocal,
        memory,
        remote;

    }
}

