/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.utils.test;

import java.util.function.Supplier;
import org.junit.Assert;

public class ConditionPoll {
    public static final long baseTimeoutMillis = 20000L;

    public static <T> boolean poll(long timeoutMillis, T userObject, Condition<T> condition) throws InterruptedException {
        boolean conditionMet = condition.conditionMet(userObject);
        long endTime = System.currentTimeMillis() + timeoutMillis;
        while (endTime > System.currentTimeMillis() && !conditionMet) {
            Thread.sleep(10L);
            conditionMet = condition.conditionMet(userObject);
        }
        return conditionMet;
    }

    public static <T> boolean poll(T userObject, Condition<T> condition) throws InterruptedException {
        return ConditionPoll.poll(20000L, userObject, condition);
    }

    public static <T> boolean qpoll(T userObject, Condition<T> condition) {
        try {
            return ConditionPoll.poll(20000L, userObject, condition);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean poll(Condition condition) throws InterruptedException {
        return ConditionPoll.poll(20000L, null, condition);
    }

    public static void assertTrue(Supplier<String> errMessage, boolean value) {
        Assert.assertTrue((String)(value ? "" : errMessage.get()), (boolean)value);
    }

    @FunctionalInterface
    public static interface Condition<T> {
        public boolean conditionMet(T var1);
    }
}

