/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.utils.test;

import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class SocketTimeout
implements Runnable {
    private final Socket socket;
    private final long timeoutMillis;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private Thread thread = null;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private boolean disrupted = false;
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public SocketTimeout(Socket socket, long timeoutMillis) {
        this.socket = socket;
        this.timeoutMillis = timeoutMillis;
        this.thread = Thread.currentThread();
        scheduler.schedule(this, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void begin() {
        this.startTime.set(System.currentTimeMillis());
    }

    public void end() {
        this.startTime.set(0L);
    }

    public void stop() {
        this.done.set(true);
    }

    @Override
    public void run() {
        if (this.done.get()) {
            return;
        }
        long b = this.startTime.get();
        if (b != 0L && System.currentTimeMillis() - b > this.timeoutMillis) {
            this.disrupt();
        } else {
            long nextTimeout;
            long l = nextTimeout = b == 0L ? this.timeoutMillis : System.currentTimeMillis() - b;
            if (nextTimeout < 0L) {
                nextTimeout = 1L;
            }
            scheduler.schedule(this, nextTimeout + 1L, TimeUnit.MILLISECONDS);
        }
    }

    public void disrupt() {
        try {
            this.thread.interrupt();
        }
        catch (Throwable th) {
            System.err.println("Interrupt failed." + th);
            th.printStackTrace(System.err);
        }
        try {
            this.socket.close();
        }
        catch (Throwable th) {
            System.err.println("Couldn't close socket." + th);
            th.printStackTrace(System.err);
        }
        this.disrupted = true;
    }

    public boolean disrupted() {
        boolean ret = this.disrupted;
        this.disrupted = false;
        return ret;
    }

    static {
        scheduler.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Static SocketTimeout Schedule");
            }
        });
    }
}

