/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.utils.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.IntStream;

public class SystemPropertyManager
implements AutoCloseable {
    private final List<OldProperty> oldProperties = new ArrayList<OldProperty>();

    public SystemPropertyManager set(String name, String value) {
        this.oldProperties.add(new OldProperty(name, System.getProperties().containsKey(name), System.getProperty(name)));
        System.setProperty(name, value);
        return this;
    }

    public SystemPropertyManager setIfAbsent(String name, String value) {
        return System.getProperties().containsKey(name) ? this : this.set(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SystemPropertyManager load(String file) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            props.load(fis);
            props.entrySet().stream().forEach(e -> this.set((String)e.getKey(), (String)e.getValue()));
            SystemPropertyManager systemPropertyManager = this;
            return systemPropertyManager;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void close() {
        int num = this.oldProperties.size();
        IntStream.range(0, num).forEach(i -> SystemPropertyManager.revert(this.oldProperties.get(num - i - 1)));
    }

    private static void revert(OldProperty op) {
        if (op.hasOldValue) {
            System.setProperty(op.name, op.oldValue);
        } else {
            System.clearProperty(op.name);
        }
    }

    private static class OldProperty {
        public final boolean hasOldValue;
        public final String oldValue;
        public final String name;

        public OldProperty(String name, boolean hasOldValue, String oldValue) {
            this.hasOldValue = hasOldValue;
            this.oldValue = oldValue;
            this.name = name;
        }
    }
}

