/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import net.derquinse.common.base.Builder;

@Beta
public final class ByteString
implements Serializable {
    private static final long serialVersionUID = 5380545035055097521L;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] bytes;
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private volatile int hash = 0;

    private ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        byte[] copy = new byte[size];
        System.arraycopy(bytes, offset, copy, 0, size);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    public static ByteString copyFrom(ByteBuffer bytes, int size) {
        byte[] copy = new byte[size];
        bytes.get(copy);
        return new ByteString(copy);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        return ByteString.copyFrom(bytes, bytes.remaining());
    }

    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return new ByteString(text.getBytes(charsetName));
    }

    public static ByteString copyFrom(String text, Charset charset) throws UnsupportedEncodingException {
        return new ByteString(text.getBytes(charset.name()));
    }

    public static ByteString copyFromUtf8(String text) {
        try {
            return ByteString.copyFrom(text, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public static ByteString copyFrom(List<ByteString> list) {
        if (list.size() == 0) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int size = 0;
        for (ByteString str : list) {
            size += str.size();
        }
        byte[] bytes = new byte[size];
        int pos = 0;
        for (ByteString str : list) {
            System.arraycopy(str.bytes, 0, bytes, pos, str.size());
            pos += str.size();
        }
        return new ByteString(bytes);
    }

    public static ByteString fromHexChars(char[] data) {
        int len = data.length;
        Preconditions.checkArgument(((len & 1) == 0 ? 1 : 0) != 0, (Object)"Odd number of characters.");
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = ByteString.toDigit(data[j], j) << 4;
            f |= ByteString.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return new ByteString(out);
    }

    public static ByteString fromHexString(String data) {
        return ByteString.fromHexChars(data.toCharArray());
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    public void copyTo(byte[] target, int sourceOffset, int targetOffset, int size) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, size);
    }

    public void copyTo(ByteBuffer target) {
        target.put(this.bytes, 0, this.bytes.length);
    }

    public byte[] toByteArray() {
        int size = this.bytes.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.bytes, 0, copy, 0, size);
        return copy;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.bytes, charsetName);
    }

    public String toStringUtf8() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public String toHexString(boolean lowercase) {
        return this.toHexString(lowercase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public String toHexString() {
        return this.toHexString(true);
    }

    private String toHexString(char[] toDigits) {
        int length = 2 * this.bytes.length;
        StringBuilder b = new StringBuilder(length);
        for (int i = 0; i < this.bytes.length; ++i) {
            b.append(toDigits[(0xF0 & this.bytes[i]) >>> 4]);
            b.append(toDigits[0xF & this.bytes[i]]);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)o;
        int size = this.bytes.length;
        if (size != other.bytes.length) {
            return false;
        }
        byte[] thisBytes = this.bytes;
        byte[] otherBytes = other.bytes;
        for (int i = 0; i < size; ++i) {
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int size;
            byte[] thisBytes = this.bytes;
            h = size = this.bytes.length;
            for (int i = 0; i < size; ++i) {
                h = h * 31 + thisBytes[i];
            }
            if (h == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }

    public InputStream newInput() {
        return new ByteArrayInputStream(this.bytes);
    }

    public static Output newOutput(int initialCapacity) {
        return new Output(new ByteArrayOutputStream(initialCapacity));
    }

    public static Output newOutput() {
        return ByteString.newOutput(32);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 3486210277801140074L;
        private final byte[] bytes;

        public SerializationProxy(ByteString s) {
            this.bytes = s.bytes;
        }

        private Object readResolve() {
            return ByteString.copyFrom(this.bytes);
        }
    }

    public static final class Output
    extends FilterOutputStream
    implements Builder<ByteString> {
        private final ByteArrayOutputStream bout;

        private Output(ByteArrayOutputStream bout) {
            super(bout);
            this.bout = bout;
        }

        @Override
        public ByteString build() {
            byte[] byteArray = this.bout.toByteArray();
            return new ByteString(byteArray);
        }
    }
}

