/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.derquinse.common.base.ByteString;
import net.derquinse.common.base.NotInstantiable;

public final class Digests
extends NotInstantiable {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA512 = "SHA-512";

    private Digests() {
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        Preconditions.checkNotNull((Object)algorithm, (Object)"The digest algorithm must be provided");
        return MessageDigest.getInstance(algorithm);
    }

    private static MessageDigest getInstanceUnchecked(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("No %s algorithm", algorithm), e);
        }
    }

    public static ByteString getDigest(byte[] data, MessageDigest md) {
        return ByteString.copyFrom(md.digest(data));
    }

    public static ByteString getDigest(InputSupplier<? extends InputStream> supplier, MessageDigest md) throws IOException {
        return ByteString.copyFrom(ByteStreams.getDigest(supplier, (MessageDigest)md));
    }

    public static MessageDigest md5() {
        return Digests.getInstanceUnchecked(MD5);
    }

    public static ByteString md5(byte[] data) {
        return Digests.getDigest(data, Digests.md5());
    }

    public static ByteString md5(InputSupplier<? extends InputStream> supplier) throws IOException {
        return Digests.getDigest(supplier, Digests.md5());
    }

    public static MessageDigest sha1() {
        return Digests.getInstanceUnchecked(SHA1);
    }

    public static ByteString sha1(byte[] data) {
        return Digests.getDigest(data, Digests.sha1());
    }

    public static ByteString sha1(InputSupplier<? extends InputStream> supplier) throws IOException {
        return Digests.getDigest(supplier, Digests.sha1());
    }

    public static MessageDigest sha256() {
        return Digests.getInstanceUnchecked(SHA256);
    }

    public static ByteString sha256(byte[] data) {
        return Digests.getDigest(data, Digests.sha256());
    }

    public static ByteString sha256(InputSupplier<? extends InputStream> supplier) throws IOException {
        return Digests.getDigest(supplier, Digests.sha256());
    }

    public static MessageDigest sha512() {
        return Digests.getInstanceUnchecked(SHA512);
    }

    public static ByteString sha512(byte[] data) {
        return Digests.getDigest(data, Digests.sha512());
    }

    public static ByteString sha512(InputSupplier<? extends InputStream> supplier) throws IOException {
        return Digests.getDigest(supplier, Digests.sha512());
    }
}

