/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.base.Objects;

public final class IntegerWaterMark {
    private final int current;
    private final int max;
    private final int min;

    public static final IntegerWaterMark of(int initialValue) {
        return new IntegerWaterMark(initialValue);
    }

    public static final IntegerWaterMark of() {
        return IntegerWaterMark.of(0);
    }

    private IntegerWaterMark(int initialValue) {
        this.current = initialValue;
        this.min = initialValue;
        this.max = initialValue;
    }

    private IntegerWaterMark(IntegerWaterMark previous, int value) {
        this.current = value;
        this.min = Math.min(value, previous.min);
        this.max = Math.max(value, previous.max);
    }

    public int get() {
        return this.current;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public IntegerWaterMark set(int value) {
        if (this.current == value) {
            return this;
        }
        return new IntegerWaterMark(this, value);
    }

    public IntegerWaterMark add(int value) {
        return this.set(this.current + value);
    }

    public IntegerWaterMark inc() {
        return this.add(1);
    }

    public IntegerWaterMark dec() {
        return this.add(-1);
    }

    public int hashCode() {
        return ((527 + this.current) * 31 + this.min) * 31 + this.max;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerWaterMark) {
            IntegerWaterMark m = (IntegerWaterMark)obj;
            return this.current == m.current && this.min == m.min && this.max == m.max;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("current", this.current).add("min", this.min).add("max", this.max).toString();
    }
}

