/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.base.Objects;
import com.google.common.primitives.Longs;

public final class LongWaterMark {
    private final long current;
    private final long max;
    private final long min;

    public static final LongWaterMark of(long initialValue) {
        return new LongWaterMark(initialValue);
    }

    public static final LongWaterMark of() {
        return LongWaterMark.of(0L);
    }

    private LongWaterMark(long initialValue) {
        this.current = initialValue;
        this.min = initialValue;
        this.max = initialValue;
    }

    private LongWaterMark(LongWaterMark previous, long value) {
        this.current = value;
        this.min = Math.min(value, previous.min);
        this.max = Math.max(value, previous.max);
    }

    public long get() {
        return this.current;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public LongWaterMark set(long value) {
        if (this.current == value) {
            return this;
        }
        return new LongWaterMark(this, value);
    }

    public LongWaterMark add(long value) {
        return this.set(this.current + value);
    }

    public LongWaterMark inc() {
        return this.add(1L);
    }

    public LongWaterMark dec() {
        return this.add(-1L);
    }

    public int hashCode() {
        return ((527 + Longs.hashCode((long)this.current)) * 31 + Longs.hashCode((long)this.min)) * 31 + Longs.hashCode((long)this.max);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LongWaterMark) {
            LongWaterMark m = (LongWaterMark)obj;
            return this.current == m.current && this.min == m.min && this.max == m.max;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("current", this.current).add("min", this.min).add("max", this.max).toString();
    }
}

