/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.derquinse.common.base.NotInstantiable;

public final class MoreFunctions
extends NotInstantiable {
    private MoreFunctions() {
    }

    public static <F, T> Function<F, T> nullSafe(Function<F, T> f) {
        return new NullSafeFunction(f);
    }

    public static <T> Function<T, Optional<T>> fromNullable() {
        return new FromNullable();
    }

    private static class FromNullable<T>
    implements Function<T, Optional<T>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private FromNullable() {
        }

        public Optional<T> apply(T from) {
            return Optional.fromNullable(from);
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof FromNullable;
        }

        public String toString() {
            return "FromNullable";
        }
    }

    private static class NullSafeFunction<F, T>
    implements Function<F, T>,
    Serializable {
        private final Function<F, T> delegate;
        private static final long serialVersionUID = 0L;

        private NullSafeFunction(Function<F, T> delegate) {
            this.delegate = (Function)Preconditions.checkNotNull(delegate, (Object)"The function to decorate must be provided");
        }

        public T apply(F from) {
            if (from == null) {
                return null;
            }
            return (T)this.delegate.apply(from);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof NullSafeFunction) {
                NullSafeFunction that = (NullSafeFunction)obj;
                return this.delegate.equals(that.delegate);
            }
            return false;
        }

        public String toString() {
            return "NullSafe(" + this.delegate + ")";
        }
    }
}

