/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.base;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.derquinse.common.base.NotInstantiable;

public final class MorePredicates
extends NotInstantiable {
    private MorePredicates() {
    }

    public static <T> Predicate<T> sameAs(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsSameAsPredicate(target);
    }

    public static <T extends Comparable<T>> Predicate<T> greaterThan(T value) {
        return new GreaterThan(value, null);
    }

    public static <T extends Comparable<T>> Predicate<T> lessThan(T value) {
        return new LessThan(value, null);
    }

    public static <T extends Comparable<T>> Predicate<T> greaterOrEqual(T value) {
        return new GreaterOrEqual(value, null);
    }

    public static <T extends Comparable<T>> Predicate<T> lessOrEqual(T value) {
        return new LessOrEqual(value, null);
    }

    private static class LessOrEqual<T extends Comparable<T>>
    extends ComparisonPredicate<T> {
        private static final long serialVersionUID = 0L;

        private LessOrEqual(T value) {
            super(value);
        }

        @Override
        public boolean apply(int result) {
            return result <= 0;
        }

        /* synthetic */ LessOrEqual(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static class GreaterOrEqual<T extends Comparable<T>>
    extends ComparisonPredicate<T> {
        private static final long serialVersionUID = 0L;

        private GreaterOrEqual(T value) {
            super(value);
        }

        @Override
        public boolean apply(int result) {
            return result >= 0;
        }

        /* synthetic */ GreaterOrEqual(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static class LessThan<T extends Comparable<T>>
    extends ComparisonPredicate<T> {
        private static final long serialVersionUID = 0L;

        private LessThan(T value) {
            super(value);
        }

        @Override
        public boolean apply(int result) {
            return result < 0;
        }

        /* synthetic */ LessThan(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static class GreaterThan<T extends Comparable<T>>
    extends ComparisonPredicate<T> {
        private static final long serialVersionUID = 0L;

        private GreaterThan(T value) {
            super(value);
        }

        @Override
        public boolean apply(int result) {
            return result > 0;
        }

        /* synthetic */ GreaterThan(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static abstract class ComparisonPredicate<T extends Comparable<T>>
    implements Predicate<T>,
    Serializable {
        private final T value;
        private static final long serialVersionUID = 0L;

        ComparisonPredicate(T value) {
            this.value = (Comparable)Preconditions.checkNotNull(value, (Object)"The comparison reference must be provided");
        }

        public final boolean apply(T t) {
            return this.apply(((Comparable)Preconditions.checkNotNull(t, (Object)"The value to compare must be provided")).compareTo(this.value));
        }

        abstract boolean apply(int var1);

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value, this.getClass()});
        }

        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof ComparisonPredicate) {
                ComparisonPredicate other = (ComparisonPredicate)obj;
                return this.getClass() == other.getClass() && this.value.equals(other.value);
            }
            return false;
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.value);
        }
    }

    private static class IsSameAsPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;
        private static final long serialVersionUID = 0L;

        private IsSameAsPredicate(T target) {
            this.target = target;
        }

        public boolean apply(T t) {
            return this.target == t;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IsSameAsPredicate) {
                IsSameAsPredicate that = (IsSameAsPredicate)obj;
                return this.target == that.target;
            }
            return false;
        }

        public String toString() {
            return "IsSameAs(" + this.target + ")";
        }
    }
}

