/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.derquinse.common.collect.Hierarchy;

public abstract class AbstractHierarchy<E>
implements Hierarchy<E> {
    static <E> E checkRequired(E element) {
        return (E)Preconditions.checkNotNull(element, (Object)"Null elements not allowed");
    }

    AbstractHierarchy() {
    }

    final E checkMember(E element) {
        Preconditions.checkArgument((boolean)this.elementSet().contains(AbstractHierarchy.checkRequired(element)), (String)"The provided element [%s] is not part of the hierarchy", (Object[])new Object[]{element});
        return element;
    }

    @Override
    public boolean isEmpty() {
        return this.elementSet().isEmpty();
    }

    @Override
    public int size() {
        return this.elementSet().size();
    }

    @Override
    public boolean contains(E element) {
        return this.elementSet().contains(element);
    }

    @Override
    public boolean containsAll(Iterable<? extends E> elements) {
        Collection collection = elements instanceof Collection ? (Collection)elements : Sets.newHashSet(elements);
        return this.elementSet().containsAll(collection);
    }

    @Override
    public E getRoot() {
        List firstLevel = this.getFirstLevel();
        Preconditions.checkArgument((firstLevel.size() == 1 ? 1 : 0) != 0, (Object)"The hierarchy is not rooted");
        return firstLevel.get(0);
    }

    @Override
    public boolean isRooted() {
        return this.getFirstLevel().size() == 1;
    }

    @Override
    public List<E> getSiblings(E element) {
        E parent = this.getParent(element);
        return parent == null ? this.getFirstLevel() : this.getChildren(parent);
    }

    @Override
    public int getIndex(E element) {
        return this.getSiblings(element).indexOf(element);
    }

    @Override
    public Iterable<E> getAncestors(E element) {
        return new AncestorsIterable(this.checkMember(element));
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Object element : this.getFirstLevel()) {
            h += this.hashCode(0, element);
        }
        return h;
    }

    private int hashCode(int level, E element) {
        int h = element.hashCode() ^ level;
        int next = level + 1;
        for (E child : this.getChildren(element)) {
            h += this.hashCode(next, child);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Hierarchy) {
            Hierarchy h = (Hierarchy)obj;
            if (this.isRooted() == h.isRooted() && this.size() == h.size()) {
                return this.equals(null, h);
            }
        }
        return false;
    }

    public String toString() {
        final Joiner j = Joiner.on((String)", ");
        Function f = new Function<E, String>(){

            public String apply(E input) {
                String element = input.toString();
                List children = AbstractHierarchy.this.getChildren(input);
                if (children.isEmpty()) {
                    return element;
                }
                StringBuilder b = new StringBuilder(element).append('[');
                j.appendTo(b, Iterables.transform(children, (Function)this));
                return b.append(']').toString();
            }
        };
        StringBuilder b = new StringBuilder("Hierarchy[");
        j.appendTo(b, Iterables.transform(this.getFirstLevel(), (Function)f));
        return b.append(']').toString();
    }

    private boolean equals(@Nullable E element, Hierarchy<Object> other) {
        List<E> a = this.getChildren(element);
        if (((Object)a).equals(other.getChildren(element))) {
            for (E e : a) {
                if (this.equals(e, other)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final class AncestorsIterable
    implements Iterable<E> {
        private final E element;

        AncestorsIterable(E start) {
            this.element = start;
        }

        @Override
        public Iterator<E> iterator() {
            return new AncestorsIterator(this.element);
        }
    }

    final class AncestorsIterator
    extends UnmodifiableIterator<E> {
        private E current;

        AncestorsIterator(E start) {
            this.current = start;
        }

        public boolean hasNext() {
            return AbstractHierarchy.this.getParent(this.current) != null;
        }

        public E next() {
            Object parent = AbstractHierarchy.this.getParent(this.current);
            if (parent == null) {
                throw new NoSuchElementException("No more ancestors.");
            }
            this.current = parent;
            return parent;
        }
    }
}

