/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nullable;
import net.derquinse.common.collect.ImmutableHierarchy;

final class FlatImmutableHierarchy<E>
extends ImmutableHierarchy<E> {
    private final ImmutableSet<E> set;

    FlatImmutableHierarchy(Iterable<? extends E> elements) {
        this.set = ImmutableSet.copyOf(elements);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.set;
    }

    @Override
    public List<E> getChildren(@Nullable E element) {
        if (element == null) {
            return this.getFirstLevel();
        }
        this.checkMember(element);
        return ImmutableList.of();
    }

    @Override
    public List<E> getFirstLevel() {
        return this.set.asList();
    }

    @Override
    public E getParent(E element) {
        this.checkMember(element);
        return null;
    }

    @Override
    ImmutableSet<E> getMemberDescendants(E element) {
        this.checkMember(element);
        return ImmutableSet.of();
    }
}

