/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.derquinse.common.base.NotInstantiable;
import net.derquinse.common.collect.Hierarchy;
import net.derquinse.common.collect.HierarchyVisitor;

@Beta
public final class Hierarchies
extends NotInstantiable {
    private Hierarchies() {
    }

    private static <E> Hierarchy<E> check(Hierarchy<E> hierarchy) {
        return (Hierarchy)Preconditions.checkNotNull(hierarchy, (Object)"The hierarchy is required");
    }

    private static <E> HierarchyVisitor<E> check(HierarchyVisitor<E> visitor) {
        return (HierarchyVisitor)Preconditions.checkNotNull(visitor, (Object)"The visitor is required");
    }

    public static <E> void visitDepthFirst(Hierarchy<E> hierarchy, HierarchyVisitor<? super E> visitor) {
        Hierarchies.visitDepthFirst(Hierarchies.check(hierarchy), null, hierarchy.getFirstLevel(), Hierarchies.check(visitor));
    }

    public static <E> void visitDepthFirst(Hierarchy<E> hierarchy, HierarchyVisitor<? super E> visitor, @Nullable E element, boolean includeStarting) {
        if (element == null) {
            Hierarchies.visitDepthFirst(hierarchy, visitor);
        } else {
            Hierarchies.check(hierarchy);
            Hierarchies.check(visitor);
            Preconditions.checkArgument((boolean)hierarchy.contains(element), (Object)"The element is not part of the hierarchy");
            if (includeStarting) {
                visitor.visit(element, hierarchy.getParent(element), hierarchy.getIndex(element));
            }
            Hierarchies.visitDepthFirst(hierarchy, element, hierarchy.getChildren(element), visitor);
        }
    }

    private static <E> void visitDepthFirst(Hierarchy<E> hierarchy, E parent, Iterable<E> elements, HierarchyVisitor<? super E> visitor) {
        int i = 0;
        for (E element : elements) {
            visitor.visit(element, parent, i++);
            Hierarchies.visitDepthFirst(hierarchy, element, hierarchy.getChildren(element), visitor);
        }
    }
}

