/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.derquinse.common.collect.AbstractHierarchy;
import net.derquinse.common.collect.EmptyImmutableHierarchy;
import net.derquinse.common.collect.FlatImmutableHierarchy;
import net.derquinse.common.collect.Hierarchy;
import net.derquinse.common.collect.RegularImmutableHierarchy;

public abstract class ImmutableHierarchy<E>
extends AbstractHierarchy<E> {
    public static <E> ImmutableHierarchy<E> of() {
        return EmptyImmutableHierarchy.INSTANCE;
    }

    public static <E> ImmutableHierarchy<E> copyOf(Hierarchy<? extends E> hierarchy) {
        Preconditions.checkNotNull(hierarchy, (Object)"The source hierachy must be provided");
        if (hierarchy instanceof ImmutableHierarchy) {
            ImmutableHierarchy h = (ImmutableHierarchy)hierarchy;
            return h;
        }
        if (hierarchy.isEmpty()) {
            return ImmutableHierarchy.of();
        }
        Builder<Object> builder = ImmutableHierarchy.builder();
        return builder.addHierarchy(null, hierarchy, null, true).build();
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builder(boolean outOfOrder) {
        return new Builder().setAllowOutOfOrder(outOfOrder);
    }

    ImmutableHierarchy() {
    }

    @Override
    public abstract ImmutableSet<E> elementSet();

    @Override
    public final ImmutableSet<E> getDescendants(@Nullable E element) {
        if (element == null) {
            return this.elementSet();
        }
        return this.getMemberDescendants(element);
    }

    abstract ImmutableSet<E> getMemberDescendants(E var1);

    public static final class Builder<E>
    implements net.derquinse.common.base.Builder<ImmutableHierarchy<E>> {
        private final Set<E> elements = Sets.newHashSet();
        private final Set<E> unaddedParents = Sets.newHashSet();
        private final List<E> firstLevel = Lists.newLinkedList();
        private final Map<E, E> parents = Maps.newHashMap();
        private final ListMultimap<E, E> children = LinkedListMultimap.create();
        private boolean allowOutOfOrder;

        private Builder(boolean allowOutOfOrder) {
            this.allowOutOfOrder = allowOutOfOrder;
        }

        private Builder() {
            this(false);
        }

        private void checkReady() {
            Preconditions.checkState((boolean)this.unaddedParents.isEmpty(), (Object)"There are referenced parents that have not been added yet.");
        }

        Set<E> getElements() {
            this.checkReady();
            return this.elements;
        }

        List<E> getFirstLevel() {
            this.checkReady();
            return this.firstLevel;
        }

        Map<E, E> getParents() {
            return this.parents;
        }

        ListMultimap<E, E> getChildren() {
            this.checkReady();
            return this.children;
        }

        public boolean isAllowOutOfOrder() {
            return this.allowOutOfOrder;
        }

        public Builder<E> setAllowOutOfOrder(boolean allowOutOfOrder) {
            this.allowOutOfOrder = allowOutOfOrder;
            return this;
        }

        public Builder<E> add(E parent, E element) {
            Preconditions.checkArgument((!this.elements.contains(element) ? 1 : 0) != 0, (Object)"Duplicate entries not allowed in a hierarchy");
            if (parent == null) {
                this.firstLevel.add(element);
            } else {
                if (!this.allowOutOfOrder) {
                    Preconditions.checkArgument((boolean)this.elements.contains(parent), (Object)"Parent not found in the hierarchy");
                }
                E p = parent;
                HashSet visited = Sets.newHashSet((Object[])new Object[]{element});
                while (p != null) {
                    Preconditions.checkState((boolean)visited.add(p), (String)"Loop detected: element [%s] visited twice", (Object[])new Object[]{p});
                    p = this.parents.get(p);
                }
                this.children.put(parent, element);
                this.parents.put(element, parent);
                if (!this.elements.contains(parent)) {
                    this.unaddedParents.add(parent);
                }
            }
            this.unaddedParents.remove(element);
            this.elements.add(element);
            return this;
        }

        public Builder<E> addAll(E parent, Iterable<? extends E> elements) {
            for (E element : elements) {
                this.add(parent, element);
            }
            return this;
        }

        public Builder<E> addAll(E parent, E ... elements) {
            for (E element : elements) {
                this.add(parent, element);
            }
            return this;
        }

        private static <T> Hierarchy<T> check(Hierarchy<? extends T> hierarchy) {
            Preconditions.checkNotNull(hierarchy, (Object)"The source hierarchy is required");
            Hierarchy<? extends T> h = hierarchy;
            return h;
        }

        public Builder<E> addHierarchy(E parent, Hierarchy<? extends E> hierarchy, @Nullable E root, boolean includeRoot) {
            List<? extends E> level;
            Hierarchy<E> h = Builder.check(hierarchy);
            Preconditions.checkArgument((root == null || hierarchy.elementSet().contains(root) ? 1 : 0) != 0);
            if (root != null) {
                if (includeRoot) {
                    this.add(parent, root);
                    parent = root;
                }
                level = h.getChildren(root);
            } else {
                level = h.getFirstLevel();
            }
            this.addHierarchyRec(parent, h, level);
            return this;
        }

        private void addHierarchyRec(E parent, Hierarchy<E> hierarchy, List<E> level) {
            for (E element : level) {
                this.add(parent, element);
                this.addHierarchyRec(element, hierarchy, hierarchy.getChildren(element));
            }
        }

        public <F> Builder<E> addHierarchy(E parent, Hierarchy<F> hierarchy, @Nullable F root, boolean includeRoot, Function<? super F, E> function) {
            List<F> level;
            Hierarchy<F> h = Builder.check(hierarchy);
            Preconditions.checkNotNull(hierarchy, (Object)"The transformation function is required");
            Preconditions.checkArgument((root == null || hierarchy.elementSet().contains(root) ? 1 : 0) != 0);
            if (root != null) {
                if (includeRoot) {
                    Object newRoot = function.apply(root);
                    this.add(parent, newRoot);
                    parent = newRoot;
                }
                level = h.getChildren(root);
            } else {
                level = h.getFirstLevel();
            }
            this.addHierarchyRec(parent, h, level, function);
            return this;
        }

        private <F> void addHierarchyRec(E parent, Hierarchy<F> hierarchy, List<F> level, Function<? super F, E> function) {
            for (F element : level) {
                Object transformed = function.apply(element);
                this.add(parent, transformed);
                this.addHierarchyRec(transformed, hierarchy, hierarchy.getChildren(element), function);
            }
        }

        @Override
        public ImmutableHierarchy<E> build() {
            this.checkReady();
            if (this.elements.isEmpty()) {
                return ImmutableHierarchy.of();
            }
            if (this.children.isEmpty()) {
                return new FlatImmutableHierarchy<E>(this.firstLevel);
            }
            return new RegularImmutableHierarchy(this);
        }
    }
}

